/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoVerificationException;
import org.picocontainer.PicoVisitor;
import org.picocontainer.defaults.AbstractPicoVisitor;

public class VerifyingVisitor
extends AbstractPicoVisitor {
    private final List nestedVerificationExceptions = new ArrayList();
    private final Set verifiedComponentAdapters = new HashSet();
    private final PicoVisitor componentAdapterCollector = new ComponentAdapterCollector();
    private PicoContainer currentPico;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object traverse(Object node) throws PicoVerificationException {
        this.nestedVerificationExceptions.clear();
        this.verifiedComponentAdapters.clear();
        try {
            super.traverse(node);
            if (!this.nestedVerificationExceptions.isEmpty()) {
                throw new PicoVerificationException(new ArrayList(this.nestedVerificationExceptions));
            }
        }
        finally {
            this.nestedVerificationExceptions.clear();
            this.verifiedComponentAdapters.clear();
        }
        return Void.TYPE;
    }

    public void visitContainer(PicoContainer pico) {
        this.checkTraversal();
        this.currentPico = pico;
    }

    public void visitComponentAdapter(ComponentAdapter componentAdapter) {
        this.checkTraversal();
        if (!this.verifiedComponentAdapters.contains(componentAdapter)) {
            try {
                componentAdapter.verify(this.currentPico);
            }
            catch (RuntimeException e) {
                this.nestedVerificationExceptions.add(e);
            }
            componentAdapter.accept(this.componentAdapterCollector);
        }
    }

    public void visitParameter(Parameter parameter) {
        this.checkTraversal();
    }

    private class ComponentAdapterCollector
    implements PicoVisitor {
        private ComponentAdapterCollector() {
        }

        public Object traverse(Object node) {
            return null;
        }

        public void visitContainer(PicoContainer pico) {
        }

        public void visitComponentAdapter(ComponentAdapter componentAdapter) {
            VerifyingVisitor.this.verifiedComponentAdapters.add(componentAdapter);
        }

        public void visitParameter(Parameter parameter) {
        }
    }
}

