/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ddl.LiquibaseDDLGenerator;
import ca.sqlpower.architect.ddl.LiquibaseSettings;
import ca.sqlpower.architect.swingui.Messages;
import ca.sqlpower.swingui.DataEntryPanel;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import net.miginfocom.swing.MigLayout;

public class LiquibaseOptionsPanel
implements DataEntryPanel {
    private JPanel panel;
    private LiquibaseDDLGenerator ddlGenerator;
    private JCheckBox useChangeSets;
    private JTextField authorField;
    private JLabel authorLabel;
    private JCheckBox generateId;
    private JCheckBox useAddPKTagForSingleColumns;
    private JSpinner startId;
    private JLabel startValueLabel;

    public LiquibaseOptionsPanel() {
        this.setup();
    }

    public void setGenerator(LiquibaseDDLGenerator generator) {
        this.ddlGenerator = generator;
    }

    protected int getIdStart() {
        Integer start = (Integer)this.startId.getValue();
        return start == null ? 0 : start;
    }

    protected boolean getUseChangeSets() {
        return this.useChangeSets.isSelected();
    }

    protected String getAuthor() {
        return this.authorField.getText();
    }

    protected boolean getGenerateId() {
        return this.generateId.isSelected();
    }

    private void setup() {
        this.panel = new JPanel((LayoutManager)new MigLayout());
        this.useChangeSets = new JCheckBox(Messages.getString("LiquibaseOptionsPanel.useChangeSet"));
        this.useAddPKTagForSingleColumns = new JCheckBox(Messages.getString("LiquibaseOptionsPanel.alwaysUseAddPK"));
        this.generateId = new JCheckBox(Messages.getString("LiquibaseOptionsPanel.generateID"));
        this.authorLabel = new JLabel(Messages.getString("LiquibaseOptionsPanel.authorName"));
        this.authorField = new JTextField(20);
        this.startValueLabel = new JLabel(Messages.getString("LiquibaseOptionsPanel.idStart"));
        SpinnerNumberModel model = new SpinnerNumberModel(1, 1, 9999, 1);
        this.startId = new JSpinner(model);
        this.panel.add((Component)this.useAddPKTagForSingleColumns, "wrap");
        this.panel.add(this.useChangeSets);
        this.panel.add(this.authorLabel);
        this.panel.add((Component)this.authorField, "wrap");
        this.panel.add(this.generateId);
        this.panel.add(this.startValueLabel);
        this.panel.add(this.startId);
    }

    public void restoreSettings(LiquibaseSettings settings) {
        if (settings == null) {
            return;
        }
        String author = settings.getAuthor();
        this.authorField.setText(author == null ? "" : author);
        this.useChangeSets.setSelected(settings.getUseSeparateChangeSets());
        this.generateId.setSelected(settings.getGenerateId());
        int start = settings.getIdStart();
        if (start > 0) {
            this.startId.setValue(start);
        }
        this.useAddPKTagForSingleColumns.setSelected(settings.getUseAddPKTagForSingleColumns());
    }

    public LiquibaseSettings getLiquibaseSettings() {
        LiquibaseSettings settings = new LiquibaseSettings();
        settings.setAuthor(this.getAuthor());
        settings.setGenerateId(this.getGenerateId());
        settings.setUseSeparateChangeSets(this.getUseChangeSets());
        settings.setIdStart(this.getIdStart());
        settings.setUseAddPKTagForSingleColumns(this.useAddPKTagForSingleColumns.isSelected());
        return settings;
    }

    public boolean applyChanges() {
        this.ddlGenerator.setUseSeparateChangeSets(this.getUseChangeSets());
        this.ddlGenerator.setAuthor(this.getAuthor());
        this.ddlGenerator.setGenerateId(this.getGenerateId());
        this.ddlGenerator.setIdStart(this.getIdStart());
        this.ddlGenerator.setUseAddPKTagForSingleColumns(this.useAddPKTagForSingleColumns.isSelected());
        return true;
    }

    public void discardChanges() {
    }

    public JComponent getPanel() {
        return this.panel;
    }

    public boolean hasUnsavedChanges() {
        return true;
    }
}

