/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui;

import ca.sqlpower.swingui.Messages;
import ca.sqlpower.swingui.PopupListenerHandler;
import ca.sqlpower.util.BrowserUtil;
import ca.sqlpower.util.SQLPowerUtils;
import ca.sqlpower.util.Version;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.http.params.BasicHttpParams;
import org.apache.log4j.Logger;

public class SPSUtils {
    private static final Logger logger = Logger.getLogger(SPSUtils.class);
    public static final int MULTISELECT_MASK = System.getProperty("mrj.version") != null ? 256 : 128;
    public static final String SQLP_ARCHITECT_URL = "http://www.sqlpower.ca/page/architect";
    public static final String SQLP_URL = "http://www.sqlpower.ca/";
    public static final String FORUM_URL = "http://www.sqlpower.ca/page/enter_forum";
    public static final String WABIT_FAQ_URL = "http://www.sqlpower.ca/page/wabit-faq";
    public static final String DQGURU_FAQ_URL = "http://www.sqlpower.ca/page/dqguru-faq";
    public static final String ARCHITECT_FAQ_URL = "http://www.sqlpower.ca/page/architect-faq";
    public static final String WABIT_GS_URL = "http://www.sqlpower.ca/page/wabit-start";
    public static final String ARCHITECT_GS_URL = "http://www.sqlpower.ca/page/architect-start";
    public static final String DQGURU_GS_URL = "http://www.sqlpower.ca/page/dqguru-start";
    public static final String WABIT_DEMO_URL = "http://www.sqlpower.ca/page/wabit-demos";
    public static final String DQGURU_DEMO_URL = "http://www.sqlpower.ca/page/dqguru-demos";
    public static final String ARCHITECT_DEMO_URL = "http://www.sqlpower.ca/page/architect-demos";
    public static final String WABIT_UG_URL = "http://www.sqlpower.ca/page/wabit-userguide";
    public static final String ARCHITECT_UG_URL = "http://www.sqlpower.ca/page/architect-userguide";
    public static final String DQGURU_UG_URL = "http://www.sqlpower.ca/page/dqguru-userguide";
    public static final String WABIT_UPGRADE_URL = "http://www.sqlpower.ca/page/wabit-ep";
    public static final String ARCHITECT_UPGRADE_URL = "http://www.sqlpower.ca/page/architect-e";
    public static final String DQGURU_UPGRADE_URL = "http://www.sqlpower.ca/page/dqguru-e";
    public static final String WABIT_PS_URL = "http://www.sqlpower.ca/page/wabit_support";
    public static final String ARCHITECT_PS_URL = "http://www.sqlpower.ca/page/architect_support";
    public static final String DQGURU_PS_URL = "http://www.sqlpower.ca/page/dqguru_support";
    public static final Action forumAction = new AbstractAction(Messages.getString("SPSUtils.webSupportActionName"), SPSUtils.createIcon("world", "New Project")){

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                BrowserUtil.launch(SPSUtils.FORUM_URL);
            }
            catch (IOException e) {
                SPSUtils.showExceptionDialogNoReport(SPSUtils.getFrameFromActionEvent(evt), Messages.getString("SPSUtils.couldNotLaunchBrowser"), e);
            }
        }
    };
    public static final FileFilter ARCHITECT_FILE_FILTER = new FileExtensionFilter(Messages.getString("SPSUtils.architectFileType"), new String[]{"arc", "architect"});
    public static final FileFilter TEXT_FILE_FILTER = new FileExtensionFilter(Messages.getString("SPSUtils.textFileType"), new String[]{"txt"});
    public static final FileFilter SQL_FILE_FILTER = new FileExtensionFilter(Messages.getString("SPSUtils.sqlFileType"), new String[]{"sql", "ddl"});
    public static final FileFilter INI_FILE_FILTER = new FileExtensionFilter(Messages.getString("SPSUtils.iniFileType"), new String[]{"ini"});
    public static final FileFilter EXE_FILE_FILTER = new FileExtensionFilter(Messages.getString("SPSUtils.exeFileType"), new String[]{"exe"});
    public static final FileFilter JAR_ZIP_FILE_FILTER = new FileExtensionFilter(Messages.getString("SPSUtils.jarFileType"), new String[]{"jar", "zip"});
    public static final FileFilter LOG_FILE_FILTER = new FileExtensionFilter(Messages.getString("SPSUtils.logFileType"), new String[]{"log"});
    public static final FileFilter XSLT_FILE_FILTER = new FileExtensionFilter(Messages.getString("SPSUtils.xsltFileType"), new String[]{"xsl", "xslt"});
    public static final FileFilter VELOCITY_FILE_FILTER = new FileExtensionFilter(Messages.getString("SPSUtils.velocityFileType"), new String[]{"vm"});
    public static final FileFilter XML_FILE_FILTER = new FileExtensionFilter(Messages.getString("SPSUtils.xmlFileType"), new String[]{"xml"});
    public static final FileFilter PDF_FILE_FILTER = new FileExtensionFilter(Messages.getString("SPSUtils.pdfFileType"), new String[]{"pdf"});
    public static final FileFilter CSV_FILE_FILTER = new FileExtensionFilter(Messages.getString("SPSUtils.csvFileType"), new String[]{"csv"});
    public static final FileFilter HTML_FILE_FILTER = new FileExtensionFilter(Messages.getString("SPSUtils.htmlFileType"), new String[]{"html"});
    public static final FileFilter BATCH_FILE_FILTER = new FileExtensionFilter(Messages.getString("SPSUtils.batchFileType"), new String[]{"bat"});
    public static final FileFilter WABIT_FILE_FILTER = new FileExtensionFilter(Messages.getString("SPSUtils.wabitFileType"), new String[]{"wabit"});
    private static ImageIcon masterIcon;

    private static JFrame getFrameFromActionEvent(ActionEvent e) {
        if (e.getSource() instanceof Component) {
            Component c = (Component)e.getSource();
            while (c != null) {
                if (c instanceof Frame) {
                    return (JFrame)c;
                }
                c = c instanceof JPopupMenu ? ((JPopupMenu)c).getInvoker() : c.getParent();
            }
        }
        return null;
    }

    public static LabelValueBean lvb(String label, Object value) {
        return new LabelValueBean(label, value);
    }

    public static void makeJDialogCancellable(final Window w, final Action cancelAction, final boolean disposeOnCancel) {
        JRootPane c;
        if (w instanceof JFrame) {
            c = ((JFrame)w).getRootPane();
        } else if (w instanceof JDialog) {
            c = ((JDialog)w).getRootPane();
        } else {
            throw new IllegalArgumentException("The window argument has to be either a JFrame or JDialog.  You provided a " + (w == null ? null : w.getClass().getName()));
        }
        InputMap inputMap = c.getInputMap(1);
        ActionMap actionMap = c.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke("ESCAPE"), "cancel");
        actionMap.put("cancel", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (cancelAction != null) {
                    cancelAction.actionPerformed(e);
                }
                if (disposeOnCancel) {
                    w.dispose();
                }
            }
        });
    }

    public static void makeJDialogCancellable(Window w, Action cancelAction) {
        SPSUtils.makeJDialogCancellable(w, cancelAction, true);
    }

    public static ImageIcon createIcon(String name, String description, int size) {
        return SPSUtils.createIcon(name + size, description);
    }

    public static ImageIcon createIcon(String name, String description) {
        String realPath = "/icons/" + name + ".png";
        logger.debug((Object)("Loading resource " + realPath));
        URL imgURL = SPSUtils.class.getResource(realPath);
        if (imgURL == null) {
            realPath = realPath.replace(".png", ".gif");
            imgURL = SPSUtils.class.getResource(realPath);
        }
        if (imgURL != null) {
            return new ImageIcon(imgURL, description);
        }
        logger.debug((Object)("Couldn't find file: " + realPath));
        return null;
    }

    public static JDialog makeOwnedDialog(Component owningComponent, String title) {
        Window owner = SPSUtils.getWindowInHierarchy(owningComponent);
        if (owner instanceof Frame) {
            return new JDialog((Frame)owner, title);
        }
        if (owner instanceof Dialog) {
            return new JDialog((Dialog)owner, title);
        }
        JDialog d = new JDialog();
        d.setTitle(title);
        d.setAlwaysOnTop(true);
        return d;
    }

    public static Window getWindowInHierarchy(Component c) {
        if (c instanceof Window) {
            return (Window)c;
        }
        return SwingUtilities.getWindowAncestor(c);
    }

    public static JDialog showExceptionDialogNoReport(String string, Throwable ex) {
        return SPSUtils.displayExceptionDialog(null, string, null, ex);
    }

    public static JDialog showExceptionDialogNoReport(Component parent, String string, Throwable ex) {
        return SPSUtils.displayExceptionDialog(parent, string, null, ex);
    }

    public static JDialog showExceptionDialogNoReport(Component parent, String message, String subMessage, Throwable throwable) {
        return SPSUtils.displayExceptionDialog(parent, message, subMessage, throwable);
    }

    public static void setMasterIcon(ImageIcon masterIcon) {
        SPSUtils.masterIcon = masterIcon;
    }

    private static JDialog displayExceptionDialog(Component parent, String message, String subMessage, Throwable givenThrowable) {
        JDialog dialog;
        JFrame frame;
        Window owner;
        Throwable throwable = givenThrowable == null ? new Error("The throwable passed in to the exception handler was null. This is just a placeholder.") : givenThrowable;
        throwable.printStackTrace();
        Window window = owner = parent == null ? null : SPSUtils.getWindowInHierarchy(parent);
        if (owner instanceof JFrame) {
            frame = (JFrame)owner;
            dialog = new JDialog((Frame)frame, Messages.getString("SPSUtils.errorDialogTitle"));
        } else if (owner instanceof Dialog) {
            dialog = new JDialog((Dialog)owner, Messages.getString("SPSUtils.errorDialogTitle"));
        } else {
            logger.error((Object)String.format("dialog parent component %s is neither JFrame nor JDialog", owner));
            frame = new JFrame();
            if (masterIcon != null) {
                frame.setIconImage(masterIcon.getImage());
            }
            dialog = new JDialog((Frame)frame, Messages.getString("SPSUtils.errorDialogTitle"));
        }
        logger.debug((Object)"displayExceptionDialog: showing exception dialog for:", throwable);
        ((JComponent)dialog.getContentPane()).setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 5));
        String exceptionString = SQLPowerUtils.exceptionStackToString(throwable);
        JPanel top = new JPanel(new GridLayout(0, 1, 5, 5));
        StringBuilder labelText = new StringBuilder();
        labelText.append("<html><font color='red' size='+1'>");
        labelText.append(message == null ? "Unexpected error" : SPSUtils.nlToBR(message));
        labelText.append("</font>");
        if (subMessage != null) {
            labelText.append("<p>");
            labelText.append(subMessage);
        }
        JLabel messageLabel = new JLabel(labelText.toString());
        top.add(messageLabel);
        JLabel errClassLabel = new JLabel("<html><b>Exception type</b>: " + SPSUtils.nlToBR(throwable.getClass().getName()));
        top.add(errClassLabel);
        String excDetailMessage = throwable.getMessage();
        excDetailMessage = SPSUtils.trimToClosestNL(excDetailMessage, 100, 25);
        if (excDetailMessage != null) {
            top.add(new JLabel("<html><b>Detail string</b>: " + SPSUtils.nlToBR(excDetailMessage)));
            if (throwable.getCause() != null) {
                Throwable root = throwable.getCause();
                while (root.getCause() != null) {
                    if (root.getMessage() != null) {
                        String rootCauseMessage = root.getMessage();
                        rootCauseMessage = SPSUtils.trimToClosestNL(rootCauseMessage, 100, 25);
                        top.add(new JLabel("<html><b>Root Cause</b>: " + SPSUtils.nlToBR(rootCauseMessage)));
                    }
                    root = root.getCause();
                }
            }
        }
        final JButton detailsButton = new JButton(Messages.getString("SPSUtils.showExceptionDetailsButton"));
        JPanel detailsButtonPanel = new JPanel();
        detailsButtonPanel.add(detailsButton);
        JButton forumButton = new JButton(forumAction);
        detailsButtonPanel.add(forumButton);
        top.add(detailsButtonPanel);
        dialog.add((Component)top, "North");
        JScrollPane detailScroller = new JScrollPane(new JTextArea(exceptionString));
        final JPanel messageComponent = new JPanel(new BorderLayout());
        messageComponent.add((Component)detailScroller, "Center");
        messageComponent.setPreferredSize(new Dimension(700, 400));
        final JComponent fakeMessageComponent = new JComponent(){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(700, 0);
            }
        };
        final JDialog finalDialogReference = dialog;
        finalDialogReference.add((Component)fakeMessageComponent, "Center");
        ActionListener detailsAction = new ActionListener(){
            boolean showDetails = true;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.showDetails) {
                    finalDialogReference.remove(fakeMessageComponent);
                    finalDialogReference.add((Component)messageComponent, "Center");
                    detailsButton.setText(Messages.getString("SPSUtils.hideExceptionDetailsButton"));
                } else {
                    finalDialogReference.remove(messageComponent);
                    finalDialogReference.add((Component)fakeMessageComponent, "Center");
                    detailsButton.setText(Messages.getString("SPSUtils.showExceptionDetailsButton"));
                }
                finalDialogReference.pack();
                Rectangle dialogBounds = finalDialogReference.getBounds();
                Rectangle screenBounds = finalDialogReference.getGraphicsConfiguration().getBounds();
                if (!screenBounds.contains(dialogBounds)) {
                    int x = dialogBounds.x;
                    int y = dialogBounds.y;
                    if (screenBounds.x + screenBounds.width < dialogBounds.x + dialogBounds.width) {
                        x = dialogBounds.x - (dialogBounds.x + dialogBounds.width - screenBounds.x - screenBounds.width);
                    }
                    if (screenBounds.y + screenBounds.height < dialogBounds.y + dialogBounds.height) {
                        y = dialogBounds.y - (dialogBounds.y + dialogBounds.height - screenBounds.y - screenBounds.height);
                    }
                    if (screenBounds.x > x) {
                        x = screenBounds.x;
                    }
                    if (screenBounds.y > y) {
                        y = screenBounds.y;
                    }
                    finalDialogReference.setLocation(x, y);
                }
                this.showDetails = !this.showDetails;
            }
        };
        detailsButton.addActionListener(detailsAction);
        JButton okButton = new JButton(Messages.getString("SPSUtils.okButton"));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                finalDialogReference.dispose();
                finalDialogReference.setVisible(false);
            }
        });
        JPanel bottom = new JPanel();
        bottom.add(okButton);
        dialog.add((Component)bottom, "South");
        dialog.pack();
        dialog.setLocationRelativeTo(owner);
        dialog.setVisible(true);
        return dialog;
    }

    private static String trimToClosestNL(String msg, int msgLimit, int offset) {
        if (msg == null) {
            return null;
        }
        if (msg.length() > msgLimit) {
            int lastNL = msg.indexOf("\n", msgLimit - offset);
            int nextNL = msg.indexOf("\n", msgLimit);
            int endIndex = lastNL;
            if (lastNL < 0 || lastNL > msgLimit + offset) {
                endIndex = msgLimit;
            } else if ((lastNL < msgLimit || lastNL > msgLimit + offset) && nextNL >= 0 && nextNL <= msgLimit + offset && msgLimit - lastNL > nextNL - msgLimit) {
                endIndex = nextNL;
            }
            msg = msg.substring(0, endIndex) + " ...";
        }
        return msg;
    }

    static String nlToBR(String s) {
        logger.debug((Object)("String s is " + s));
        return s.replaceAll("\n", "<br>");
    }

    public static String niceClassName(Object o) {
        Class<?> c = o.getClass();
        String name = c.getName();
        int lastDot = name.lastIndexOf(46);
        if (lastDot == -1) {
            return name;
        }
        return name.substring(lastDot + 1);
    }

    public static boolean saveDocument(Component owner, Document doc, FileExtensionFilter filter) {
        File file;
        JFileChooser fc = new JFileChooser();
        fc.setFileFilter(filter);
        int returnVal = fc.showSaveDialog(owner);
        while (true) {
            boolean wantToOverwrite;
            if (returnVal == 1) {
                return false;
            }
            if (returnVal != 0) continue;
            file = fc.getSelectedFile();
            String fileName = file.getPath();
            String fileExt = FileExtensionFilter.getExtension(file);
            if (fileExt.length() == 0) {
                file = new File(fileName + "." + filter.getFilterExtension(new Integer(0)));
            }
            if (!file.exists()) break;
            int choice = JOptionPane.showOptionDialog(owner, Messages.getString("SPSUtils.fileOverwriteConfirmation"), Messages.getString("SPSUtils.confirmOverwriteButton"), 0, 3, null, null, null);
            boolean bl = wantToOverwrite = choice == 0;
            if (wantToOverwrite) break;
            returnVal = fc.showSaveDialog(owner);
        }
        return SPSUtils.writeDocument(doc, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeDocument(Document doc, File file) {
        PrintWriter out = null;
        try {
            String s;
            StringReader sr = new StringReader(doc.getText(0, doc.getLength()));
            BufferedReader br = new BufferedReader(sr);
            out = new PrintWriter(file);
            while ((s = br.readLine()) != null) {
                out.println(s);
            }
            out.flush();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            SPSUtils.showExceptionDialogNoReport(Messages.getString("SPSUtils.couldNotSaveFileError"), e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public static Polygon createArrowhead(int xHead, int yHead, int xTail, int yTail, int height, int width) {
        Polygon polygon = new Polygon();
        polygon.addPoint(xHead, yHead);
        if (yHead == yTail) {
            if (xHead > xTail) {
                polygon.addPoint(xHead - height, yHead - width / 2);
                polygon.addPoint(xHead - height, yHead + width / 2);
            } else {
                polygon.addPoint(xHead + height, yHead - width / 2);
                polygon.addPoint(xHead + height, yHead + width / 2);
            }
            return polygon;
        }
        if (xHead == xTail) {
            if (yHead > yTail) {
                polygon.addPoint(xHead - width / 2, yHead - height);
                polygon.addPoint(xHead + width / 2, yHead - height);
            } else {
                polygon.addPoint(xHead - width / 2, yHead + height);
                polygon.addPoint(xHead + width / 2, yHead + height);
            }
            return polygon;
        }
        double m = (yHead - yTail) / (xHead - xTail);
        double n = (double)yHead - m * (double)xHead;
        double b = (double)(-2 * xHead) - (double)(2 * yHead) * m + 2.0 * m * n;
        double a = m * m + 1.0;
        double c = (double)(xHead * xHead + yHead * yHead) - (double)(2 * yHead) * n + n * n - (double)(height * height);
        double xBase = (-b + Math.sqrt(b * b - 4.0 * a * c)) / (2.0 * a);
        if (!(xBase < (double)xHead && xBase > (double)xTail || xBase > (double)xHead && xBase < (double)xTail)) {
            xBase = (-b - Math.sqrt(b * b - 4.0 * a * c)) / (2.0 * a);
        }
        double yBase = m * xBase + n;
        logger.debug((Object)("The base point is (" + xBase + ", " + yBase + ")"));
        double mInv = -1.0 / m;
        double nInv = yBase - mInv * xBase;
        a = mInv * mInv + 1.0;
        b = -2.0 * xBase - 2.0 * yBase * mInv + 2.0 * mInv * nInv;
        c = xBase * xBase + yBase * yBase - 2.0 * yBase * nInv + nInv * nInv - (double)(width / 2 * (width / 2));
        int xPoint = (int)((-b + Math.sqrt(b * b - 4.0 * a * c)) / (2.0 * a));
        int yPoint = (int)(mInv * (double)xPoint + nInv);
        logger.debug((Object)(" x is " + xPoint + " y is " + yPoint));
        polygon.addPoint(xPoint, yPoint);
        xPoint = (int)((-b - Math.sqrt(b * b - 4.0 * a * c)) / (2.0 * a));
        yPoint = (int)(mInv * (double)xPoint + nInv);
        polygon.addPoint(xPoint, yPoint);
        return polygon;
    }

    public static void breakLongMenu(Window heightReference, JMenu input) {
        if (input.getItemCount() <= 0) {
            return;
        }
        int windowHeight = heightReference.getSize().height;
        int totalRows = input.getItemCount();
        int preferredHeight = input.getItem((int)0).getPreferredSize().height;
        int FUDGE = 3;
        int rowsPerSubMenu = windowHeight / preferredHeight - 3;
        if (rowsPerSubMenu < 3) {
            rowsPerSubMenu = 3;
        }
        if (totalRows <= rowsPerSubMenu) {
            return;
        }
        JMenu parentMenu = input;
        JMenu subMenu = new JMenu(Messages.getString("SPSUtils.moreSubmenu"));
        parentMenu.add(subMenu);
        while (input.getItemCount() > rowsPerSubMenu + 1) {
            JMenuItem item = input.getItem(rowsPerSubMenu);
            subMenu.add(item);
            if (subMenu.getItemCount() < rowsPerSubMenu || input.getItemCount() <= rowsPerSubMenu + 1) continue;
            parentMenu = subMenu;
            subMenu = new JMenu(Messages.getString("SPSUtils.moreSubmenu"));
            parentMenu.add(subMenu);
        }
    }

    public static BasicStroke getAdjustedStroke(BasicStroke original, double viewScale) {
        float[] adjustedDashArray = original.getDashArray();
        if (adjustedDashArray != null) {
            int i = 0;
            while (i < adjustedDashArray.length) {
                int n = i++;
                adjustedDashArray[n] = (float)((double)adjustedDashArray[n] / viewScale);
            }
        }
        return new BasicStroke((float)((double)original.getLineWidth() / viewScale), original.getEndCap(), original.getLineJoin(), Math.max(1.0f, (float)((double)original.getMiterLimit() / viewScale)), adjustedDashArray, original.getDashPhase());
    }

    public static JPanel getBrandedTreePanel(JTree tree) {
        class ScrollableDelegatePanelClassThingThatsNotAnonymous
        extends JPanel
        implements Scrollable {
            Scrollable scrollable;
            final /* synthetic */ JTree val$tree;

            ScrollableDelegatePanelClassThingThatsNotAnonymous(JTree jTree) {
                this.val$tree = jTree;
                this.scrollable = this.val$tree;
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension realPrefSize = super.getPreferredSize();
                JViewport viewport = (JViewport)SwingUtilities.getAncestorOfClass(JViewport.class, this);
                if (viewport != null) {
                    realPrefSize.width = Math.max(viewport.getWidth(), realPrefSize.width);
                    realPrefSize.height = Math.max(viewport.getHeight(), realPrefSize.height);
                }
                return realPrefSize;
            }

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                return this.scrollable.getPreferredScrollableViewportSize();
            }

            @Override
            public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
                return this.scrollable.getScrollableBlockIncrement(visibleRect, orientation, direction);
            }

            @Override
            public boolean getScrollableTracksViewportHeight() {
                return this.scrollable.getScrollableTracksViewportHeight();
            }

            @Override
            public boolean getScrollableTracksViewportWidth() {
                return this.scrollable.getScrollableTracksViewportWidth();
            }

            @Override
            public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
                return this.scrollable.getScrollableUnitIncrement(visibleRect, orientation, direction);
            }
        }
        ScrollableDelegatePanelClassThingThatsNotAnonymous panel = new ScrollableDelegatePanelClassThingThatsNotAnonymous(tree);
        DefaultFormBuilder treeBuilder = new DefaultFormBuilder(new FormLayout("fill:pref:grow", "fill:pref:grow, pref"), (JPanel)panel);
        treeBuilder.add((Component)tree);
        treeBuilder.nextLine();
        JLabel sqlpLabel = SPSUtils.getSQLPowerLogoLabel();
        treeBuilder.add((Component)sqlpLabel);
        return panel;
    }

    public static JLabel getSQLPowerLogoLabel() {
        JLabel sqlpLabel = new JLabel(new ImageIcon(SPSUtils.class.getClassLoader().getResource("ca/sqlpower/swingui/SQLP-90x80.png")));
        sqlpLabel.setBackground(Color.WHITE);
        sqlpLabel.setOpaque(true);
        sqlpLabel.setHorizontalAlignment(2);
        sqlpLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                try {
                    BrowserUtil.launch(SPSUtils.SQLP_URL);
                }
                catch (IOException e1) {
                    throw new RuntimeException("Unexpected error in launch", e1);
                }
            }
        });
        return sqlpLabel;
    }

    public static void makeJSpinnerSelectAllTextOnFocus(JSpinner spinner) {
        JSpinner.DefaultEditor editor = (JSpinner.DefaultEditor)spinner.getEditor();
        editor.getTextField().addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Focus Gained: " + e));
                }
                if (e.getSource() instanceof JTextComponent) {
                    final JTextComponent textComponent = (JTextComponent)e.getSource();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            textComponent.selectAll();
                        }
                    });
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Focus Lost:" + e));
                }
            }
        });
    }

    public static void runOnSwingThread(Runnable doRun) {
        if (SwingUtilities.isEventDispatchThread()) {
            doRun.run();
        } else {
            SwingUtilities.invokeLater(doRun);
        }
    }

    public static PopupListenerHandler popupComponent(Component owningFrame, JComponent componentToEmbed, Point windowLocation) {
        JComponent glassPane;
        JScrollPane treeScroll = new JScrollPane(componentToEmbed);
        treeScroll.setVerticalScrollBarPolicy(22);
        treeScroll.setHorizontalScrollBarPolicy(30);
        Point frameLocation = new Point(0, 0);
        SwingUtilities.convertPointToScreen(frameLocation, owningFrame);
        int popupScreenSpaceY = windowLocation.y - frameLocation.y;
        int maxHeight = (int)(owningFrame.getSize().getHeight() - (double)popupScreenSpaceY);
        int width = (int)Math.min(treeScroll.getPreferredSize().getWidth(), owningFrame.getSize().getWidth());
        int height = (int)Math.min(treeScroll.getPreferredSize().getHeight(), (double)maxHeight);
        treeScroll.setPreferredSize(new Dimension(width, height));
        double popupWidth = treeScroll.getPreferredSize().getWidth();
        int popupScreenSpaceX = (int)(owningFrame.getSize().getWidth() - (double)(windowLocation.x - frameLocation.x));
        int x = popupWidth > (double)popupScreenSpaceX ? (int)((double)windowLocation.x - (popupWidth - (double)popupScreenSpaceX)) : windowLocation.x;
        treeScroll.setBorder(BorderFactory.createBevelBorder(1, Color.GRAY, Color.GRAY));
        if (owningFrame instanceof JFrame) {
            JFrame frame = (JFrame)owningFrame;
            if (frame.getGlassPane() == null) {
                glassPane = new JPanel();
                frame.setGlassPane(glassPane);
            } else {
                glassPane = (JComponent)frame.getGlassPane();
            }
            glassPane.setVisible(true);
            glassPane.setOpaque(false);
        } else {
            glassPane = (JComponent)owningFrame;
        }
        PopupFactory pFactory = new PopupFactory();
        Popup popup = pFactory.getPopup(glassPane, treeScroll, x, windowLocation.y);
        return new PopupListenerHandler(popup, glassPane, owningFrame);
    }

    public static Throwable getRootCause(Throwable t) {
        Throwable rootCause;
        for (rootCause = t; rootCause.getCause() != null && rootCause != rootCause.getCause(); rootCause = rootCause.getCause()) {
        }
        return rootCause;
    }

    private static String convertToHex(byte[] data) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            int halfbyte = data[i] >>> 4 & 0xF;
            int two_halfs = 0;
            do {
                if (0 <= halfbyte && halfbyte <= 9) {
                    buf.append((char)(48 + halfbyte));
                } else {
                    buf.append((char)(97 + (halfbyte - 10)));
                }
                halfbyte = data[i] & 0xF;
            } while (two_halfs++ < 1);
        }
        return buf.toString();
    }

    public static String encodeSha1(String text) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            try {
                md = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e1) {
                throw new RuntimeException(e1);
            }
        }
        byte[] sha1hash = new byte[40];
        md.update(text.getBytes(), 0, text.length());
        sha1hash = md.digest();
        return SPSUtils.convertToHex(sha1hash);
    }

    public static void checkForUpdate(JFrame owner, String productName, Version version, String latestVersionUrl, boolean silent, boolean setTimeout, final Runnable stopAutoChecking) {
        block7: {
            try {
                GetMethod request = new GetMethod(latestVersionUrl);
                if (setTimeout) {
                    BasicHttpParams params = new BasicHttpParams();
                    params.setIntParameter("http.socket.timeout", new Integer(1000).intValue());
                }
                HttpClient connection = new HttpClient();
                connection.executeMethod((HttpMethod)request);
                final Properties results = new Properties();
                results.loadFromXML(new ByteArrayInputStream(request.getResponseBody()));
                Version currentVersion = new Version(results.getProperty("currentVersion"));
                if (currentVersion.compareTo(version) > 0) {
                    final JDialog dialog = new JDialog((Frame)owner, "New " + productName + " version available!");
                    dialog.setAlwaysOnTop(true);
                    dialog.setDefaultCloseOperation(2);
                    JPanel panel = new JPanel((LayoutManager)new MigLayout("fill", "[grow]", "[shrink][grow][shrink][shrink]"));
                    dialog.setContentPane(panel);
                    JLabel title = new JLabel("A new version of " + productName + " is available for download.");
                    title.setFont(title.getFont().deriveFont(16.0f));
                    panel.add((Component)title, "wrap, gapbottom 10px, center");
                    JLabel notes = new JLabel(results.getProperty("releaseNotes"));
                    notes.setBackground(Color.WHITE);
                    notes.setOpaque(true);
                    Border gap = BorderFactory.createEmptyBorder(4, 4, 4, 4);
                    Border blackline = BorderFactory.createLineBorder(Color.black);
                    CompoundBorder compound = BorderFactory.createCompoundBorder(blackline, gap);
                    notes.setBorder(compound);
                    panel.add((Component)notes, "wrap, center, grow");
                    final JCheckBox autoCheckCheckBox = new JCheckBox("Stop automatic updates");
                    if (stopAutoChecking != null) {
                        panel.add((Component)autoCheckCheckBox, "wrap, left");
                    }
                    Box buttons = Box.createHorizontalBox();
                    JButton downloadButton = new JButton(new AbstractAction("Download Now"){

                        @Override
                        public void actionPerformed(ActionEvent event) {
                            try {
                                BrowserUtil.launch(results.getProperty("downloadUrl"));
                            }
                            catch (IOException e) {
                                throw new RuntimeException("Error attempting to launch web browser", e);
                            }
                            finally {
                                dialog.dispose();
                                if (stopAutoChecking != null && autoCheckCheckBox.isSelected()) {
                                    stopAutoChecking.run();
                                }
                            }
                        }
                    });
                    JButton cancelButton = new JButton(new AbstractAction("No thanks"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            dialog.dispose();
                            if (stopAutoChecking != null && autoCheckCheckBox.isSelected()) {
                                stopAutoChecking.run();
                            }
                        }
                    });
                    buttons.add(downloadButton);
                    buttons.add(cancelButton);
                    panel.add((Component)buttons, "center");
                    dialog.pack();
                    dialog.setLocationRelativeTo(owner);
                    dialog.setVisible(true);
                } else if (!silent) {
                    JOptionPane.showMessageDialog(owner, "No updates available.", "Update checker", 1);
                }
            }
            catch (Exception ex) {
                logger.warn((Object)"Failed to check for update.", (Throwable)ex);
                if (silent) break block7;
                JOptionPane.showMessageDialog(owner, "Failed to check for updates. Are you connected to the internet?", "Update checker", 1);
            }
        }
    }

    public static class FileExtensionFilter
    extends FileFilter {
        protected LinkedHashSet<String> extensions;
        protected String name;

        public FileExtensionFilter(String name, String[] extensions) {
            this.name = name;
            this.extensions = new LinkedHashSet<String>(Arrays.asList(extensions));
        }

        public String toString() {
            StringBuffer s = new StringBuffer();
            s.append(this.name);
            s.append(":");
            s.append(this.extensions.toString());
            return s.toString();
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || this.extensions.contains(FileExtensionFilter.getExtension(f));
        }

        @Override
        public String getDescription() {
            return this.name;
        }

        public static String getExtension(File f) {
            String ext = "";
            String s = f.getName();
            int i = s.lastIndexOf(46);
            if (i > 0 && i < s.length() - 1) {
                ext = s.substring(i + 1).toLowerCase();
            }
            return ext;
        }

        public String getFilterExtension(Integer index) {
            ArrayList<String> l = new ArrayList<String>(this.extensions);
            int i = index == null || index < 0 || index >= l.size() ? 0 : index;
            if (l.size() > 0) {
                return (String)l.get(i);
            }
            return null;
        }
    }

    public static class LabelValueBean {
        String label;
        Object value;

        public LabelValueBean(String label, Object value) {
            this.label = label;
            this.value = value;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String argLabel) {
            this.label = argLabel;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object argValue) {
            this.value = argValue;
        }

        public String toString() {
            return this.label;
        }
    }
}

