/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class JTreeExpandAllAction
extends AbstractAction {
    private final JTree tree;

    public JTreeExpandAllAction(JTree tree, String text) {
        super(text);
        this.tree = tree;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TreePath selected = this.tree.getSelectionPath();
        if (selected == null) {
            return;
        }
        this.tree.expandPath(selected);
        this.expandChildren(selected);
    }

    private void expandChildren(TreePath parentPath) {
        Object parent = parentPath.getLastPathComponent();
        TreeModel model = this.tree.getModel();
        for (int i = 0; i < model.getChildCount(parent); ++i) {
            Object child = model.getChild(parent, i);
            TreePath childPath = parentPath.pathByAddingChild(child);
            this.tree.expandPath(childPath);
            if (model.isLeaf(child)) continue;
            this.expandChildren(childPath);
        }
    }
}

