/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jca.cci.core;

import java.sql.SQLException;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionFactory;
import javax.resource.cci.ConnectionSpec;
import javax.resource.cci.IndexedRecord;
import javax.resource.cci.Interaction;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.MappedRecord;
import javax.resource.cci.Record;
import javax.resource.cci.RecordFactory;
import javax.resource.cci.ResultSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.jca.cci.CannotCreateRecordException;
import org.springframework.jca.cci.CciOperationNotSupportedException;
import org.springframework.jca.cci.InvalidResultSetAccessException;
import org.springframework.jca.cci.RecordTypeNotSupportedException;
import org.springframework.jca.cci.connection.ConnectionFactoryUtils;
import org.springframework.jca.cci.connection.NotSupportedRecordFactory;
import org.springframework.jca.cci.core.CciOperations;
import org.springframework.jca.cci.core.ConnectionCallback;
import org.springframework.jca.cci.core.InteractionCallback;
import org.springframework.jca.cci.core.RecordCreator;
import org.springframework.jca.cci.core.RecordExtractor;
import org.springframework.util.Assert;

public class CciTemplate
implements CciOperations {
    private final Log logger = LogFactory.getLog(this.getClass());
    private ConnectionFactory connectionFactory;
    private ConnectionSpec connectionSpec;
    private RecordCreator outputRecordCreator;

    public CciTemplate() {
    }

    public CciTemplate(ConnectionFactory connectionFactory) {
        this.setConnectionFactory(connectionFactory);
        this.afterPropertiesSet();
    }

    public CciTemplate(ConnectionFactory connectionFactory, ConnectionSpec connectionSpec) {
        this.setConnectionFactory(connectionFactory);
        this.setConnectionSpec(connectionSpec);
        this.afterPropertiesSet();
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionSpec(ConnectionSpec connectionSpec) {
        this.connectionSpec = connectionSpec;
    }

    public ConnectionSpec getConnectionSpec() {
        return this.connectionSpec;
    }

    public void setOutputRecordCreator(RecordCreator creator) {
        this.outputRecordCreator = creator;
    }

    public RecordCreator getOutputRecordCreator() {
        return this.outputRecordCreator;
    }

    public void afterPropertiesSet() {
        if (this.getConnectionFactory() == null) {
            throw new IllegalArgumentException("Property 'connectionFactory' is required");
        }
    }

    public CciTemplate getDerivedTemplate(ConnectionSpec connectionSpec) {
        CciTemplate derived = new CciTemplate();
        derived.setConnectionFactory(this.getConnectionFactory());
        derived.setConnectionSpec(connectionSpec);
        derived.setOutputRecordCreator(this.getOutputRecordCreator());
        return derived;
    }

    @Override
    public <T> T execute(ConnectionCallback<T> action) throws DataAccessException {
        Assert.notNull(action, "Callback object must not be null");
        Connection con = ConnectionFactoryUtils.getConnection(this.getConnectionFactory(), this.getConnectionSpec());
        try {
            T t = action.doInConnection(con, this.getConnectionFactory());
            return t;
        }
        catch (NotSupportedException ex) {
            throw new CciOperationNotSupportedException("CCI operation not supported by connector", (ResourceException)((Object)ex));
        }
        catch (ResourceException ex) {
            throw new DataAccessResourceFailureException("CCI operation failed", ex);
        }
        catch (SQLException ex) {
            throw new InvalidResultSetAccessException("Parsing of CCI ResultSet failed", ex);
        }
        finally {
            ConnectionFactoryUtils.releaseConnection(con, this.getConnectionFactory());
        }
    }

    @Override
    public <T> T execute(final InteractionCallback<T> action) throws DataAccessException {
        Assert.notNull(action, "Callback object must not be null");
        return this.execute(new ConnectionCallback<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T doInConnection(Connection connection, ConnectionFactory connectionFactory) throws ResourceException, SQLException, DataAccessException {
                Interaction interaction = connection.createInteraction();
                try {
                    Object t = action.doInInteraction(interaction, connectionFactory);
                    return t;
                }
                finally {
                    CciTemplate.this.closeInteraction(interaction);
                }
            }
        });
    }

    @Override
    public Record execute(InteractionSpec spec, Record inputRecord) throws DataAccessException {
        return this.doExecute(spec, inputRecord, null, new SimpleRecordExtractor());
    }

    @Override
    public void execute(InteractionSpec spec, Record inputRecord, Record outputRecord) throws DataAccessException {
        this.doExecute(spec, inputRecord, outputRecord, null);
    }

    @Override
    public Record execute(InteractionSpec spec, RecordCreator inputCreator) throws DataAccessException {
        return this.doExecute(spec, this.createRecord(inputCreator), null, new SimpleRecordExtractor());
    }

    @Override
    public <T> T execute(InteractionSpec spec, Record inputRecord, RecordExtractor<T> outputExtractor) throws DataAccessException {
        return this.doExecute(spec, inputRecord, null, outputExtractor);
    }

    @Override
    public <T> T execute(InteractionSpec spec, RecordCreator inputCreator, RecordExtractor<T> outputExtractor) throws DataAccessException {
        return this.doExecute(spec, this.createRecord(inputCreator), null, outputExtractor);
    }

    protected <T> T doExecute(final InteractionSpec spec, final Record inputRecord, final Record outputRecord, final RecordExtractor<T> outputExtractor) throws DataAccessException {
        return this.execute(new InteractionCallback<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T doInInteraction(Interaction interaction, ConnectionFactory connectionFactory) throws ResourceException, SQLException, DataAccessException {
                Record outputRecordToUse = outputRecord;
                try {
                    if (outputRecord != null || CciTemplate.this.getOutputRecordCreator() != null) {
                        if (outputRecord == null) {
                            RecordFactory recordFactory = CciTemplate.this.getRecordFactory(connectionFactory);
                            outputRecordToUse = CciTemplate.this.getOutputRecordCreator().createRecord(recordFactory);
                        }
                        interaction.execute(spec, inputRecord, outputRecordToUse);
                    } else {
                        outputRecordToUse = interaction.execute(spec, inputRecord);
                    }
                    Object t = outputExtractor != null ? (Object)outputExtractor.extractData(outputRecordToUse) : null;
                    return t;
                }
                finally {
                    if (outputRecordToUse instanceof ResultSet) {
                        CciTemplate.this.closeResultSet((ResultSet)outputRecordToUse);
                    }
                }
            }
        });
    }

    public IndexedRecord createIndexedRecord(String name) throws DataAccessException {
        try {
            RecordFactory recordFactory = this.getRecordFactory(this.getConnectionFactory());
            return recordFactory.createIndexedRecord(name);
        }
        catch (NotSupportedException ex) {
            throw new RecordTypeNotSupportedException("Creation of indexed Record not supported by connector", (ResourceException)((Object)ex));
        }
        catch (ResourceException ex) {
            throw new CannotCreateRecordException("Creation of indexed Record failed", ex);
        }
    }

    public MappedRecord createMappedRecord(String name) throws DataAccessException {
        try {
            RecordFactory recordFactory = this.getRecordFactory(this.getConnectionFactory());
            return recordFactory.createMappedRecord(name);
        }
        catch (NotSupportedException ex) {
            throw new RecordTypeNotSupportedException("Creation of mapped Record not supported by connector", (ResourceException)((Object)ex));
        }
        catch (ResourceException ex) {
            throw new CannotCreateRecordException("Creation of mapped Record failed", ex);
        }
    }

    protected Record createRecord(RecordCreator recordCreator) throws DataAccessException {
        try {
            RecordFactory recordFactory = this.getRecordFactory(this.getConnectionFactory());
            return recordCreator.createRecord(recordFactory);
        }
        catch (NotSupportedException ex) {
            throw new RecordTypeNotSupportedException("Creation of the desired Record type not supported by connector", (ResourceException)((Object)ex));
        }
        catch (ResourceException ex) {
            throw new CannotCreateRecordException("Creation of the desired Record failed", ex);
        }
    }

    protected RecordFactory getRecordFactory(ConnectionFactory connectionFactory) throws ResourceException {
        try {
            return connectionFactory.getRecordFactory();
        }
        catch (NotSupportedException ex) {
            return new NotSupportedRecordFactory();
        }
    }

    private void closeInteraction(Interaction interaction) {
        if (interaction != null) {
            try {
                interaction.close();
            }
            catch (ResourceException ex) {
                this.logger.trace("Could not close CCI Interaction", ex);
            }
            catch (Throwable ex) {
                this.logger.trace("Unexpected exception on closing CCI Interaction", ex);
            }
        }
    }

    private void closeResultSet(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException ex) {
                this.logger.trace("Could not close CCI ResultSet", ex);
            }
            catch (Throwable ex) {
                this.logger.trace("Unexpected exception on closing CCI ResultSet", ex);
            }
        }
    }

    private static class SimpleRecordExtractor
    implements RecordExtractor<Record> {
        private SimpleRecordExtractor() {
        }

        @Override
        public Record extractData(Record record) {
            return record;
        }
    }
}

