/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.Collections;
import java.util.Map;
import org.apache.camel.spi.EndpointUtilizationStatistics;
import org.apache.camel.util.LRUCache;

public class DefaultEndpointUtilizationStatistics
implements EndpointUtilizationStatistics {
    private final LRUCache<String, Long> map;

    public DefaultEndpointUtilizationStatistics(int maxCapacity) {
        this.map = new LRUCache(16, maxCapacity, false);
    }

    @Override
    public int maxCapacity() {
        return this.map.getMaxCacheSize();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public synchronized void onHit(String uri) {
        Long counter = this.map.get(uri);
        if (counter == null) {
            counter = 1L;
            this.map.put(uri, counter);
        } else {
            Long l = counter;
            Long l2 = counter = Long.valueOf(counter + 1L);
            this.map.put(uri, counter);
        }
    }

    @Override
    public void remove(String uri) {
        this.map.remove(uri);
    }

    @Override
    public Map<String, Long> getStatistics() {
        return Collections.unmodifiableMap(this.map);
    }

    @Override
    public void clear() {
        this.map.clear();
    }
}

