/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.request;

import java.security.Principal;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.http.HttpMethod;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.util.WebUtils;

public class ServletWebRequest
extends ServletRequestAttributes
implements NativeWebRequest {
    private static final String HEADER_ETAG = "ETag";
    private static final String HEADER_IF_MODIFIED_SINCE = "If-Modified-Since";
    private static final String HEADER_IF_NONE_MATCH = "If-None-Match";
    private static final String HEADER_LAST_MODIFIED = "Last-Modified";
    private static final String METHOD_GET = "GET";
    private static final String METHOD_HEAD = "HEAD";
    private boolean notModified = false;

    public ServletWebRequest(HttpServletRequest request) {
        super(request);
    }

    public ServletWebRequest(HttpServletRequest request, HttpServletResponse response) {
        super(request, response);
    }

    @Override
    public Object getNativeRequest() {
        return this.getRequest();
    }

    @Override
    public Object getNativeResponse() {
        return this.getResponse();
    }

    @Override
    public <T> T getNativeRequest(Class<T> requiredType) {
        return WebUtils.getNativeRequest((ServletRequest)this.getRequest(), requiredType);
    }

    @Override
    public <T> T getNativeResponse(Class<T> requiredType) {
        return WebUtils.getNativeResponse((ServletResponse)this.getResponse(), requiredType);
    }

    public HttpMethod getHttpMethod() {
        return HttpMethod.valueOf(this.getRequest().getMethod().trim().toUpperCase());
    }

    @Override
    public String getHeader(String headerName) {
        return this.getRequest().getHeader(headerName);
    }

    @Override
    public String[] getHeaderValues(String headerName) {
        Object[] headerValues = StringUtils.toStringArray((Enumeration)this.getRequest().getHeaders(headerName));
        return !ObjectUtils.isEmpty((Object[])headerValues) ? headerValues : null;
    }

    @Override
    public Iterator<String> getHeaderNames() {
        return CollectionUtils.toIterator((Enumeration)this.getRequest().getHeaderNames());
    }

    @Override
    public String getParameter(String paramName) {
        return this.getRequest().getParameter(paramName);
    }

    @Override
    public String[] getParameterValues(String paramName) {
        return this.getRequest().getParameterValues(paramName);
    }

    @Override
    public Iterator<String> getParameterNames() {
        return CollectionUtils.toIterator((Enumeration)this.getRequest().getParameterNames());
    }

    @Override
    public Map<String, String[]> getParameterMap() {
        return this.getRequest().getParameterMap();
    }

    @Override
    public Locale getLocale() {
        return this.getRequest().getLocale();
    }

    @Override
    public String getContextPath() {
        return this.getRequest().getContextPath();
    }

    @Override
    public String getRemoteUser() {
        return this.getRequest().getRemoteUser();
    }

    @Override
    public Principal getUserPrincipal() {
        return this.getRequest().getUserPrincipal();
    }

    @Override
    public boolean isUserInRole(String role) {
        return this.getRequest().isUserInRole(role);
    }

    @Override
    public boolean isSecure() {
        return this.getRequest().isSecure();
    }

    @Override
    public boolean checkNotModified(long lastModifiedTimestamp) {
        HttpServletResponse response = this.getResponse();
        if (!(lastModifiedTimestamp < 0L || this.notModified || response != null && response.containsHeader(HEADER_LAST_MODIFIED))) {
            long ifModifiedSince;
            block8: {
                ifModifiedSince = -1L;
                try {
                    ifModifiedSince = this.getRequest().getDateHeader(HEADER_IF_MODIFIED_SINCE);
                }
                catch (IllegalArgumentException ex) {
                    String headerValue = this.getRequest().getHeader(HEADER_IF_MODIFIED_SINCE);
                    int separatorIndex = headerValue.indexOf(59);
                    if (separatorIndex == -1) break block8;
                    String datePart = headerValue.substring(0, separatorIndex);
                    try {
                        ifModifiedSince = Date.parse(datePart);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
            boolean bl = this.notModified = ifModifiedSince >= lastModifiedTimestamp / 1000L * 1000L;
            if (response != null) {
                if (this.notModified && this.supportsNotModifiedStatus()) {
                    response.setStatus(304);
                } else {
                    response.setDateHeader(HEADER_LAST_MODIFIED, lastModifiedTimestamp);
                }
            }
        }
        return this.notModified;
    }

    @Override
    public boolean checkNotModified(String etag) {
        HttpServletResponse response = this.getResponse();
        if (!(!StringUtils.hasLength((String)etag) || this.notModified || response != null && response.containsHeader(HEADER_ETAG))) {
            String ifNoneMatch = this.getRequest().getHeader(HEADER_IF_NONE_MATCH);
            this.notModified = etag.equals(ifNoneMatch);
            if (response != null) {
                if (this.notModified && this.supportsNotModifiedStatus()) {
                    response.setStatus(304);
                } else {
                    response.setHeader(HEADER_ETAG, etag);
                }
            }
        }
        return this.notModified;
    }

    private boolean supportsNotModifiedStatus() {
        String method = this.getRequest().getMethod();
        return METHOD_GET.equals(method) || METHOD_HEAD.equals(method);
    }

    public boolean isNotModified() {
        return this.notModified;
    }

    @Override
    public String getDescription(boolean includeClientInfo) {
        HttpServletRequest request = this.getRequest();
        StringBuilder sb = new StringBuilder();
        sb.append("uri=").append(request.getRequestURI());
        if (includeClientInfo) {
            String user;
            HttpSession session;
            String client = request.getRemoteAddr();
            if (StringUtils.hasLength((String)client)) {
                sb.append(";client=").append(client);
            }
            if ((session = request.getSession(false)) != null) {
                sb.append(";session=").append(session.getId());
            }
            if (StringUtils.hasLength((String)(user = request.getRemoteUser()))) {
                sb.append(";user=").append(user);
            }
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return "ServletWebRequest: " + this.getDescription(true);
    }
}

