#!/bin/sh
export PATH='/usr/obj/ports/hs-convertible-1.1.1.0/bin:/usr/bin:/bin:/usr/sbin:/sbin:/usr/local/bin:/usr/X11R6/bin'
echo 'name: convertible
version: 1.1.1.0
id: convertible-1.1.1.0-CcttzSMZvrP7n0GTZtYEig
key: convertible-1.1.1.0-CcttzSMZvrP7n0GTZtYEig
license: BSD3
copyright: Copyright (c) 2009-2011 John Goerzen
maintainer: Erik Hesselink <hesselink@gmail.com>
stability: Stable
homepage: http://hackage.haskell.org/package/convertible
synopsis: Typeclasses and instances for converting between types
description:
    convertible provides a typeclass with a single function
    that is designed to help convert between different types: numeric
    values, dates and times, and the like.  The conversions perform bounds
    checking and return a pure Either value.  This means that you need
    not remember which specific function performs the conversion you
    desire.
    .
    Also included in the package are optional instances that provide
    conversion for various numeric and time types, as well as utilities
    for writing your own instances.
    .
    Finally, there is a function that will raise an exception on
    bounds-checking violation, or return a bare value otherwise,
    implemented in terms of the safer function described above.
    .
    Convertible is also used by HDBC 2.0 for handling marshalling of
    data to and from databases.
    .
    Convertible is backed by an extensive test suite and passes tests
    on GHC and Hugs.
category: Data
author: John Goerzen
exposed: True
indefinite: False
exposed-modules:
    Data.Convertible Data.Convertible.Base Data.Convertible.Instances
    Data.Convertible.Instances.C Data.Convertible.Instances.Map
    Data.Convertible.Instances.Num Data.Convertible.Instances.Text
    Data.Convertible.Instances.Time Data.Convertible.Utils
abi: eba179b158c8c9fa335297b291b89dc3
trusted: False
import-dirs: /usr/local/lib/ghc/convertible-1.1.1.0
library-dirs: /usr/local/lib/ghc/convertible-1.1.1.0
              /usr/local/lib/i386-openbsd-ghc-8.2.2
data-dir: /usr/local/share/hs-convertible-1.1.1.0
hs-libraries: HSconvertible-1.1.1.0-CcttzSMZvrP7n0GTZtYEig
depends:
    base-4.10.1.0 bytestring-0.10.8.2 containers-0.5.10.2
    mtl-2.2.1-DscMMmDQUE6GBfOSl4qMUH
    old-locale-1.0.0.7-uLYLcRn7Nv8SkmeS8fMf9
    old-time-1.1.0.3-LmKk8FUXtYwDVw5bR99HBe
    text-1.2.1.3-5I6D6Lq0QEU97eY5wqs6DJ time-1.8.0.2
abi-depends: base-4.10.1.0=3c10740f6cf9df7b9dca6d01ba411ea7
             bytestring-0.10.8.2=2a4bbfd60b4f148922e8caf44d9009f9
             containers-0.5.10.2=2ff387bb382d9f510ffcf8f3ed2013c5
             mtl-2.2.1-DscMMmDQUE6GBfOSl4qMUH=ff60e0c200c475a016137ee0a9ed1f03
             old-locale-1.0.0.7-uLYLcRn7Nv8SkmeS8fMf9=a09774905d29698e6c89ba4927e5c216
             old-time-1.1.0.3-LmKk8FUXtYwDVw5bR99HBe=4884f9ee88ed902fb68be6ea485f408f
             text-1.2.1.3-5I6D6Lq0QEU97eY5wqs6DJ=77e10b579708f506156fd8ed84f18afc
             time-1.8.0.2=4e7e761020e68f00617832ab1b4f94d5
haddock-interfaces: /usr/local/share/doc/hs-convertible-1.1.1.0/html/convertible.haddock
haddock-html: /usr/local/share/doc/hs-convertible-1.1.1.0/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"

