/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel.view.impl.models.http.request;

import org.apache.log4j.Logger;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.zaproxy.zap.extension.httppanel.view.impl.models.http.AbstractHttpStringHttpPanelViewModel;
import org.zaproxy.zap.extension.httppanel.view.impl.models.http.HttpPanelViewModelUtils;

public class RequestStringHttpPanelViewModel
extends AbstractHttpStringHttpPanelViewModel {
    private static final Logger logger = Logger.getLogger(RequestStringHttpPanelViewModel.class);

    @Override
    public String getData() {
        if (this.httpMessage == null) {
            return "";
        }
        return this.httpMessage.getRequestHeader().toString().replaceAll("\r\n", "\n") + this.httpMessage.getRequestBody().toString();
    }

    @Override
    public void setData(String data) {
        String[] parts = data.split("\n\n");
        String header = parts[0].replaceAll("(?<!\r)\n", "\r\n");
        try {
            this.httpMessage.setRequestHeader(header);
        }
        catch (HttpMalformedHeaderException e) {
            logger.warn((Object)("Could not Save Header: " + header), (Throwable)e);
        }
        if (parts.length > 1) {
            this.httpMessage.setRequestBody(data.substring(parts[0].length() + 2));
        } else {
            this.httpMessage.setRequestBody("");
        }
        HttpPanelViewModelUtils.updateRequestContentLength(this.httpMessage);
    }
}

