/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.Date;
import java.util.LinkedList;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;

public class BceProtocolDecoder
extends BaseProtocolDecoder {
    private static final int DATA_TYPE = 7;
    public static final int MSG_ASYNC_STACK = 165;
    public static final int MSG_STACK_COFIRM = 25;
    public static final int MSG_TIME_TRIGGERED = 160;
    public static final int MSG_OUTPUT_CONTROL = 65;
    public static final int MSG_OUTPUT_CONTROL_ACK = 193;

    public BceProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        String imei = String.format("%015d", buf.readLongLE());
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, imei);
        if (deviceSession == null) {
            return null;
        }
        LinkedList<Position> positions = new LinkedList<Position>();
        while (buf.readableBytes() > 1) {
            int dataEnd = buf.readUnsignedShortLE() + buf.readerIndex();
            short type = buf.readUnsignedByte();
            if (type != 165 && type != 160) {
                return null;
            }
            int confirmKey = buf.readUnsignedByte() & 0x7F;
            while (buf.readerIndex() < dataEnd) {
                Position position = new Position(this.getProtocolName());
                position.setDeviceId(deviceSession.getDeviceId());
                int structEnd = buf.readUnsignedByte() + buf.readerIndex();
                long time = buf.readUnsignedIntLE();
                if ((time & 0xFL) == 7L) {
                    int mask;
                    time = time >> 4 << 1;
                    position.setTime(new Date((time += 1199145600L) * 1000L));
                    LinkedList<Integer> masks = new LinkedList<Integer>();
                    do {
                        mask = buf.readUnsignedShortLE();
                        masks.add(mask);
                    } while (BitUtil.check(mask, 15));
                    mask = (Integer)masks.get(0);
                    if (BitUtil.check(mask, 0)) {
                        position.setValid(true);
                        position.setLongitude(buf.readFloatLE());
                        position.setLatitude(buf.readFloatLE());
                        position.setSpeed(UnitsConverter.knotsFromKph(buf.readUnsignedByte()));
                        short status = buf.readUnsignedByte();
                        position.set("sat", BitUtil.to(status, 4));
                        position.set("hdop", BitUtil.from(status, 4));
                        position.setCourse(buf.readUnsignedByte() * 2);
                        position.setAltitude(buf.readUnsignedShortLE());
                        position.set("odometer", buf.readUnsignedIntLE());
                    }
                    if (BitUtil.check(mask, 1)) {
                        position.set("input", buf.readUnsignedShortLE());
                    }
                    for (int i = 1; i <= 8; ++i) {
                        if (!BitUtil.check(mask, i + 1)) continue;
                        position.set("adc" + i, buf.readUnsignedShortLE());
                    }
                    if (BitUtil.check(mask, 10)) {
                        buf.skipBytes(4);
                    }
                    if (BitUtil.check(mask, 11)) {
                        buf.skipBytes(4);
                    }
                    if (BitUtil.check(mask, 12)) {
                        buf.skipBytes(2);
                    }
                    if (BitUtil.check(mask, 13)) {
                        buf.skipBytes(2);
                    }
                    if (BitUtil.check(mask, 14)) {
                        position.setNetwork(new Network(CellTower.from(buf.readUnsignedShortLE(), buf.readUnsignedByte(), buf.readUnsignedShortLE(), buf.readUnsignedShortLE(), buf.readUnsignedByte())));
                        buf.readUnsignedByte();
                    }
                    if (BitUtil.check(mask, 0)) {
                        positions.add(position);
                    }
                }
                buf.readerIndex(structEnd);
            }
            if (type != 165 || channel == null) continue;
            ByteBuf response = Unpooled.buffer((int)13);
            response.writeLongLE(Long.parseLong(imei));
            response.writeShortLE(2);
            response.writeByte(25);
            response.writeByte(confirmKey);
            int checksum = 0;
            for (int i = 0; i < response.writerIndex(); ++i) {
                checksum += response.getUnsignedByte(i);
            }
            response.writeByte(checksum);
            channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
        }
        return positions;
    }
}

