/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.Protocol;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;

public class AvemaProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().number("(d+),").number("(dddd)(dd)(dd)").number("(dd)(dd)(dd),").number("(-?d+.d+),").number("(-?d+.d+),").number("(d+),").number("(d+),").number("(-?d+),").number("(d+),").number("(d+),").number("(d+.d+),").number("(d+),").number("(d+.d+)V,").number("(d+.d+)V,").number("(d+),").number("(d),").number("(d+),").number("d,").number("(ddd)").number("(dd),").number("(x+),").number("(x+),").number("([^,]+)?").compile();

    public AvemaProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        Parser parser = new Parser(PATTERN, (String)msg);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.setValid(true);
        position.setTime(parser.nextDateTime());
        position.setLongitude(parser.nextDouble());
        position.setLatitude(parser.nextDouble());
        position.setSpeed(UnitsConverter.knotsFromKph(parser.nextInt().intValue()));
        position.setCourse(parser.nextInt().intValue());
        position.setAltitude(parser.nextInt().intValue());
        position.set("sat", parser.nextInt());
        position.set("event", parser.nextInt());
        position.set("odometer", parser.nextDouble() * 1000.0);
        position.set("input", parser.nextInt());
        position.set("adc1", parser.nextDouble());
        position.set("adc2", parser.nextDouble());
        position.set("output", parser.nextInt());
        position.set("roaming", parser.nextInt() == 1);
        int rssi = parser.nextInt();
        position.setNetwork(new Network(CellTower.from(parser.nextInt(), parser.nextInt(), parser.nextHexInt(), parser.nextHexInt().intValue(), rssi)));
        position.set("driverUniqueId", parser.next());
        return position;
    }
}

