/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.api.resource;

import java.sql.SQLException;
import java.util.LinkedHashMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.traccar.Context;
import org.traccar.api.BaseResource;
import org.traccar.helper.LogAction;
import org.traccar.model.Device;
import org.traccar.model.Permission;
import org.traccar.model.User;

@Path(value="permissions")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class PermissionsResource
extends BaseResource {
    private void checkPermission(Permission permission, boolean link) {
        if (!link && permission.getOwnerClass().equals(User.class) && permission.getPropertyClass().equals(Device.class)) {
            if (this.getUserId() != permission.getOwnerId()) {
                Context.getPermissionsManager().checkUser(this.getUserId(), permission.getOwnerId());
            } else {
                Context.getPermissionsManager().checkAdmin(this.getUserId());
            }
        } else {
            Context.getPermissionsManager().checkPermission(permission.getOwnerClass(), this.getUserId(), permission.getOwnerId());
        }
        Context.getPermissionsManager().checkPermission(permission.getPropertyClass(), this.getUserId(), permission.getPropertyId());
    }

    @POST
    public Response add(LinkedHashMap<String, Long> entity) throws SQLException, ClassNotFoundException {
        Context.getPermissionsManager().checkReadonly(this.getUserId());
        Permission permission = new Permission(entity);
        this.checkPermission(permission, true);
        Context.getDataManager().linkObject(permission.getOwnerClass(), permission.getOwnerId(), permission.getPropertyClass(), permission.getPropertyId(), true);
        LogAction.link(this.getUserId(), permission.getOwnerClass(), permission.getOwnerId(), permission.getPropertyClass(), permission.getPropertyId());
        Context.getPermissionsManager().refreshPermissions(permission);
        return Response.noContent().build();
    }

    @DELETE
    public Response remove(LinkedHashMap<String, Long> entity) throws SQLException, ClassNotFoundException {
        Context.getPermissionsManager().checkReadonly(this.getUserId());
        Permission permission = new Permission(entity);
        this.checkPermission(permission, false);
        Context.getDataManager().linkObject(permission.getOwnerClass(), permission.getOwnerId(), permission.getPropertyClass(), permission.getPropertyId(), false);
        LogAction.unlink(this.getUserId(), permission.getOwnerClass(), permission.getOwnerId(), permission.getPropertyClass(), permission.getPropertyId());
        Context.getPermissionsManager().refreshPermissions(permission);
        return Response.noContent().build();
    }
}

