/*
 * Decompiled with CFR 0.152.
 */
package org.traccar;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr353.JSR353Module;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.ext.ContextResolver;
import org.apache.velocity.app.VelocityEngine;
import org.eclipse.jetty.util.URIUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.Config;
import org.traccar.ServerManager;
import org.traccar.database.AttributesManager;
import org.traccar.database.BaseObjectManager;
import org.traccar.database.CalendarManager;
import org.traccar.database.CommandsManager;
import org.traccar.database.ConnectionManager;
import org.traccar.database.DataManager;
import org.traccar.database.DeviceManager;
import org.traccar.database.DriversManager;
import org.traccar.database.GeofenceManager;
import org.traccar.database.GroupsManager;
import org.traccar.database.IdentityManager;
import org.traccar.database.LdapProvider;
import org.traccar.database.MailManager;
import org.traccar.database.MaintenancesManager;
import org.traccar.database.MediaManager;
import org.traccar.database.NotificationManager;
import org.traccar.database.PermissionsManager;
import org.traccar.database.StatisticsManager;
import org.traccar.database.UsersManager;
import org.traccar.events.MotionEventHandler;
import org.traccar.events.OverspeedEventHandler;
import org.traccar.geocoder.AddressFormat;
import org.traccar.geocoder.BanGeocoder;
import org.traccar.geocoder.BingMapsGeocoder;
import org.traccar.geocoder.FactualGeocoder;
import org.traccar.geocoder.GeocodeFarmGeocoder;
import org.traccar.geocoder.GeocodeXyzGeocoder;
import org.traccar.geocoder.Geocoder;
import org.traccar.geocoder.GisgraphyGeocoder;
import org.traccar.geocoder.GoogleGeocoder;
import org.traccar.geocoder.HereGeocoder;
import org.traccar.geocoder.MapQuestGeocoder;
import org.traccar.geocoder.MapmyIndiaGeocoder;
import org.traccar.geocoder.NominatimGeocoder;
import org.traccar.geocoder.OpenCageGeocoder;
import org.traccar.geolocation.GeolocationProvider;
import org.traccar.geolocation.GoogleGeolocationProvider;
import org.traccar.geolocation.MozillaGeolocationProvider;
import org.traccar.geolocation.OpenCellIdGeolocationProvider;
import org.traccar.geolocation.UnwiredGeolocationProvider;
import org.traccar.helper.Log;
import org.traccar.helper.SanitizerModule;
import org.traccar.model.Attribute;
import org.traccar.model.BaseModel;
import org.traccar.model.Calendar;
import org.traccar.model.Command;
import org.traccar.model.Device;
import org.traccar.model.Driver;
import org.traccar.model.Geofence;
import org.traccar.model.Group;
import org.traccar.model.Maintenance;
import org.traccar.model.Notification;
import org.traccar.model.User;
import org.traccar.notification.EventForwarder;
import org.traccar.notification.JsonTypeEventForwarder;
import org.traccar.notification.NotificatorManager;
import org.traccar.reports.model.TripsConfig;
import org.traccar.sms.SmsManager;
import org.traccar.sms.smpp.SmppClient;
import org.traccar.web.WebServer;

public final class Context {
    private static final Logger LOGGER = LoggerFactory.getLogger(Context.class);
    private static Config config;
    private static ObjectMapper objectMapper;
    private static IdentityManager identityManager;
    private static DataManager dataManager;
    private static LdapProvider ldapProvider;
    private static MailManager mailManager;
    private static MediaManager mediaManager;
    private static UsersManager usersManager;
    private static GroupsManager groupsManager;
    private static DeviceManager deviceManager;
    private static ConnectionManager connectionManager;
    private static PermissionsManager permissionsManager;
    private static Geocoder geocoder;
    private static GeolocationProvider geolocationProvider;
    private static WebServer webServer;
    private static ServerManager serverManager;
    private static GeofenceManager geofenceManager;
    private static CalendarManager calendarManager;
    private static NotificationManager notificationManager;
    private static NotificatorManager notificatorManager;
    private static VelocityEngine velocityEngine;
    private static Client client;
    private static EventForwarder eventForwarder;
    private static AttributesManager attributesManager;
    private static DriversManager driversManager;
    private static CommandsManager commandsManager;
    private static MaintenancesManager maintenancesManager;
    private static StatisticsManager statisticsManager;
    private static SmsManager smsManager;
    private static MotionEventHandler motionEventHandler;
    private static OverspeedEventHandler overspeedEventHandler;
    private static TripsConfig tripsConfig;

    private Context() {
    }

    public static String getAppVersion() {
        return Context.class.getPackage().getImplementationVersion();
    }

    public static Config getConfig() {
        return config;
    }

    public static ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    public static IdentityManager getIdentityManager() {
        return identityManager;
    }

    public static DataManager getDataManager() {
        return dataManager;
    }

    public static LdapProvider getLdapProvider() {
        return ldapProvider;
    }

    public static MailManager getMailManager() {
        return mailManager;
    }

    public static MediaManager getMediaManager() {
        return mediaManager;
    }

    public static UsersManager getUsersManager() {
        return usersManager;
    }

    public static GroupsManager getGroupsManager() {
        return groupsManager;
    }

    public static DeviceManager getDeviceManager() {
        return deviceManager;
    }

    public static ConnectionManager getConnectionManager() {
        return connectionManager;
    }

    public static PermissionsManager getPermissionsManager() {
        return permissionsManager;
    }

    public static Geocoder getGeocoder() {
        return geocoder;
    }

    public static GeolocationProvider getGeolocationProvider() {
        return geolocationProvider;
    }

    public static WebServer getWebServer() {
        return webServer;
    }

    public static ServerManager getServerManager() {
        return serverManager;
    }

    public static GeofenceManager getGeofenceManager() {
        return geofenceManager;
    }

    public static CalendarManager getCalendarManager() {
        return calendarManager;
    }

    public static NotificationManager getNotificationManager() {
        return notificationManager;
    }

    public static NotificatorManager getNotificatorManager() {
        return notificatorManager;
    }

    public static VelocityEngine getVelocityEngine() {
        return velocityEngine;
    }

    public static Client getClient() {
        return client;
    }

    public static EventForwarder getEventForwarder() {
        return eventForwarder;
    }

    public static AttributesManager getAttributesManager() {
        return attributesManager;
    }

    public static DriversManager getDriversManager() {
        return driversManager;
    }

    public static CommandsManager getCommandsManager() {
        return commandsManager;
    }

    public static MaintenancesManager getMaintenancesManager() {
        return maintenancesManager;
    }

    public static StatisticsManager getStatisticsManager() {
        return statisticsManager;
    }

    public static SmsManager getSmsManager() {
        return smsManager;
    }

    public static MotionEventHandler getMotionEventHandler() {
        return motionEventHandler;
    }

    public static OverspeedEventHandler getOverspeedEventHandler() {
        return overspeedEventHandler;
    }

    public static TripsConfig getTripsConfig() {
        return tripsConfig;
    }

    public static TripsConfig initTripsConfig() {
        return new TripsConfig(config.getLong("report.trip.minimalTripDistance", 500L), config.getLong("report.trip.minimalTripDuration", 300L) * 1000L, config.getLong("report.trip.minimalParkingDuration", 300L) * 1000L, config.getLong("report.trip.minimalNoDataDuration", 3600L) * 1000L, config.getBoolean("report.trip.useIgnition"), config.getBoolean("event.motion.processInvalidPositions"), config.getDouble("event.motion.speedThreshold", 0.01));
    }

    public static Geocoder initGeocoder() {
        String type = config.getString("geocoder.type", "google");
        String url = config.getString("geocoder.url");
        String id = config.getString("geocoder.id");
        String key = config.getString("geocoder.key");
        String language = config.getString("geocoder.language");
        String formatString = config.getString("geocoder.format");
        AddressFormat addressFormat = formatString != null ? new AddressFormat(formatString) : new AddressFormat();
        int cacheSize = config.getInteger("geocoder.cacheSize");
        switch (type) {
            case "nominatim": {
                return new NominatimGeocoder(url, key, language, cacheSize, addressFormat);
            }
            case "gisgraphy": {
                return new GisgraphyGeocoder(url, cacheSize, addressFormat);
            }
            case "mapquest": {
                return new MapQuestGeocoder(url, key, cacheSize, addressFormat);
            }
            case "opencage": {
                return new OpenCageGeocoder(url, key, cacheSize, addressFormat);
            }
            case "bingmaps": {
                return new BingMapsGeocoder(url, key, cacheSize, addressFormat);
            }
            case "factual": {
                return new FactualGeocoder(url, key, cacheSize, addressFormat);
            }
            case "geocodefarm": {
                return new GeocodeFarmGeocoder(key, language, cacheSize, addressFormat);
            }
            case "geocodexyz": {
                return new GeocodeXyzGeocoder(key, cacheSize, addressFormat);
            }
            case "ban": {
                return new BanGeocoder(cacheSize, addressFormat);
            }
            case "here": {
                return new HereGeocoder(id, key, language, cacheSize, addressFormat);
            }
            case "mapmyindia": {
                return new MapmyIndiaGeocoder(url, key, cacheSize, addressFormat);
            }
        }
        return new GoogleGeocoder(key, language, cacheSize, addressFormat);
    }

    public static void init(String configFile) throws Exception {
        try {
            config = new Config();
            config.load(configFile);
        }
        catch (Exception e) {
            Log.setupDefaultLogger();
            throw e;
        }
        if (config.getBoolean("logger.enable")) {
            Log.setupLogger(config);
        }
        objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new SanitizerModule());
        objectMapper.registerModule((Module)new JSR353Module());
        objectMapper.setConfig(objectMapper.getSerializationConfig().without(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS));
        if (Context.getConfig().getBoolean("mapper.prettyPrintedJson")) {
            objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        }
        client = (Client)ClientBuilder.newClient().register((Object)new ObjectMapperContextResolver());
        if (config.hasKey("database.url")) {
            dataManager = new DataManager(config);
        }
        if (config.getBoolean("ldap.enable")) {
            ldapProvider = new LdapProvider(config);
        }
        mailManager = new MailManager();
        mediaManager = new MediaManager(config.getString("media.path"));
        if (dataManager != null) {
            usersManager = new UsersManager(dataManager);
            groupsManager = new GroupsManager(dataManager);
            deviceManager = new DeviceManager(dataManager);
        }
        identityManager = deviceManager;
        if (config.getBoolean("geocoder.enable")) {
            geocoder = Context.initGeocoder();
        }
        if (config.getBoolean("geolocation.enable")) {
            Context.initGeolocationModule();
        }
        if (config.getBoolean("web.enable")) {
            webServer = new WebServer(config);
        }
        permissionsManager = new PermissionsManager(dataManager, usersManager);
        connectionManager = new ConnectionManager();
        tripsConfig = Context.initTripsConfig();
        if (config.getBoolean("sms.enable")) {
            String smsManagerClass = config.getString("sms.manager.class", SmppClient.class.getCanonicalName());
            try {
                smsManager = (SmsManager)Class.forName(smsManagerClass).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                LOGGER.warn("Error loading SMS Manager class : " + smsManagerClass, (Throwable)e);
            }
        }
        if (config.getBoolean("event.enable")) {
            Context.initEventsModule();
        }
        serverManager = new ServerManager();
        if (config.getBoolean("event.forward.enable")) {
            eventForwarder = new JsonTypeEventForwarder();
        }
        attributesManager = new AttributesManager(dataManager);
        driversManager = new DriversManager(dataManager);
        commandsManager = new CommandsManager(dataManager, config.getBoolean("commands.queueing"));
        statisticsManager = new StatisticsManager();
    }

    private static void initGeolocationModule() {
        String type = config.getString("geolocation.type", "mozilla");
        String url = config.getString("geolocation.url");
        String key = config.getString("geolocation.key");
        switch (type) {
            case "google": {
                geolocationProvider = new GoogleGeolocationProvider(key);
                break;
            }
            case "opencellid": {
                geolocationProvider = new OpenCellIdGeolocationProvider(key);
                break;
            }
            case "unwired": {
                geolocationProvider = new UnwiredGeolocationProvider(url, key);
                break;
            }
            default: {
                geolocationProvider = new MozillaGeolocationProvider(key);
            }
        }
    }

    private static void initEventsModule() {
        String address;
        geofenceManager = new GeofenceManager(dataManager);
        calendarManager = new CalendarManager(dataManager);
        maintenancesManager = new MaintenancesManager(dataManager);
        notificationManager = new NotificationManager(dataManager);
        notificatorManager = new NotificatorManager();
        Properties velocityProperties = new Properties();
        velocityProperties.setProperty("file.resource.loader.path", Context.getConfig().getString("templates.rootPath", "templates") + "/");
        velocityProperties.setProperty("runtime.log.logsystem.class", "org.apache.velocity.runtime.log.NullLogChute");
        try {
            address = config.getString("web.address", InetAddress.getLocalHost().getHostAddress());
        }
        catch (UnknownHostException e) {
            address = "localhost";
        }
        String webUrl = URIUtil.newURI((String)"http", (String)address, (int)config.getInteger("web.port", 8082), (String)"", (String)"");
        webUrl = Context.getConfig().getString("web.url", webUrl);
        velocityProperties.setProperty("web.url", webUrl);
        velocityEngine = new VelocityEngine();
        velocityEngine.init(velocityProperties);
        motionEventHandler = new MotionEventHandler(tripsConfig);
        overspeedEventHandler = new OverspeedEventHandler(Context.getConfig().getLong("event.overspeed.minimalDuration") * 1000L, Context.getConfig().getBoolean("event.overspeed.notRepeat"), Context.getConfig().getBoolean("event.overspeed.preferLowest"));
    }

    public static void init(IdentityManager testIdentityManager) {
        config = new Config();
        objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JSR353Module());
        client = (Client)ClientBuilder.newClient().register((Object)new ObjectMapperContextResolver());
        identityManager = testIdentityManager;
    }

    public static <T extends BaseModel> BaseObjectManager<T> getManager(Class<T> clazz) {
        if (clazz.equals(Device.class)) {
            return deviceManager;
        }
        if (clazz.equals(Group.class)) {
            return groupsManager;
        }
        if (clazz.equals(User.class)) {
            return usersManager;
        }
        if (clazz.equals(Calendar.class)) {
            return calendarManager;
        }
        if (clazz.equals(Attribute.class)) {
            return attributesManager;
        }
        if (clazz.equals(Geofence.class)) {
            return geofenceManager;
        }
        if (clazz.equals(Driver.class)) {
            return driversManager;
        }
        if (clazz.equals(Command.class)) {
            return commandsManager;
        }
        if (clazz.equals(Maintenance.class)) {
            return maintenancesManager;
        }
        if (clazz.equals(Notification.class)) {
            return notificationManager;
        }
        return null;
    }

    static {
        client = ClientBuilder.newClient();
    }

    private static class ObjectMapperContextResolver
    implements ContextResolver<ObjectMapper> {
        private ObjectMapperContextResolver() {
        }

        public ObjectMapper getContext(Class<?> clazz) {
            return objectMapper;
        }
    }
}

