/*
 * Decompiled with CFR 0.152.
 */
package org.traccar;

import io.netty.buffer.Unpooled;
import io.netty.handler.codec.string.StringEncoder;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.traccar.BasePipelineFactory;
import org.traccar.Context;
import org.traccar.Protocol;
import org.traccar.StringProtocolEncoder;
import org.traccar.TrackerServer;
import org.traccar.database.ActiveDevice;
import org.traccar.helper.DataConverter;
import org.traccar.model.Command;

public abstract class BaseProtocol
implements Protocol {
    private final String name;
    private final Set<String> supportedDataCommands = new HashSet<String>();
    private final Set<String> supportedTextCommands = new HashSet<String>();
    private final List<TrackerServer> serverList = new LinkedList<TrackerServer>();
    private StringProtocolEncoder textCommandEncoder = null;

    public static String nameFromClass(Class<?> clazz) {
        String className = clazz.getSimpleName();
        return className.substring(0, className.length() - 8).toLowerCase();
    }

    public BaseProtocol() {
        this.name = BaseProtocol.nameFromClass(this.getClass());
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void addServer(TrackerServer server) {
        this.serverList.add(server);
    }

    @Override
    public Collection<TrackerServer> getServerList() {
        return this.serverList;
    }

    public void setSupportedDataCommands(String ... commands) {
        this.supportedDataCommands.addAll(Arrays.asList(commands));
    }

    public void setSupportedTextCommands(String ... commands) {
        this.supportedTextCommands.addAll(Arrays.asList(commands));
    }

    public void setSupportedCommands(String ... commands) {
        this.supportedDataCommands.addAll(Arrays.asList(commands));
        this.supportedTextCommands.addAll(Arrays.asList(commands));
    }

    @Override
    public Collection<String> getSupportedDataCommands() {
        HashSet<String> commands = new HashSet<String>(this.supportedDataCommands);
        commands.add("custom");
        return commands;
    }

    @Override
    public Collection<String> getSupportedTextCommands() {
        HashSet<String> commands = new HashSet<String>(this.supportedTextCommands);
        commands.add("custom");
        return commands;
    }

    @Override
    public void sendDataCommand(ActiveDevice activeDevice, Command command) {
        if (this.supportedDataCommands.contains(command.getType())) {
            activeDevice.write(command);
        } else if (command.getType().equals("custom")) {
            String data = command.getString("data");
            if (BasePipelineFactory.getHandler(activeDevice.getChannel().pipeline(), StringEncoder.class) != null) {
                activeDevice.write(data);
            } else {
                activeDevice.write(Unpooled.wrappedBuffer((byte[])DataConverter.parseHex(data)));
            }
        } else {
            throw new RuntimeException("Command " + command.getType() + " is not supported in protocol " + this.getName());
        }
    }

    public void setTextCommandEncoder(StringProtocolEncoder textCommandEncoder) {
        this.textCommandEncoder = textCommandEncoder;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void sendTextCommand(String destAddress, Command command) throws Exception {
        if (Context.getSmsManager() == null) throw new RuntimeException("SMS is not enabled");
        if (command.getType().equals("custom")) {
            Context.getSmsManager().sendMessageSync(destAddress, command.getString("data"), true);
            return;
        } else {
            if (!this.supportedTextCommands.contains(command.getType()) || this.textCommandEncoder == null) throw new RuntimeException("Command " + command.getType() + " is not supported in protocol " + this.getName());
            String encodedCommand = (String)this.textCommandEncoder.encodeCommand(command);
            if (encodedCommand == null) throw new RuntimeException("Failed to encode command");
            Context.getSmsManager().sendMessageSync(destAddress, encodedCommand, true);
        }
    }
}

