/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.ltr.model;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.solr.ltr.feature.Feature;
import org.apache.solr.ltr.model.ModelException;
import org.apache.solr.ltr.model.WrapperModel;
import org.apache.solr.ltr.norm.Normalizer;
import org.noggit.JSONParser;
import org.noggit.ObjectBuilder;

public class DefaultWrapperModel
extends WrapperModel {
    private String resource;

    public DefaultWrapperModel(String name, List<Feature> features, List<Normalizer> norms, String featureStoreName, List<Feature> allFeatures, Map<String, Object> params) {
        super(name, features, norms, featureStoreName, allFeatures, params);
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    @Override
    protected void validate() throws ModelException {
        super.validate();
        if (this.resource == null) {
            throw new ModelException("no resource configured for model " + this.name);
        }
    }

    @Override
    public Map<String, Object> fetchModelMap() throws ModelException {
        Map<String, Object> modelMapObj;
        try (InputStream in = this.openInputStream();){
            modelMapObj = this.parseInputStream(in);
        }
        catch (IOException e) {
            throw new ModelException("Failed to fetch the wrapper model from given resource (" + this.resource + ")", e);
        }
        return modelMapObj;
    }

    protected InputStream openInputStream() throws IOException {
        return this.solrResourceLoader.openResource(this.resource);
    }

    protected Map<String, Object> parseInputStream(InputStream in) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
            Map map = (Map)new ObjectBuilder(new JSONParser((Reader)reader)).getVal();
            return map;
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("(name=").append(this.getName());
        sb.append(",resource=").append(this.resource);
        sb.append(",model=(").append(this.model.toString()).append(")");
        return sb.toString();
    }
}

