/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util.stats;

import org.apache.http.config.Registry;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.metrics.SolrMetricProducer;

public class InstrumentedPoolingHttpClientConnectionManager
extends PoolingHttpClientConnectionManager
implements SolrMetricProducer {
    private SolrMetricManager metricManager;
    private String registryName;

    public InstrumentedPoolingHttpClientConnectionManager(Registry<ConnectionSocketFactory> socketFactoryRegistry) {
        super(socketFactoryRegistry);
    }

    @Override
    public void initializeMetrics(SolrMetricManager manager, String registry, String tag, String scope) {
        this.metricManager = manager;
        this.registryName = registry;
        manager.registerGauge(null, registry, () -> this.getTotalStats().getAvailable(), tag, true, SolrMetricManager.mkName("availableConnections", scope), new String[0]);
        manager.registerGauge(null, registry, () -> this.getTotalStats().getLeased(), tag, true, SolrMetricManager.mkName("leasedConnections", scope), new String[0]);
        manager.registerGauge(null, registry, () -> this.getTotalStats().getMax(), tag, true, SolrMetricManager.mkName("maxConnections", scope), new String[0]);
        manager.registerGauge(null, registry, () -> this.getTotalStats().getPending(), tag, true, SolrMetricManager.mkName("pendingConnections", scope), new String[0]);
    }
}

