/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.CheckIndex;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.Impact;
import org.apache.lucene.index.Impacts;
import org.apache.lucene.index.ImpactsEnum;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.VirtualMethod;
import org.apache.lucene.util.automaton.CompiledAutomaton;

public class AssertingLeafReader
extends FilterLeafReader {
    static final VirtualMethod<TermsEnum> SEEK_EXACT = new VirtualMethod(TermsEnum.class, "seekExact", new Class[]{BytesRef.class});

    private static void assertThread(String object, Thread creationThread) {
        if (creationThread != Thread.currentThread()) {
            throw new AssertionError((Object)(object + " are only supposed to be consumed in the thread in which they have been acquired. But was acquired in " + creationThread + " and consumed in " + Thread.currentThread() + "."));
        }
    }

    public AssertingLeafReader(LeafReader in) {
        super(in);
        IndexReader.CacheHelper readerCacheHelper;
        assert (in.maxDoc() >= 0);
        assert (in.numDocs() <= in.maxDoc());
        assert (in.numDeletedDocs() + in.numDocs() == in.maxDoc());
        assert (!in.hasDeletions() || in.numDeletedDocs() > 0 && in.numDocs() < in.maxDoc());
        IndexReader.CacheHelper coreCacheHelper = in.getCoreCacheHelper();
        if (coreCacheHelper != null) {
            coreCacheHelper.addClosedListener(cacheKey -> {
                IndexReader.CacheKey expectedKey = coreCacheHelper.getKey();
                assert (expectedKey == cacheKey) : "Core closed listener called on a different key " + expectedKey + " <> " + cacheKey;
            });
        }
        if ((readerCacheHelper = in.getReaderCacheHelper()) != null) {
            readerCacheHelper.addClosedListener(cacheKey -> {
                IndexReader.CacheKey expectedKey = readerCacheHelper.getKey();
                assert (expectedKey == cacheKey) : "Core closed listener called on a different key " + expectedKey + " <> " + cacheKey;
            });
        }
    }

    public Terms terms(String field) throws IOException {
        Terms terms = super.terms(field);
        return terms == null ? null : new AssertingTerms(terms);
    }

    public Fields getTermVectors(int docID) throws IOException {
        Fields fields = super.getTermVectors(docID);
        return fields == null ? null : new AssertingFields(fields);
    }

    public NumericDocValues getNumericDocValues(String field) throws IOException {
        NumericDocValues dv = super.getNumericDocValues(field);
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (dv != null) {
            assert (fi != null);
            assert (fi.getDocValuesType() == DocValuesType.NUMERIC);
            return new AssertingNumericDocValues(dv, this.maxDoc());
        }
        assert (fi == null || fi.getDocValuesType() != DocValuesType.NUMERIC);
        return null;
    }

    public BinaryDocValues getBinaryDocValues(String field) throws IOException {
        BinaryDocValues dv = super.getBinaryDocValues(field);
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (dv != null) {
            assert (fi != null);
            assert (fi.getDocValuesType() == DocValuesType.BINARY);
            return new AssertingBinaryDocValues(dv, this.maxDoc());
        }
        assert (fi == null || fi.getDocValuesType() != DocValuesType.BINARY);
        return null;
    }

    public SortedDocValues getSortedDocValues(String field) throws IOException {
        SortedDocValues dv = super.getSortedDocValues(field);
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (dv != null) {
            assert (fi != null);
            assert (fi.getDocValuesType() == DocValuesType.SORTED);
            return new AssertingSortedDocValues(dv, this.maxDoc());
        }
        assert (fi == null || fi.getDocValuesType() != DocValuesType.SORTED);
        return null;
    }

    public SortedNumericDocValues getSortedNumericDocValues(String field) throws IOException {
        SortedNumericDocValues dv = super.getSortedNumericDocValues(field);
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (dv != null) {
            assert (fi != null);
            assert (fi.getDocValuesType() == DocValuesType.SORTED_NUMERIC);
            return new AssertingSortedNumericDocValues(dv, this.maxDoc());
        }
        assert (fi == null || fi.getDocValuesType() != DocValuesType.SORTED_NUMERIC);
        return null;
    }

    public SortedSetDocValues getSortedSetDocValues(String field) throws IOException {
        SortedSetDocValues dv = super.getSortedSetDocValues(field);
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (dv != null) {
            assert (fi != null);
            assert (fi.getDocValuesType() == DocValuesType.SORTED_SET);
            return new AssertingSortedSetDocValues(dv, this.maxDoc());
        }
        assert (fi == null || fi.getDocValuesType() != DocValuesType.SORTED_SET);
        return null;
    }

    public NumericDocValues getNormValues(String field) throws IOException {
        NumericDocValues dv = super.getNormValues(field);
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (dv != null) {
            assert (fi != null);
            assert (fi.hasNorms());
            return new AssertingNumericDocValues(dv, this.maxDoc());
        }
        assert (fi == null || !fi.hasNorms());
        return null;
    }

    public PointValues getPointValues(String field) throws IOException {
        PointValues values = this.in.getPointValues(field);
        if (values == null) {
            return null;
        }
        return new AssertingPointValues(values, this.maxDoc());
    }

    public Bits getLiveDocs() {
        Bits liveDocs = super.getLiveDocs();
        if (liveDocs != null) {
            assert (this.maxDoc() == liveDocs.length());
            liveDocs = new AssertingBits(liveDocs);
        } else {
            assert (this.maxDoc() == this.numDocs());
            assert (!this.hasDeletions());
        }
        return liveDocs;
    }

    public IndexReader.CacheHelper getCoreCacheHelper() {
        return this.in.getCoreCacheHelper();
    }

    public IndexReader.CacheHelper getReaderCacheHelper() {
        return this.in.getReaderCacheHelper();
    }

    public static class AssertingBits
    implements Bits {
        private final Thread creationThread = Thread.currentThread();
        final Bits in;

        public AssertingBits(Bits in) {
            this.in = in;
        }

        public boolean get(int index) {
            AssertingLeafReader.assertThread("Bits", this.creationThread);
            assert (index >= 0 && index < this.length());
            return this.in.get(index);
        }

        public int length() {
            AssertingLeafReader.assertThread("Bits", this.creationThread);
            return this.in.length();
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class AssertingIntersectVisitor
    implements PointValues.IntersectVisitor {
        final PointValues.IntersectVisitor in;
        final int numDataDims;
        final int numIndexDims;
        final int bytesPerDim;
        final byte[] lastDocValue;
        final byte[] lastMinPackedValue;
        final byte[] lastMaxPackedValue;
        private PointValues.Relation lastCompareResult;
        private int lastDocID = -1;
        private int docBudget;

        AssertingIntersectVisitor(int numDataDims, int numIndexDims, int bytesPerDim, PointValues.IntersectVisitor in) {
            this.in = in;
            this.numDataDims = numDataDims;
            this.numIndexDims = numIndexDims;
            this.bytesPerDim = bytesPerDim;
            this.lastMaxPackedValue = new byte[numDataDims * bytesPerDim];
            this.lastMinPackedValue = new byte[numDataDims * bytesPerDim];
            this.lastDocValue = (byte[])(numDataDims == 1 ? new byte[bytesPerDim] : null);
        }

        public void visit(int docID) throws IOException {
            assert (--this.docBudget >= 0) : "called add() more times than the last call to grow() reserved";
            assert (this.lastCompareResult == PointValues.Relation.CELL_INSIDE_QUERY);
            this.in.visit(docID);
        }

        public void visit(int docID, byte[] packedValue) throws IOException {
            assert (--this.docBudget >= 0) : "called add() more times than the last call to grow() reserved";
            assert (this.lastCompareResult == PointValues.Relation.CELL_CROSSES_QUERY);
            for (int dim = 0; dim < this.numIndexDims; ++dim) {
                assert (Arrays.compareUnsigned(this.lastMinPackedValue, dim * this.bytesPerDim, dim * this.bytesPerDim + this.bytesPerDim, packedValue, dim * this.bytesPerDim, dim * this.bytesPerDim + this.bytesPerDim) <= 0) : "dim=" + dim + " of " + this.numDataDims + " value=" + new BytesRef(packedValue);
                assert (Arrays.compareUnsigned(this.lastMaxPackedValue, dim * this.bytesPerDim, dim * this.bytesPerDim + this.bytesPerDim, packedValue, dim * this.bytesPerDim, dim * this.bytesPerDim + this.bytesPerDim) >= 0) : "dim=" + dim + " of " + this.numDataDims + " value=" + new BytesRef(packedValue);
            }
            assert (packedValue.length == this.numDataDims * this.bytesPerDim);
            if (this.numDataDims == 1) {
                int cmp = Arrays.compareUnsigned(this.lastDocValue, 0, this.bytesPerDim, packedValue, 0, this.bytesPerDim);
                if (cmp >= 0) {
                    if (cmp == 0) {
                        assert (this.lastDocID <= docID) : "doc ids are out of order when point values are the same!";
                    } else assert (false) : "point values are out of order";
                }
                System.arraycopy(packedValue, 0, this.lastDocValue, 0, this.bytesPerDim);
                this.lastDocID = docID;
            }
            this.in.visit(docID, packedValue);
        }

        public void grow(int count) {
            this.in.grow(count);
            this.docBudget = count;
        }

        public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
            for (int dim = 0; dim < this.numIndexDims; ++dim) {
                assert (Arrays.compareUnsigned(minPackedValue, dim * this.bytesPerDim, dim * this.bytesPerDim + this.bytesPerDim, maxPackedValue, dim * this.bytesPerDim, dim * this.bytesPerDim + this.bytesPerDim) <= 0);
            }
            System.arraycopy(maxPackedValue, 0, this.lastMaxPackedValue, 0, this.numIndexDims * this.bytesPerDim);
            System.arraycopy(minPackedValue, 0, this.lastMinPackedValue, 0, this.numIndexDims * this.bytesPerDim);
            this.lastCompareResult = this.in.compare(minPackedValue, maxPackedValue);
            return this.lastCompareResult;
        }
    }

    public static class AssertingPointValues
    extends PointValues {
        private final PointValues in;

        public AssertingPointValues(PointValues in, int maxDoc) {
            this.in = in;
            this.assertStats(maxDoc);
        }

        public PointValues getWrapped() {
            return this.in;
        }

        private void assertStats(int maxDoc) {
            assert (this.in.size() > 0L);
            assert (this.in.getDocCount() > 0);
            assert ((long)this.in.getDocCount() <= this.in.size());
            assert (this.in.getDocCount() <= maxDoc);
        }

        public void intersect(PointValues.IntersectVisitor visitor) throws IOException {
            this.in.intersect((PointValues.IntersectVisitor)new AssertingIntersectVisitor(this.in.getNumDataDimensions(), this.in.getNumIndexDimensions(), this.in.getBytesPerDimension(), visitor));
        }

        public long estimatePointCount(PointValues.IntersectVisitor visitor) {
            long cost = this.in.estimatePointCount(visitor);
            assert (cost >= 0L);
            return cost;
        }

        public byte[] getMinPackedValue() throws IOException {
            return Objects.requireNonNull(this.in.getMinPackedValue());
        }

        public byte[] getMaxPackedValue() throws IOException {
            return Objects.requireNonNull(this.in.getMaxPackedValue());
        }

        public int getNumDataDimensions() throws IOException {
            return this.in.getNumDataDimensions();
        }

        public int getNumIndexDimensions() throws IOException {
            return this.in.getNumIndexDimensions();
        }

        public int getBytesPerDimension() throws IOException {
            return this.in.getBytesPerDimension();
        }

        public long size() {
            return this.in.size();
        }

        public int getDocCount() {
            return this.in.getDocCount();
        }
    }

    public static class AssertingSortedSetDocValues
    extends SortedSetDocValues {
        private final Thread creationThread = Thread.currentThread();
        private final SortedSetDocValues in;
        private final int maxDoc;
        private final long valueCount;
        private int lastDocID = -1;
        private long lastOrd = -1L;
        private boolean exists;

        public AssertingSortedSetDocValues(SortedSetDocValues in, int maxDoc) {
            this.in = in;
            this.maxDoc = maxDoc;
            this.valueCount = in.getValueCount();
            assert (this.valueCount >= 0L);
        }

        public int docID() {
            AssertingLeafReader.assertThread("Sorted set doc values", this.creationThread);
            return this.in.docID();
        }

        public int nextDoc() throws IOException {
            AssertingLeafReader.assertThread("Sorted set doc values", this.creationThread);
            int docID = this.in.nextDoc();
            assert (docID > this.lastDocID);
            assert (docID == Integer.MAX_VALUE || docID < this.maxDoc);
            assert (docID == this.in.docID());
            this.lastDocID = docID;
            this.lastOrd = -2L;
            this.exists = docID != Integer.MAX_VALUE;
            return docID;
        }

        public int advance(int target) throws IOException {
            AssertingLeafReader.assertThread("Sorted set doc values", this.creationThread);
            assert (target >= 0);
            assert (target > this.in.docID());
            int docID = this.in.advance(target);
            assert (docID == this.in.docID());
            assert (docID >= target);
            assert (docID == Integer.MAX_VALUE || docID < this.maxDoc);
            this.lastDocID = docID;
            this.lastOrd = -2L;
            this.exists = docID != Integer.MAX_VALUE;
            return docID;
        }

        public boolean advanceExact(int target) throws IOException {
            AssertingLeafReader.assertThread("Numeric doc values", this.creationThread);
            assert (target >= 0);
            assert (target >= this.in.docID());
            assert (target < this.maxDoc);
            this.exists = this.in.advanceExact(target);
            assert (this.in.docID() == target);
            this.lastDocID = target;
            this.lastOrd = -2L;
            return this.exists;
        }

        public long cost() {
            AssertingLeafReader.assertThread("Sorted set doc values", this.creationThread);
            long cost = this.in.cost();
            assert (cost >= 0L);
            return cost;
        }

        public long nextOrd() throws IOException {
            AssertingLeafReader.assertThread("Sorted set doc values", this.creationThread);
            assert (this.lastOrd != -1L);
            assert (this.exists);
            long ord = this.in.nextOrd();
            assert (ord < this.valueCount);
            assert (ord == -1L || ord > this.lastOrd);
            this.lastOrd = ord;
            return ord;
        }

        public BytesRef lookupOrd(long ord) throws IOException {
            AssertingLeafReader.assertThread("Sorted set doc values", this.creationThread);
            assert (ord >= 0L && ord < this.valueCount);
            BytesRef result = this.in.lookupOrd(ord);
            assert (result.isValid());
            return result;
        }

        public long getValueCount() {
            AssertingLeafReader.assertThread("Sorted set doc values", this.creationThread);
            long valueCount = this.in.getValueCount();
            assert (valueCount == this.valueCount);
            return valueCount;
        }

        public long lookupTerm(BytesRef key) throws IOException {
            AssertingLeafReader.assertThread("Sorted set doc values", this.creationThread);
            assert (key.isValid());
            long result = this.in.lookupTerm(key);
            assert (result < this.valueCount);
            assert (key.isValid());
            return result;
        }
    }

    public static class AssertingSortedNumericDocValues
    extends SortedNumericDocValues {
        private final Thread creationThread = Thread.currentThread();
        private final SortedNumericDocValues in;
        private final int maxDoc;
        private int lastDocID = -1;
        private int valueUpto;
        private boolean exists;

        public AssertingSortedNumericDocValues(SortedNumericDocValues in, int maxDoc) {
            this.in = in;
            this.maxDoc = maxDoc;
        }

        public int docID() {
            return this.in.docID();
        }

        public int nextDoc() throws IOException {
            AssertingLeafReader.assertThread("Sorted numeric doc values", this.creationThread);
            int docID = this.in.nextDoc();
            assert (docID > this.lastDocID);
            assert (docID == Integer.MAX_VALUE || docID < this.maxDoc);
            assert (docID == this.in.docID());
            this.lastDocID = docID;
            this.valueUpto = 0;
            this.exists = docID != Integer.MAX_VALUE;
            return docID;
        }

        public int advance(int target) throws IOException {
            AssertingLeafReader.assertThread("Sorted numeric doc values", this.creationThread);
            assert (target >= 0);
            assert (target > this.in.docID());
            int docID = this.in.advance(target);
            assert (docID == this.in.docID());
            assert (docID >= target);
            assert (docID == Integer.MAX_VALUE || docID < this.maxDoc);
            this.lastDocID = docID;
            this.valueUpto = 0;
            this.exists = docID != Integer.MAX_VALUE;
            return docID;
        }

        public boolean advanceExact(int target) throws IOException {
            AssertingLeafReader.assertThread("Numeric doc values", this.creationThread);
            assert (target >= 0);
            assert (target >= this.in.docID());
            assert (target < this.maxDoc);
            this.exists = this.in.advanceExact(target);
            assert (this.in.docID() == target);
            this.lastDocID = target;
            this.valueUpto = 0;
            return this.exists;
        }

        public long cost() {
            AssertingLeafReader.assertThread("Sorted numeric doc values", this.creationThread);
            long cost = this.in.cost();
            assert (cost >= 0L);
            return cost;
        }

        public long nextValue() throws IOException {
            AssertingLeafReader.assertThread("Sorted numeric doc values", this.creationThread);
            assert (this.exists);
            assert (this.valueUpto < this.in.docValueCount()) : "valueUpto=" + this.valueUpto + " in.docValueCount()=" + this.in.docValueCount();
            ++this.valueUpto;
            return this.in.nextValue();
        }

        public int docValueCount() {
            AssertingLeafReader.assertThread("Sorted numeric doc values", this.creationThread);
            assert (this.exists);
            assert (this.in.docValueCount() > 0);
            return this.in.docValueCount();
        }
    }

    public static class AssertingSortedDocValues
    extends SortedDocValues {
        private final Thread creationThread = Thread.currentThread();
        private final SortedDocValues in;
        private final int maxDoc;
        private final int valueCount;
        private int lastDocID = -1;
        private boolean exists;

        public AssertingSortedDocValues(SortedDocValues in, int maxDoc) {
            this.in = in;
            this.maxDoc = maxDoc;
            this.valueCount = in.getValueCount();
            assert (this.valueCount >= 0 && this.valueCount <= maxDoc);
        }

        public int docID() {
            AssertingLeafReader.assertThread("Sorted doc values", this.creationThread);
            return this.in.docID();
        }

        public int nextDoc() throws IOException {
            AssertingLeafReader.assertThread("Sorted doc values", this.creationThread);
            int docID = this.in.nextDoc();
            assert (docID > this.lastDocID);
            assert (docID == Integer.MAX_VALUE || docID < this.maxDoc);
            assert (docID == this.in.docID());
            this.lastDocID = docID;
            this.exists = docID != Integer.MAX_VALUE;
            return docID;
        }

        public int advance(int target) throws IOException {
            AssertingLeafReader.assertThread("Sorted doc values", this.creationThread);
            assert (target >= 0);
            assert (target > this.in.docID());
            int docID = this.in.advance(target);
            assert (docID >= target);
            assert (docID == Integer.MAX_VALUE || docID < this.maxDoc);
            this.lastDocID = docID;
            this.exists = docID != Integer.MAX_VALUE;
            return docID;
        }

        public boolean advanceExact(int target) throws IOException {
            AssertingLeafReader.assertThread("Numeric doc values", this.creationThread);
            assert (target >= 0);
            assert (target >= this.in.docID());
            assert (target < this.maxDoc);
            this.exists = this.in.advanceExact(target);
            assert (this.in.docID() == target);
            this.lastDocID = target;
            return this.exists;
        }

        public long cost() {
            AssertingLeafReader.assertThread("Sorted doc values", this.creationThread);
            long cost = this.in.cost();
            assert (cost >= 0L);
            return cost;
        }

        public int ordValue() throws IOException {
            AssertingLeafReader.assertThread("Sorted doc values", this.creationThread);
            assert (this.exists);
            int ord = this.in.ordValue();
            assert (ord >= -1 && ord < this.valueCount);
            return ord;
        }

        public BytesRef lookupOrd(int ord) throws IOException {
            AssertingLeafReader.assertThread("Sorted doc values", this.creationThread);
            assert (ord >= 0 && ord < this.valueCount);
            BytesRef result = this.in.lookupOrd(ord);
            assert (result.isValid());
            return result;
        }

        public int getValueCount() {
            AssertingLeafReader.assertThread("Sorted doc values", this.creationThread);
            int valueCount = this.in.getValueCount();
            assert (valueCount == this.valueCount);
            return valueCount;
        }

        public BytesRef binaryValue() throws IOException {
            AssertingLeafReader.assertThread("Sorted doc values", this.creationThread);
            BytesRef result = this.in.binaryValue();
            assert (result.isValid());
            return result;
        }

        public int lookupTerm(BytesRef key) throws IOException {
            AssertingLeafReader.assertThread("Sorted doc values", this.creationThread);
            assert (key.isValid());
            int result = this.in.lookupTerm(key);
            assert (result < this.valueCount);
            assert (key.isValid());
            return result;
        }
    }

    public static class AssertingBinaryDocValues
    extends BinaryDocValues {
        private final Thread creationThread = Thread.currentThread();
        private final BinaryDocValues in;
        private final int maxDoc;
        private int lastDocID = -1;
        private boolean exists;

        public AssertingBinaryDocValues(BinaryDocValues in, int maxDoc) {
            this.in = in;
            this.maxDoc = maxDoc;
            assert (in.docID() == -1);
        }

        public int docID() {
            AssertingLeafReader.assertThread("Binary doc values", this.creationThread);
            return this.in.docID();
        }

        public int nextDoc() throws IOException {
            AssertingLeafReader.assertThread("Binary doc values", this.creationThread);
            int docID = this.in.nextDoc();
            assert (docID > this.lastDocID);
            assert (docID == Integer.MAX_VALUE || docID < this.maxDoc);
            assert (docID == this.in.docID());
            this.lastDocID = docID;
            this.exists = docID != Integer.MAX_VALUE;
            return docID;
        }

        public int advance(int target) throws IOException {
            AssertingLeafReader.assertThread("Binary doc values", this.creationThread);
            assert (target >= 0);
            assert (target > this.in.docID());
            int docID = this.in.advance(target);
            assert (docID >= target);
            assert (docID == Integer.MAX_VALUE || docID < this.maxDoc);
            this.lastDocID = docID;
            this.exists = docID != Integer.MAX_VALUE;
            return docID;
        }

        public boolean advanceExact(int target) throws IOException {
            AssertingLeafReader.assertThread("Numeric doc values", this.creationThread);
            assert (target >= 0);
            assert (target >= this.in.docID());
            assert (target < this.maxDoc);
            this.exists = this.in.advanceExact(target);
            assert (this.in.docID() == target);
            this.lastDocID = target;
            return this.exists;
        }

        public long cost() {
            AssertingLeafReader.assertThread("Binary doc values", this.creationThread);
            long cost = this.in.cost();
            assert (cost >= 0L);
            return cost;
        }

        public BytesRef binaryValue() throws IOException {
            AssertingLeafReader.assertThread("Binary doc values", this.creationThread);
            assert (this.exists);
            return this.in.binaryValue();
        }

        public String toString() {
            return "AssertingBinaryDocValues(" + this.in + ")";
        }
    }

    public static class AssertingNumericDocValues
    extends NumericDocValues {
        private final Thread creationThread = Thread.currentThread();
        private final NumericDocValues in;
        private final int maxDoc;
        private int lastDocID = -1;
        private boolean exists;

        public AssertingNumericDocValues(NumericDocValues in, int maxDoc) {
            this.in = in;
            this.maxDoc = maxDoc;
            assert (in.docID() == -1);
        }

        public int docID() {
            AssertingLeafReader.assertThread("Numeric doc values", this.creationThread);
            return this.in.docID();
        }

        public int nextDoc() throws IOException {
            AssertingLeafReader.assertThread("Numeric doc values", this.creationThread);
            int docID = this.in.nextDoc();
            assert (docID > this.lastDocID);
            assert (docID == Integer.MAX_VALUE || docID < this.maxDoc);
            assert (docID == this.in.docID());
            this.lastDocID = docID;
            this.exists = docID != Integer.MAX_VALUE;
            return docID;
        }

        public int advance(int target) throws IOException {
            AssertingLeafReader.assertThread("Numeric doc values", this.creationThread);
            assert (target >= 0);
            assert (target > this.in.docID());
            int docID = this.in.advance(target);
            assert (docID >= target);
            assert (docID == Integer.MAX_VALUE || docID < this.maxDoc);
            this.lastDocID = docID;
            this.exists = docID != Integer.MAX_VALUE;
            return docID;
        }

        public boolean advanceExact(int target) throws IOException {
            AssertingLeafReader.assertThread("Numeric doc values", this.creationThread);
            assert (target >= 0);
            assert (target >= this.in.docID());
            assert (target < this.maxDoc);
            this.exists = this.in.advanceExact(target);
            assert (this.in.docID() == target);
            this.lastDocID = target;
            return this.exists;
        }

        public long cost() {
            AssertingLeafReader.assertThread("Numeric doc values", this.creationThread);
            long cost = this.in.cost();
            assert (cost >= 0L);
            return cost;
        }

        public long longValue() throws IOException {
            AssertingLeafReader.assertThread("Numeric doc values", this.creationThread);
            assert (this.exists);
            return this.in.longValue();
        }

        public String toString() {
            return "AssertingNumericDocValues(" + this.in + ")";
        }
    }

    static class AssertingImpacts
    extends Impacts {
        private final Impacts in;
        private final AssertingImpactsEnum impactsEnum;
        private final int validFor;

        AssertingImpacts(Impacts in, AssertingImpactsEnum impactsEnum) {
            this.in = in;
            this.impactsEnum = impactsEnum;
            this.validFor = Math.max(impactsEnum.docID(), impactsEnum.lastShallowTarget);
        }

        public int numLevels() {
            assert (this.validFor == Math.max(this.impactsEnum.docID(), this.impactsEnum.lastShallowTarget)) : "Cannot reuse impacts after advancing the iterator";
            return this.in.numLevels();
        }

        public int getDocIdUpTo(int level) {
            assert (this.validFor == Math.max(this.impactsEnum.docID(), this.impactsEnum.lastShallowTarget)) : "Cannot reuse impacts after advancing the iterator";
            return this.in.getDocIdUpTo(level);
        }

        public List<Impact> getImpacts(int level) {
            assert (this.validFor == Math.max(this.impactsEnum.docID(), this.impactsEnum.lastShallowTarget)) : "Cannot reuse impacts after advancing the iterator";
            return this.in.getImpacts(level);
        }
    }

    public static class AssertingImpactsEnum
    extends ImpactsEnum {
        private final AssertingPostingsEnum assertingPostings;
        private final ImpactsEnum in;
        private int lastShallowTarget = -1;

        AssertingImpactsEnum(ImpactsEnum impacts) {
            this.in = impacts;
            this.assertingPostings = new AssertingPostingsEnum((PostingsEnum)impacts);
        }

        public void advanceShallow(int target) throws IOException {
            assert (target >= this.lastShallowTarget) : "called on decreasing targets: target = " + target + " < last target = " + this.lastShallowTarget;
            assert (target >= this.docID()) : "target = " + target + " < docID = " + this.docID();
            this.lastShallowTarget = target;
            this.in.advanceShallow(target);
        }

        public Impacts getImpacts() throws IOException {
            assert (this.docID() >= 0 || this.lastShallowTarget >= 0) : "Cannot get impacts until the iterator is positioned or advanceShallow has been called";
            Impacts impacts = this.in.getImpacts();
            CheckIndex.checkImpacts((Impacts)impacts, (int)Math.max(this.docID(), this.lastShallowTarget));
            return new AssertingImpacts(impacts, this);
        }

        public int freq() throws IOException {
            return this.assertingPostings.freq();
        }

        public int nextPosition() throws IOException {
            return this.assertingPostings.nextPosition();
        }

        public int startOffset() throws IOException {
            return this.assertingPostings.startOffset();
        }

        public int endOffset() throws IOException {
            return this.assertingPostings.endOffset();
        }

        public BytesRef getPayload() throws IOException {
            return this.assertingPostings.getPayload();
        }

        public int docID() {
            return this.assertingPostings.docID();
        }

        public int nextDoc() throws IOException {
            assert (this.docID() + 1 >= this.lastShallowTarget) : "target = " + (this.docID() + 1) + " < last shallow target = " + this.lastShallowTarget;
            return this.assertingPostings.nextDoc();
        }

        public int advance(int target) throws IOException {
            assert (target >= this.lastShallowTarget) : "target = " + target + " < last shallow target = " + this.lastShallowTarget;
            return this.assertingPostings.advance(target);
        }

        public long cost() {
            return this.assertingPostings.cost();
        }
    }

    public static class AssertingPostingsEnum
    extends FilterLeafReader.FilterPostingsEnum {
        private final Thread creationThread = Thread.currentThread();
        private DocsEnumState state = DocsEnumState.START;
        int positionCount = 0;
        int positionMax = 0;
        private int doc;

        public AssertingPostingsEnum(PostingsEnum in) {
            super(in);
            this.doc = in.docID();
        }

        public int nextDoc() throws IOException {
            AssertingLeafReader.assertThread("Docs enums", this.creationThread);
            assert (this.state != DocsEnumState.FINISHED) : "nextDoc() called after NO_MORE_DOCS";
            int nextDoc = super.nextDoc();
            assert (nextDoc > this.doc) : "backwards nextDoc from " + this.doc + " to " + nextDoc + " " + this.in;
            if (nextDoc == Integer.MAX_VALUE) {
                this.state = DocsEnumState.FINISHED;
                this.positionMax = 0;
            } else {
                this.state = DocsEnumState.ITERATING;
                this.positionMax = super.freq();
            }
            this.positionCount = 0;
            assert (super.docID() == nextDoc);
            this.doc = nextDoc;
            return this.doc;
        }

        public int advance(int target) throws IOException {
            AssertingLeafReader.assertThread("Docs enums", this.creationThread);
            assert (this.state != DocsEnumState.FINISHED) : "advance() called after NO_MORE_DOCS";
            assert (target > this.doc) : "target must be > docID(), got " + target + " <= " + this.doc;
            int advanced = super.advance(target);
            assert (advanced >= target) : "backwards advance from: " + target + " to: " + advanced;
            if (advanced == Integer.MAX_VALUE) {
                this.state = DocsEnumState.FINISHED;
                this.positionMax = 0;
            } else {
                this.state = DocsEnumState.ITERATING;
                this.positionMax = super.freq();
            }
            this.positionCount = 0;
            assert (super.docID() == advanced);
            this.doc = advanced;
            return this.doc;
        }

        public int docID() {
            AssertingLeafReader.assertThread("Docs enums", this.creationThread);
            assert (this.doc == super.docID()) : " invalid docID() in " + this.in.getClass() + " " + super.docID() + " instead of " + this.doc;
            return this.doc;
        }

        public int freq() throws IOException {
            AssertingLeafReader.assertThread("Docs enums", this.creationThread);
            assert (this.state != DocsEnumState.START) : "freq() called before nextDoc()/advance()";
            assert (this.state != DocsEnumState.FINISHED) : "freq() called after NO_MORE_DOCS";
            int freq = super.freq();
            assert (freq > 0);
            return freq;
        }

        public int nextPosition() throws IOException {
            assert (this.state != DocsEnumState.START) : "nextPosition() called before nextDoc()/advance()";
            assert (this.state != DocsEnumState.FINISHED) : "nextPosition() called after NO_MORE_DOCS";
            assert (this.positionCount < this.positionMax) : "nextPosition() called more than freq() times!";
            int position = super.nextPosition();
            assert (position >= 0 || position == -1) : "invalid position: " + position;
            ++this.positionCount;
            return position;
        }

        public int startOffset() throws IOException {
            assert (this.state != DocsEnumState.START) : "startOffset() called before nextDoc()/advance()";
            assert (this.state != DocsEnumState.FINISHED) : "startOffset() called after NO_MORE_DOCS";
            assert (this.positionCount > 0) : "startOffset() called before nextPosition()!";
            return super.startOffset();
        }

        public int endOffset() throws IOException {
            assert (this.state != DocsEnumState.START) : "endOffset() called before nextDoc()/advance()";
            assert (this.state != DocsEnumState.FINISHED) : "endOffset() called after NO_MORE_DOCS";
            assert (this.positionCount > 0) : "endOffset() called before nextPosition()!";
            return super.endOffset();
        }

        public BytesRef getPayload() throws IOException {
            assert (this.state != DocsEnumState.START) : "getPayload() called before nextDoc()/advance()";
            assert (this.state != DocsEnumState.FINISHED) : "getPayload() called after NO_MORE_DOCS";
            assert (this.positionCount > 0) : "getPayload() called before nextPosition()!";
            BytesRef payload = super.getPayload();
            assert (payload == null || payload.length > 0) : "getPayload() returned payload with invalid length!";
            return payload;
        }

        void reset() {
            this.state = DocsEnumState.START;
            this.doc = this.in.docID();
            this.positionMax = 0;
            this.positionCount = 0;
        }
    }

    static enum DocsEnumState {
        START,
        ITERATING,
        FINISHED;

    }

    static class AssertingTermsEnum
    extends FilterLeafReader.FilterTermsEnum {
        private final Thread creationThread = Thread.currentThread();
        private State state = State.INITIAL;
        private final boolean delegateOverridesSeekExact;
        private final boolean hasFreqs;

        public AssertingTermsEnum(TermsEnum in, boolean hasFreqs) {
            super(in);
            this.delegateOverridesSeekExact = SEEK_EXACT.isOverriddenAsOf(in.getClass());
            this.hasFreqs = hasFreqs;
        }

        public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
            AssertingLeafReader.assertThread("Terms enums", this.creationThread);
            assert (this.state == State.POSITIONED) : "docs(...) called on unpositioned TermsEnum";
            PostingsEnum actualReuse = reuse instanceof AssertingPostingsEnum ? ((AssertingPostingsEnum)reuse).in : null;
            PostingsEnum docs = super.postings(actualReuse, flags);
            assert (docs != null);
            if (docs == actualReuse) {
                ((AssertingPostingsEnum)reuse).reset();
                return reuse;
            }
            return new AssertingPostingsEnum(docs);
        }

        public ImpactsEnum impacts(int flags) throws IOException {
            AssertingLeafReader.assertThread("Terms enums", this.creationThread);
            assert (this.state == State.POSITIONED) : "docs(...) called on unpositioned TermsEnum";
            assert ((flags & 8) != 0) : "Freqs should be requested on impacts";
            return new AssertingImpactsEnum(super.impacts(flags));
        }

        public BytesRef next() throws IOException {
            AssertingLeafReader.assertThread("Terms enums", this.creationThread);
            assert (this.state == State.INITIAL || this.state == State.POSITIONED) : "next() called on unpositioned TermsEnum";
            BytesRef result = super.next();
            if (result == null) {
                this.state = State.UNPOSITIONED;
            } else {
                assert (result.isValid());
                this.state = State.POSITIONED;
            }
            return result;
        }

        public long ord() throws IOException {
            AssertingLeafReader.assertThread("Terms enums", this.creationThread);
            assert (this.state == State.POSITIONED) : "ord() called on unpositioned TermsEnum";
            return super.ord();
        }

        public int docFreq() throws IOException {
            AssertingLeafReader.assertThread("Terms enums", this.creationThread);
            assert (this.state == State.POSITIONED) : "docFreq() called on unpositioned TermsEnum";
            int df = super.docFreq();
            assert (df > 0);
            return df;
        }

        public long totalTermFreq() throws IOException {
            AssertingLeafReader.assertThread("Terms enums", this.creationThread);
            assert (this.state == State.POSITIONED) : "totalTermFreq() called on unpositioned TermsEnum";
            long ttf = super.totalTermFreq();
            if (this.hasFreqs ? !$assertionsDisabled && ttf < (long)this.docFreq() : !$assertionsDisabled && ttf != (long)this.docFreq()) {
                throw new AssertionError();
            }
            return ttf;
        }

        public BytesRef term() throws IOException {
            AssertingLeafReader.assertThread("Terms enums", this.creationThread);
            assert (this.state == State.POSITIONED) : "term() called on unpositioned TermsEnum";
            BytesRef ret = super.term();
            assert (ret == null || ret.isValid());
            return ret;
        }

        public void seekExact(long ord) throws IOException {
            AssertingLeafReader.assertThread("Terms enums", this.creationThread);
            super.seekExact(ord);
            this.state = State.POSITIONED;
        }

        public TermsEnum.SeekStatus seekCeil(BytesRef term) throws IOException {
            AssertingLeafReader.assertThread("Terms enums", this.creationThread);
            assert (term.isValid());
            TermsEnum.SeekStatus result = super.seekCeil(term);
            this.state = result == TermsEnum.SeekStatus.END ? State.UNPOSITIONED : State.POSITIONED;
            return result;
        }

        public boolean seekExact(BytesRef text) throws IOException {
            AssertingLeafReader.assertThread("Terms enums", this.creationThread);
            assert (text.isValid());
            boolean result = this.delegateOverridesSeekExact ? this.in.seekExact(text) : super.seekExact(text);
            this.state = result ? State.POSITIONED : State.UNPOSITIONED;
            return result;
        }

        public TermState termState() throws IOException {
            AssertingLeafReader.assertThread("Terms enums", this.creationThread);
            assert (this.state == State.POSITIONED) : "termState() called on unpositioned TermsEnum";
            return this.in.termState();
        }

        public void seekExact(BytesRef term, TermState state) throws IOException {
            AssertingLeafReader.assertThread("Terms enums", this.creationThread);
            assert (term.isValid());
            this.in.seekExact(term, state);
            this.state = State.POSITIONED;
        }

        public String toString() {
            return "AssertingTermsEnum(" + this.in + ")";
        }

        void reset() {
            this.state = State.INITIAL;
        }

        private static enum State {
            INITIAL,
            POSITIONED,
            UNPOSITIONED;

        }
    }

    public static class AssertingTerms
    extends FilterLeafReader.FilterTerms {
        public AssertingTerms(Terms in) {
            super(in);
        }

        public TermsEnum intersect(CompiledAutomaton automaton, BytesRef bytes) throws IOException {
            TermsEnum termsEnum = this.in.intersect(automaton, bytes);
            assert (termsEnum != null);
            assert (bytes == null || bytes.isValid());
            return new AssertingTermsEnum(termsEnum, this.hasFreqs());
        }

        public BytesRef getMin() throws IOException {
            BytesRef v = this.in.getMin();
            assert (v == null || v.isValid());
            return v;
        }

        public BytesRef getMax() throws IOException {
            BytesRef v = this.in.getMax();
            assert (v == null || v.isValid());
            return v;
        }

        public int getDocCount() throws IOException {
            int docCount = this.in.getDocCount();
            assert (docCount > 0);
            return docCount;
        }

        public long getSumDocFreq() throws IOException {
            long sumDf = this.in.getSumDocFreq();
            assert (sumDf >= (long)this.getDocCount());
            return sumDf;
        }

        public long getSumTotalTermFreq() throws IOException {
            long sumTtf = this.in.getSumTotalTermFreq();
            if (!this.hasFreqs()) assert (sumTtf == this.in.getSumDocFreq());
            assert (sumTtf >= this.getSumDocFreq());
            return sumTtf;
        }

        public TermsEnum iterator() throws IOException {
            TermsEnum termsEnum = super.iterator();
            assert (termsEnum != null);
            return new AssertingTermsEnum(termsEnum, this.hasFreqs());
        }

        public String toString() {
            return "AssertingTerms(" + this.in + ")";
        }
    }

    public static class AssertingFields
    extends FilterLeafReader.FilterFields {
        public AssertingFields(Fields in) {
            super(in);
        }

        public Iterator<String> iterator() {
            Iterator iterator = super.iterator();
            assert (iterator != null);
            return iterator;
        }

        public Terms terms(String field) throws IOException {
            Terms terms = super.terms(field);
            return terms == null ? null : new AssertingTerms(terms);
        }
    }
}

