/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.registry;

import com.intellij.openapi.util.registry.RegistryKeyDescriptor;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.reference.SoftReference;
import com.intellij.util.ConcurrencyUtil;
import java.awt.Color;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.PropertyKey;

public class Registry {
    private static Reference<ResourceBundle> ourBundle;
    @NonNls
    public static final String REGISTRY_BUNDLE = "misc.registry";
    private final Map<String, String> myUserProperties = new LinkedHashMap<String, String>();
    private final ConcurrentMap<String, RegistryValue> myValues = new ConcurrentHashMap<String, RegistryValue>();
    private final Map<String, RegistryKeyDescriptor> myContributedKeys = new HashMap<String, RegistryKeyDescriptor>();
    private static final Registry ourInstance;

    @NotNull
    public static RegistryValue get(@PropertyKey(resourceBundle="misc.registry") @NotNull String key) {
        if (key == null) {
            Registry.$$$reportNull$$$0(0);
        }
        Registry registry = Registry.getInstance();
        RegistryValue value = (RegistryValue)registry.myValues.get(key);
        if (value == null) {
            value = ConcurrencyUtil.cacheOrGet(registry.myValues, key, new RegistryValue(registry, key, registry.myContributedKeys.get(key)));
        }
        RegistryValue registryValue = value;
        if (registryValue == null) {
            Registry.$$$reportNull$$$0(1);
        }
        return registryValue;
    }

    public static boolean is(@PropertyKey(resourceBundle="misc.registry") @NotNull String key) throws MissingResourceException {
        if (key == null) {
            Registry.$$$reportNull$$$0(2);
        }
        return Registry.get(key).asBoolean();
    }

    public static boolean is(@PropertyKey(resourceBundle="misc.registry") @NotNull String key, boolean defaultValue) {
        if (key == null) {
            Registry.$$$reportNull$$$0(3);
        }
        try {
            return Registry.get(key).asBoolean();
        }
        catch (MissingResourceException ex) {
            return defaultValue;
        }
    }

    public static int intValue(@PropertyKey(resourceBundle="misc.registry") @NotNull String key) throws MissingResourceException {
        if (key == null) {
            Registry.$$$reportNull$$$0(4);
        }
        return Registry.get(key).asInteger();
    }

    public static int intValue(@PropertyKey(resourceBundle="misc.registry") @NotNull String key, int defaultValue) {
        if (key == null) {
            Registry.$$$reportNull$$$0(5);
        }
        try {
            return Registry.get(key).asInteger();
        }
        catch (MissingResourceException ex) {
            return defaultValue;
        }
    }

    public static double doubleValue(@PropertyKey(resourceBundle="misc.registry") @NotNull String key) throws MissingResourceException {
        if (key == null) {
            Registry.$$$reportNull$$$0(6);
        }
        return Registry.get(key).asDouble();
    }

    @NotNull
    public static String stringValue(@PropertyKey(resourceBundle="misc.registry") @NotNull String key) throws MissingResourceException {
        if (key == null) {
            Registry.$$$reportNull$$$0(7);
        }
        String string = Registry.get(key).asString();
        if (string == null) {
            Registry.$$$reportNull$$$0(8);
        }
        return string;
    }

    public static Color getColor(@PropertyKey(resourceBundle="misc.registry") @NotNull String key, Color defaultValue) throws MissingResourceException {
        if (key == null) {
            Registry.$$$reportNull$$$0(9);
        }
        return Registry.get(key).asColor(defaultValue);
    }

    @NotNull
    static ResourceBundle getBundle() {
        ResourceBundle bundle = SoftReference.dereference(ourBundle);
        if (bundle == null) {
            bundle = ResourceBundle.getBundle(REGISTRY_BUNDLE);
            ourBundle = new java.lang.ref.SoftReference<ResourceBundle>(bundle);
        }
        ResourceBundle resourceBundle = bundle;
        if (resourceBundle == null) {
            Registry.$$$reportNull$$$0(10);
        }
        return resourceBundle;
    }

    public String getBundleValue(@NotNull String key, boolean mustExist) throws MissingResourceException {
        if (key == null) {
            Registry.$$$reportNull$$$0(11);
        }
        if (this.myContributedKeys.containsKey(key)) {
            return this.myContributedKeys.get(key).getDefaultValue();
        }
        try {
            return Registry.getBundle().getString(key);
        }
        catch (MissingResourceException e) {
            if (mustExist) {
                throw e;
            }
            return null;
        }
    }

    @NotNull
    public static Registry getInstance() {
        Registry registry = ourInstance;
        if (registry == null) {
            Registry.$$$reportNull$$$0(12);
        }
        return registry;
    }

    @NotNull
    public Element getState() {
        Element state = new Element("registry");
        for (String eachKey : this.myUserProperties.keySet()) {
            Element entry = new Element("entry");
            entry.setAttribute("key", eachKey);
            entry.setAttribute("value", this.myUserProperties.get(eachKey));
            state.addContent(entry);
        }
        Element element = state;
        if (element == null) {
            Registry.$$$reportNull$$$0(13);
        }
        return element;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            Registry.$$$reportNull$$$0(14);
        }
        this.myUserProperties.clear();
        for (Element eachEntry : state.getChildren("entry")) {
            RegistryValue registryValue;
            String key = eachEntry.getAttributeValue("key");
            String value = eachEntry.getAttributeValue("value");
            if (key == null || value == null || !(registryValue = Registry.get(key)).isChangedFromDefault(value)) continue;
            this.myUserProperties.put(key, value);
            registryValue.resetCache();
        }
    }

    @NotNull
    Map<String, String> getUserProperties() {
        Map<String, String> map = this.myUserProperties;
        if (map == null) {
            Registry.$$$reportNull$$$0(15);
        }
        return map;
    }

    @NotNull
    public static List<RegistryValue> getAll() {
        ResourceBundle bundle = Registry.getBundle();
        Enumeration<String> keys = bundle.getKeys();
        ArrayList<RegistryValue> result = new ArrayList<RegistryValue>();
        Map<String, RegistryKeyDescriptor> contributedKeys = Registry.getInstance().myContributedKeys;
        while (keys.hasMoreElements()) {
            String each = keys.nextElement();
            if (each.endsWith(".description") || each.endsWith(".restartRequired") || contributedKeys.containsKey(each)) continue;
            result.add(Registry.get(each));
        }
        for (String key : contributedKeys.keySet()) {
            result.add(Registry.get(key));
        }
        ArrayList<RegistryValue> arrayList = result;
        if (arrayList == null) {
            Registry.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    void restoreDefaults() {
        HashMap<String, String> old = new HashMap<String, String>();
        old.putAll(this.myUserProperties);
        for (String each : old.keySet()) {
            try {
                Registry.get(each).resetToDefault();
            }
            catch (MissingResourceException e) {
                this.myValues.remove(each);
            }
        }
    }

    boolean isInDefaultState() {
        return this.myUserProperties.isEmpty();
    }

    boolean isRestartNeeded() {
        return Registry.isRestartNeeded(this.myUserProperties);
    }

    private static boolean isRestartNeeded(@NotNull Map<String, String> map) {
        if (map == null) {
            Registry.$$$reportNull$$$0(17);
        }
        for (String s : map.keySet()) {
            RegistryValue eachValue = Registry.get(s);
            if (!eachValue.isRestartRequired() || !eachValue.isChangedSinceAppStart()) continue;
            return true;
        }
        return false;
    }

    public static void addKey(@NotNull String key, @NotNull String description, @NotNull String defaultValue, boolean restartRequired) {
        if (key == null) {
            Registry.$$$reportNull$$$0(18);
        }
        if (description == null) {
            Registry.$$$reportNull$$$0(19);
        }
        if (defaultValue == null) {
            Registry.$$$reportNull$$$0(20);
        }
        Registry.getInstance().myContributedKeys.put(key, new RegistryKeyDescriptor(key, description, defaultValue, restartRequired));
    }

    public static void addKey(@NotNull String key, @NotNull String description, int defaultValue, boolean restartRequired) {
        if (key == null) {
            Registry.$$$reportNull$$$0(21);
        }
        if (description == null) {
            Registry.$$$reportNull$$$0(22);
        }
        Registry.addKey(key, description, Integer.toString(defaultValue), restartRequired);
    }

    public static void addKey(@NotNull String key, @NotNull String description, boolean defaultValue, boolean restartRequired) {
        if (key == null) {
            Registry.$$$reportNull$$$0(23);
        }
        if (description == null) {
            Registry.$$$reportNull$$$0(24);
        }
        Registry.addKey(key, description, Boolean.toString(defaultValue), restartRequired);
    }

    static {
        ourInstance = new Registry();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/registry/Registry";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 19: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/registry/Registry";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "stringValue";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundle";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserProperties";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getAll";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 1: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "is";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "intValue";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doubleValue";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "stringValue";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getColor";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getBundleValue";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isRestartNeeded";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addKey";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

