/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.flavors;

import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PatternUtil;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import icons.PythonIcons;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyPySdkFlavor
extends PythonSdkFlavor {
    public static PyPySdkFlavor INSTANCE = new PyPySdkFlavor();
    private static final Pattern VERSION_RE = Pattern.compile("\\[(PyPy \\S+).*\\]");
    private static final Pattern PYTHON_VERSION_RE = Pattern.compile("(Python \\S+).*");
    private static final Pattern VERSION_STRING_RE = Pattern.compile("PyPy (\\S+)( \\[Python (\\S+)\\])?");

    private PyPySdkFlavor() {
    }

    @Override
    public boolean isValidSdkPath(@NotNull File file) {
        if (file == null) {
            PyPySdkFlavor.$$$reportNull$$$0(0);
        }
        return FileUtil.getNameWithoutExtension((File)file).toLowerCase().startsWith("pypy");
    }

    @Override
    @Nullable
    public String getVersionStringFromOutput(@NotNull String output) {
        if (output == null) {
            PyPySdkFlavor.$$$reportNull$$$0(1);
        }
        List<String> lines = Arrays.asList(StringUtil.splitByLines((String)output));
        String version = PatternUtil.getFirstMatch(lines, (Pattern)VERSION_RE);
        String pythonVersion = PatternUtil.getFirstMatch(lines, (Pattern)PYTHON_VERSION_RE);
        if (version != null) {
            StringBuilder builder = new StringBuilder();
            builder.append(version);
            if (pythonVersion != null) {
                builder.append(" [");
                builder.append(pythonVersion);
                builder.append("]");
            }
            return builder.toString();
        }
        return null;
    }

    @Override
    public String getVersionOption() {
        return "--version";
    }

    @Override
    @NotNull
    public String getName() {
        if ("PyPy" == null) {
            PyPySdkFlavor.$$$reportNull$$$0(2);
        }
        return "PyPy";
    }

    @Override
    @NotNull
    public LanguageLevel getLanguageLevel(@NotNull Sdk sdk) {
        Matcher matcher;
        String versionString;
        if (sdk == null) {
            PyPySdkFlavor.$$$reportNull$$$0(3);
        }
        if ((versionString = sdk.getVersionString()) != null && (matcher = VERSION_STRING_RE.matcher(versionString)).matches()) {
            String version = matcher.group(1);
            String pythonVersion = matcher.group(3);
            if (pythonVersion != null) {
                LanguageLevel languageLevel = LanguageLevel.fromPythonVersion(pythonVersion);
                if (languageLevel == null) {
                    PyPySdkFlavor.$$$reportNull$$$0(4);
                }
                return languageLevel;
            }
            if (version != null) {
                LanguageLevel languageLevel = LanguageLevel.fromPythonVersion(PyPySdkFlavor.getPythonVersion(version));
                if (languageLevel == null) {
                    PyPySdkFlavor.$$$reportNull$$$0(5);
                }
                return languageLevel;
            }
        }
        LanguageLevel languageLevel = LanguageLevel.getDefault();
        if (languageLevel == null) {
            PyPySdkFlavor.$$$reportNull$$$0(6);
        }
        return languageLevel;
    }

    private static String getPythonVersion(@NotNull String pypyVersion) {
        if (pypyVersion == null) {
            PyPySdkFlavor.$$$reportNull$$$0(7);
        }
        String DEFAULT = "2.4";
        String LATEST = "2.7";
        List vs = StringUtil.split((String)pypyVersion, (String)".");
        try {
            if (vs.size() >= 2) {
                int major = Integer.parseInt((String)vs.get(0));
                int minor = Integer.parseInt((String)vs.get(1));
                if (major > 1) {
                    return "2.7";
                }
                if (major == 1) {
                    if (minor >= 5) {
                        return "2.7";
                    }
                    if (minor >= 4) {
                        return "2.5";
                    }
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return "2.4";
    }

    @Override
    public Icon getIcon() {
        return PythonIcons.Python.Pypy;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/sdk/flavors/PyPySdkFlavor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pypyVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/sdk/flavors/PyPySdkFlavor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isValidSdkPath";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getVersionStringFromOutput";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageLevel";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPythonVersion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

