/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl.references;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallSiteExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyPrefixExpression;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.impl.references.PyReferenceImpl;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyOperatorReference
extends PyReferenceImpl {
    public PyOperatorReference(PyQualifiedExpression element, @NotNull PyResolveContext context) {
        if (context == null) {
            PyOperatorReference.$$$reportNull$$$0(0);
        }
        super(element, context);
    }

    @Override
    @NotNull
    protected List<RatedResolveResult> resolveInner() {
        if (this.myElement instanceof PyBinaryExpression) {
            PyBinaryExpression expr = (PyBinaryExpression)this.myElement;
            String name = expr.getReferencedName();
            if ("__contains__".equals(name)) {
                List<RatedResolveResult> list = this.resolveMember(expr.getRightExpression(), name);
                if (list == null) {
                    PyOperatorReference.$$$reportNull$$$0(1);
                }
                return list;
            }
            List<RatedResolveResult> list = this.resolveLeftAndRightOperators(expr, name);
            if (list == null) {
                PyOperatorReference.$$$reportNull$$$0(2);
            }
            return list;
        }
        if (this.myElement instanceof PySubscriptionExpression) {
            PySubscriptionExpression expr = (PySubscriptionExpression)this.myElement;
            List<RatedResolveResult> list = this.resolveMember(expr.getOperand(), expr.getReferencedName());
            if (list == null) {
                PyOperatorReference.$$$reportNull$$$0(3);
            }
            return list;
        }
        if (this.myElement instanceof PyPrefixExpression) {
            PyPrefixExpression expr = (PyPrefixExpression)this.myElement;
            List<RatedResolveResult> list = this.resolveMember(expr.getOperand(), expr.getReferencedName());
            if (list == null) {
                PyOperatorReference.$$$reportNull$$$0(4);
            }
            return list;
        }
        List<RatedResolveResult> list = Collections.emptyList();
        if (list == null) {
            PyOperatorReference.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Override
    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            PyOperatorReference.$$$reportNull$$$0(6);
        }
        if (element instanceof PyParameter || element instanceof PyTargetExpression) {
            return false;
        }
        return super.isReferenceTo(element);
    }

    public String toString() {
        return "PyOperatorReference(" + this.myElement + "," + this.myContext + ")";
    }

    public String getReadableOperatorName() {
        String name = this.myElement.getReferencedName();
        if (PyNames.SUBSCRIPTION_OPERATORS.contains((Object)name)) {
            return "[]";
        }
        return this.getRangeInElement().substring(this.myElement.getText());
    }

    @Nullable
    public PyExpression getReceiver() {
        if (this.myElement instanceof PyCallSiteExpression) {
            return ((PyCallSiteExpression)((Object)this.myElement)).getReceiver(null);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private List<RatedResolveResult> resolveLeftAndRightOperators(@NotNull PyBinaryExpression expr, @Nullable String name) {
        if (expr == null) {
            PyOperatorReference.$$$reportNull$$$0(7);
        }
        ArrayList<RatedResolveResult> result = new ArrayList<RatedResolveResult>();
        TypeEvalContext typeEvalContext = this.myContext.getTypeEvalContext();
        typeEvalContext.trace("Trying to resolve left operator", new Object[0]);
        typeEvalContext.traceIndent();
        try {
            result.addAll(this.resolveMember(expr.getReceiver(null), name));
        }
        finally {
            typeEvalContext.traceUnindent();
        }
        typeEvalContext.trace("Trying to resolve right operator", new Object[0]);
        typeEvalContext.traceIndent();
        try {
            result.addAll(this.resolveMember(expr.getRightExpression(), PyNames.leftToRightOperatorName(name)));
        }
        finally {
            typeEvalContext.traceUnindent();
        }
        ArrayList<RatedResolveResult> arrayList = result;
        if (arrayList == null) {
            PyOperatorReference.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @NotNull
    private List<RatedResolveResult> resolveMember(@Nullable PyExpression object, @Nullable String name) {
        ArrayList<RatedResolveResult> results = new ArrayList<RatedResolveResult>();
        if (object != null && name != null) {
            TypeEvalContext typeEvalContext = this.myContext.getTypeEvalContext();
            PyType type = typeEvalContext.getType(object);
            typeEvalContext.trace("Side text is %s, type is %s", object.getText(), type);
            if (type != null) {
                List<? extends RatedResolveResult> res;
                List<? extends RatedResolveResult> list = res = type instanceof PyClassLikeType && ((PyClassLikeType)type).isDefinition() ? this.resolveDefinitionMember((PyClassLikeType)type, object, name) : type.resolveMember(name, object, AccessDirection.of(this.myElement), this.myContext);
                if (!ContainerUtil.isEmpty(res)) {
                    results.addAll(res);
                } else if (typeEvalContext.tracing()) {
                    VirtualFile vFile = null;
                    if (type instanceof PyClassType) {
                        PyClass pyClass = ((PyClassType)type).getPyClass();
                        vFile = pyClass.getContainingFile().getVirtualFile();
                    }
                    type.resolveMember(name, object, AccessDirection.of(this.myElement), this.myContext);
                    typeEvalContext.trace("Could not resolve member %s in type %s from file %s", name, type, vFile);
                }
            }
        }
        ArrayList<RatedResolveResult> arrayList = results;
        if (arrayList == null) {
            PyOperatorReference.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @Nullable
    private List<? extends RatedResolveResult> resolveDefinitionMember(@NotNull PyClassLikeType classLikeType, @NotNull PyExpression object, @NotNull String name) {
        List<? extends RatedResolveResult> results;
        PyClassLikeType metaClassType;
        if (classLikeType == null) {
            PyOperatorReference.$$$reportNull$$$0(10);
        }
        if (object == null) {
            PyOperatorReference.$$$reportNull$$$0(11);
        }
        if (name == null) {
            PyOperatorReference.$$$reportNull$$$0(12);
        }
        if ((metaClassType = classLikeType.getMetaClassType(this.myContext.getTypeEvalContext(), true)) != null && !ContainerUtil.isEmpty(results = metaClassType.resolveMember(name, object, AccessDirection.of(this.myElement), this.myContext))) {
            return results;
        }
        return name.equals("__getitem__") && LanguageLevel.forElement((PsiElement)object).isAtLeast(LanguageLevel.PYTHON37) ? classLikeType.resolveMember("__class_getitem__", object, AccessDirection.of(this.myElement), this.myContext) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/references/PyOperatorReference";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classLikeType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/references/PyOperatorReference";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveInner";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveLeftAndRightOperators";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveMember";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resolveLeftAndRightOperators";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "resolveDefinitionMember";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

