/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import org.jetbrains.annotations.NotNull;

public class CompatibilityPrintCallQuickFix
implements LocalQuickFix {
    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("QFIX.statement.effect", new Object[0]);
        if (string == null) {
            CompatibilityPrintCallQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        if (project == null) {
            CompatibilityPrintCallQuickFix.$$$reportNull$$$0(1);
        }
        if (descriptor2 == null) {
            CompatibilityPrintCallQuickFix.$$$reportNull$$$0(2);
        }
        PsiElement expression = descriptor2.getPsiElement();
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
        CompatibilityPrintCallQuickFix.replacePrint(expression, elementGenerator);
    }

    private static void replacePrint(PsiElement expression, PyElementGenerator elementGenerator) {
        StringBuilder stringBuilder = new StringBuilder("print(");
        PyFile file = (PyFile)expression.getContainingFile();
        Object[] target = (PyExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)expression, PyExpression.class);
        if (target != null) {
            stringBuilder.append(StringUtil.join((Object[])target, o -> o.getText(), (String)", "));
        }
        stringBuilder.append(")");
        expression.replace((PsiElement)elementGenerator.createFromText(LanguageLevel.forElement(expression), PyElement.class, stringBuilder.toString()));
        PyFromImportStatement statement = elementGenerator.createFromText(LanguageLevel.forElement(expression), PyFromImportStatement.class, "from __future__ import print_function");
        file.addBefore((PsiElement)statement, (PsiElement)file.getStatements().get(0));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/CompatibilityPrintCallQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/CompatibilityPrintCallQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

