/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.codeInsight.PyCodeInsightSettings;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class PyMethodNameTypedHandler
extends TypedHandlerDelegate {
    private static final Pattern DEF_THEN_IDENTIFIER = Pattern.compile(".*\\bdef\\s+\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*");

    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char character, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull FileType fileType) {
        if (project == null) {
            PyMethodNameTypedHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            PyMethodNameTypedHandler.$$$reportNull$$$0(1);
        }
        if (file == null) {
            PyMethodNameTypedHandler.$$$reportNull$$$0(2);
        }
        if (fileType == null) {
            PyMethodNameTypedHandler.$$$reportNull$$$0(3);
        }
        if (DumbService.isDumb((Project)project) || !(fileType instanceof PythonFileType)) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                PyMethodNameTypedHandler.$$$reportNull$$$0(4);
            }
            return result;
        }
        if (character == '(') {
            PyFunction func;
            PyUtil.MethodFlags flags;
            PsiElement maybeFunc;
            ASTNode defNode;
            PsiElement maybeDef;
            if (!PyCodeInsightSettings.getInstance().INSERT_SELF_FOR_METHODS) {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                if (result == null) {
                    PyMethodNameTypedHandler.$$$reportNull$$$0(5);
                }
                return result;
            }
            Document document = editor.getDocument();
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
            int offset = editor.getCaretModel().getOffset();
            int lineNumber = document.getLineNumber(offset);
            String linePrefix = document.getText(TextRange.create((int)document.getLineStartOffset(lineNumber), (int)offset));
            if (!DEF_THEN_IDENTIFIER.matcher(linePrefix).matches()) {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                if (result == null) {
                    PyMethodNameTypedHandler.$$$reportNull$$$0(6);
                }
                return result;
            }
            documentManager.commitDocument(document);
            PsiElement token = file.findElementAt(offset - 1);
            if (token == null) {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                if (result == null) {
                    PyMethodNameTypedHandler.$$$reportNull$$$0(7);
                }
                return result;
            }
            ASTNode tokenNode = token.getNode();
            if (tokenNode != null && tokenNode.getElementType() == PyTokenTypes.IDENTIFIER && (maybeDef = PyPsiUtils.getPrevNonCommentSibling(token.getPrevSibling(), false)) != null && (defNode = maybeDef.getNode()) != null && defNode.getElementType() == PyTokenTypes.DEF_KEYWORD && (maybeFunc = token.getParent()) instanceof PyFunction && (flags = PyUtil.MethodFlags.of(func = (PyFunction)maybeFunc)) != null) {
                String paramName = flags.isClassMethod() || flags.isMetaclassMethod() ? "cls" : "self";
                boolean isNew = "__new__".equals(func.getName());
                if (flags.isMetaclassMethod() && isNew) {
                    paramName = "typ";
                } else if (flags.isClassMethod() || isNew) {
                    paramName = "cls";
                } else if (flags.isStaticMethod()) {
                    paramName = "";
                }
                CommonCodeStyleSettings settings = CodeStyle.getLanguageSettings((PsiFile)file, (Language)PythonLanguage.getInstance());
                StringBuilder textToType = new StringBuilder();
                textToType.append("(");
                if (!paramName.isEmpty()) {
                    if (settings.SPACE_WITHIN_METHOD_PARENTHESES) {
                        textToType.append(" ");
                    }
                    textToType.append(paramName);
                    if (settings.SPACE_WITHIN_METHOD_PARENTHESES) {
                        textToType.append(" ");
                    }
                } else if (settings.SPACE_WITHIN_EMPTY_METHOD_PARENTHESES) {
                    textToType.append(" ");
                }
                textToType.append(")");
                int caretOffset = editor.getCaretModel().getOffset();
                CharSequence chars = editor.getDocument().getCharsSequence();
                if (caretOffset == chars.length() || chars.charAt(caretOffset) != ':') {
                    textToType.append(':');
                }
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)textToType.toString(), (boolean)true, (int)(1 + paramName.length()));
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                if (result == null) {
                    PyMethodNameTypedHandler.$$$reportNull$$$0(8);
                }
                return result;
            }
        }
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
        if (result == null) {
            PyMethodNameTypedHandler.$$$reportNull$$$0(9);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/PyMethodNameTypedHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/PyMethodNameTypedHandler";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeCharTyped";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeCharTyped";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

