/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.navigation.History;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogListener;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.VcsLogImpl;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.highlighters.VcsLogHighlighterFactory;
import com.intellij.vcs.log.ui.table.GraphTableModel;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.VisiblePack;
import com.intellij.vcs.log.visible.VisiblePackChangeListener;
import com.intellij.vcs.log.visible.VisiblePackRefresher;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractVcsLogUi
implements VcsLogUi,
Disposable {
    private static final Logger LOG = Logger.getInstance(AbstractVcsLogUi.class);
    public static final ExtensionPointName<VcsLogHighlighterFactory> LOG_HIGHLIGHTER_FACTORY_EP = ExtensionPointName.create((String)"com.intellij.logHighlighterFactory");
    @NotNull
    private final String myId;
    @NotNull
    protected final Project myProject;
    @NotNull
    protected final VcsLogData myLogData;
    @NotNull
    protected final VcsLogColorManager myColorManager;
    @NotNull
    protected final VcsLog myLog;
    @NotNull
    protected final VisiblePackRefresher myRefresher;
    @NotNull
    protected final Collection<VcsLogListener> myLogListeners;
    @NotNull
    protected final VisiblePackChangeListener myVisiblePackChangeListener;
    @NotNull
    protected VisiblePack myVisiblePack;

    public AbstractVcsLogUi(@NotNull String id, @NotNull VcsLogData logData, @NotNull VcsLogColorManager manager, @NotNull VisiblePackRefresher refresher) {
        if (id == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(0);
        }
        if (logData == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(2);
        }
        if (refresher == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(3);
        }
        this.myLogListeners = ContainerUtil.newArrayList();
        this.myId = id;
        this.myProject = logData.getProject();
        this.myLogData = logData;
        this.myRefresher = refresher;
        this.myColorManager = manager;
        Disposer.register((Disposable)this, (Disposable)this.myRefresher);
        this.myLog = new VcsLogImpl(logData, this);
        this.myVisiblePack = VisiblePack.EMPTY;
        this.myVisiblePackChangeListener = visiblePack -> UIUtil.invokeLaterIfNeeded(() -> {
            if (!Disposer.isDisposed((Disposable)this)) {
                this.setVisiblePack(visiblePack);
            }
        });
        this.myRefresher.addVisiblePackChangeListener(this.myVisiblePackChangeListener);
    }

    @NotNull
    public String getId() {
        String string = this.myId;
        if (string == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void requestFocus() {
        VcsLogGraphTable graphTable = this.getTable();
        if (graphTable.getRowCount() > 0) {
            IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)((Object)graphTable), true).doWhenProcessed(() -> graphTable.setRowSelectionInterval(0, 0));
        }
    }

    public void setVisiblePack(@NotNull VisiblePack pack) {
        if (pack == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(5);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        boolean permGraphChanged = this.myVisiblePack.getDataPack() != pack.getDataPack();
        this.myVisiblePack = pack;
        this.onVisiblePackUpdated(permGraphChanged);
        this.fireFilterChangeEvent(this.myVisiblePack, permGraphChanged);
        this.getTable().repaint();
    }

    protected abstract void onVisiblePackUpdated(boolean var1);

    @NotNull
    public abstract VcsLogGraphTable getTable();

    @NotNull
    public abstract Component getMainComponent();

    @NotNull
    public abstract VcsLogUiProperties getProperties();

    @Nullable
    public abstract History getNavigationHistory();

    @Nullable
    public abstract String getHelpId();

    @NotNull
    public VisiblePackRefresher getRefresher() {
        VisiblePackRefresher visiblePackRefresher = this.myRefresher;
        if (visiblePackRefresher == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(6);
        }
        return visiblePackRefresher;
    }

    @NotNull
    public VcsLogColorManager getColorManager() {
        VcsLogColorManager vcsLogColorManager = this.myColorManager;
        if (vcsLogColorManager == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(7);
        }
        return vcsLogColorManager;
    }

    @NotNull
    public VcsLog getVcsLog() {
        VcsLog vcsLog = this.myLog;
        if (vcsLog == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(8);
        }
        return vcsLog;
    }

    @NotNull
    public VcsLogData getLogData() {
        VcsLogData vcsLogData = this.myLogData;
        if (vcsLogData == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(9);
        }
        return vcsLogData;
    }

    public void requestMore(@NotNull Runnable onLoaded) {
        if (onLoaded == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(10);
        }
        this.myRefresher.moreCommitsNeeded(onLoaded);
        this.getTable().setPaintBusy(true);
    }

    @NotNull
    public VisiblePack getDataPack() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        VisiblePack visiblePack = this.myVisiblePack;
        if (visiblePack == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(11);
        }
        return visiblePack;
    }

    public void jumpToRow(int row2) {
        this.jumpTo(row2, (model, r) -> {
            if (model.getRowCount() <= r) {
                return -1;
            }
            return r;
        }, (SettableFuture<Boolean>)SettableFuture.create());
    }

    @NotNull
    public ListenableFuture<Boolean> jumpToCommit(@NotNull Hash commitHash, @NotNull VirtualFile root) {
        if (commitHash == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(12);
        }
        if (root == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(13);
        }
        SettableFuture future2 = SettableFuture.create();
        this.jumpToCommit(commitHash, root, (SettableFuture<Boolean>)future2);
        SettableFuture settableFuture = future2;
        if (settableFuture == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(14);
        }
        return settableFuture;
    }

    public void jumpToCommit(@NotNull Hash commitHash, @NotNull VirtualFile root, @NotNull SettableFuture<Boolean> future2) {
        if (commitHash == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(15);
        }
        if (root == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(16);
        }
        if (future2 == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(17);
        }
        this.jumpTo(commitHash, (model, hash) -> {
            if (root == null) {
                AbstractVcsLogUi.$$$reportNull$$$0(46);
            }
            return model.getRowOfCommit((Hash)hash, root);
        }, future2);
    }

    public void jumpToCommitByPartOfHash(@NotNull String commitHash, @NotNull SettableFuture<Boolean> future2) {
        if (commitHash == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(18);
        }
        if (future2 == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(19);
        }
        this.jumpTo(commitHash, GraphTableModel::getRowOfCommitByPartOfHash, future2);
    }

    protected <T> void jumpTo(@NotNull T commitId, @NotNull PairFunction<GraphTableModel, T, Integer> rowGetter, @NotNull SettableFuture<Boolean> future2) {
        if (commitId == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(20);
        }
        if (rowGetter == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(21);
        }
        if (future2 == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(22);
        }
        if (future2.isCancelled()) {
            return;
        }
        GraphTableModel model = this.getTable().getModel();
        int result2 = (Integer)rowGetter.fun((Object)model, commitId);
        if (result2 >= 0) {
            this.getTable().jumpToRow(result2);
            future2.set((Object)true);
        } else if (model.canRequestMore()) {
            model.requestToLoadMore(() -> {
                if (commitId == null) {
                    AbstractVcsLogUi.$$$reportNull$$$0(43);
                }
                if (rowGetter == null) {
                    AbstractVcsLogUi.$$$reportNull$$$0(44);
                }
                if (future2 == null) {
                    AbstractVcsLogUi.$$$reportNull$$$0(45);
                }
                this.jumpTo(commitId, rowGetter, future2);
            });
        } else if (!this.myVisiblePack.isFull()) {
            this.invokeOnChange(() -> {
                if (commitId == null) {
                    AbstractVcsLogUi.$$$reportNull$$$0(40);
                }
                if (rowGetter == null) {
                    AbstractVcsLogUi.$$$reportNull$$$0(41);
                }
                if (future2 == null) {
                    AbstractVcsLogUi.$$$reportNull$$$0(42);
                }
                this.jumpTo(commitId, rowGetter, future2);
            });
        } else {
            this.handleCommitNotFound(commitId, result2 == -2, rowGetter);
            future2.set((Object)false);
        }
    }

    protected <T> void handleCommitNotFound(@NotNull T commitId, boolean commitExists, @NotNull PairFunction<GraphTableModel, T, Integer> rowGetter) {
        if (commitId == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(23);
        }
        if (rowGetter == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(24);
        }
        String message = AbstractVcsLogUi.getCommitNotFoundMessage(commitId, commitExists);
        VcsBalloonProblemNotifier.showOverChangesView(this.myProject, message, MessageType.WARNING, new NamedRunnable[0]);
    }

    @NotNull
    protected static <T> String getCommitNotFoundMessage(@NotNull T commitId, boolean exists) {
        if (commitId == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(25);
        }
        String string = exists ? "Commit " + AbstractVcsLogUi.getCommitPresentation(commitId) + " doesn't match the filters" : "Commit " + AbstractVcsLogUi.getCommitPresentation(commitId) + " not found";
        if (string == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(26);
        }
        return string;
    }

    @NotNull
    protected static <T> String getCommitPresentation(@NotNull T commitId) {
        if (commitId == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(27);
        }
        if (commitId instanceof Hash) {
            String string = ((Hash)commitId).toShortString();
            if (string == null) {
                AbstractVcsLogUi.$$$reportNull$$$0(28);
            }
            return string;
        }
        if (commitId instanceof String) {
            String string = VcsLogUtil.getShortHash((String)commitId);
            if (string == null) {
                AbstractVcsLogUi.$$$reportNull$$$0(29);
            }
            return string;
        }
        String string = commitId.toString();
        if (string == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(30);
        }
        return string;
    }

    protected void showWarningWithLink(@NotNull String mainText, @NotNull String linkText, final @NotNull Runnable onClick2) {
        if (mainText == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(31);
        }
        if (linkText == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(32);
        }
        if (onClick2 == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(33);
        }
        VcsBalloonProblemNotifier.showOverChangesView(this.myProject, mainText, MessageType.WARNING, new NamedRunnable(linkText){

            public void run() {
                onClick2.run();
            }
        });
    }

    public void addLogListener(@NotNull VcsLogListener listener2) {
        if (listener2 == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(34);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myLogListeners.add(listener2);
    }

    public void removeLogListener(@NotNull VcsLogListener listener2) {
        if (listener2 == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(35);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myLogListeners.remove(listener2);
    }

    protected void fireFilterChangeEvent(@NotNull VisiblePack visiblePack, boolean refresh2) {
        if (visiblePack == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(36);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ArrayList<VcsLogListener> logListeners = new ArrayList<VcsLogListener>(this.myLogListeners);
        for (VcsLogListener listener2 : logListeners) {
            listener2.onChange((VcsLogDataPack)visiblePack, refresh2);
        }
    }

    public void invokeOnChange(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(37);
        }
        this.invokeOnChange(runnable2, (Condition<VcsLogDataPack>)Conditions.alwaysTrue());
    }

    protected void invokeOnChange(final @NotNull Runnable runnable2, final @NotNull Condition<VcsLogDataPack> condition) {
        if (runnable2 == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(38);
        }
        if (condition == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(39);
        }
        this.addLogListener(new VcsLogListener(){

            public void onChange(@NotNull VcsLogDataPack dataPack, boolean refreshHappened) {
                if (dataPack == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (condition.value((Object)dataPack)) {
                    runnable2.run();
                    AbstractVcsLogUi.this.removeLogListener(this);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataPack", "com/intellij/vcs/log/ui/AbstractVcsLogUi$2", "onChange"));
            }
        });
    }

    public void dispose() {
        LOG.assertTrue(ApplicationManager.getApplication().isDispatchThread());
        LOG.debug("Disposing VcsLogUi '" + this.myId + "'");
        this.myRefresher.removeVisiblePackChangeListener(this.myVisiblePackChangeListener);
        this.getTable().removeAllHighlighters();
        this.myVisiblePack = VisiblePack.EMPTY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 26: 
            case 28: 
            case 29: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 26: 
            case 28: 
            case 29: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logData";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refresher";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 26: 
            case 28: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/AbstractVcsLogUi";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pack";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onLoaded";
                break;
            }
            case 12: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitHash";
                break;
            }
            case 13: 
            case 16: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 17: 
            case 19: 
            case 22: 
            case 42: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "future";
                break;
            }
            case 20: 
            case 23: 
            case 25: 
            case 27: 
            case 40: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitId";
                break;
            }
            case 21: 
            case 24: 
            case 41: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowGetter";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainText";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkText";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onClick";
                break;
            }
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visiblePack";
                break;
            }
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/AbstractVcsLogUi";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefresher";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorManager";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcsLog";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogData";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataPack";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "jumpToCommit";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitNotFoundMessage";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 26: 
            case 28: 
            case 29: 
            case 30: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setVisiblePack";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "requestMore";
                break;
            }
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "jumpToCommit";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "jumpToCommitByPartOfHash";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "jumpTo";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "handleCommitNotFound";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getCommitNotFoundMessage";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getCommitPresentation";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "showWarningWithLink";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "addLogListener";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "removeLogListener";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "fireFilterChangeEvent";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "invokeOnChange";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "lambda$jumpTo$6";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "lambda$jumpTo$5";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "lambda$jumpToCommit$4";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 26: 
            case 28: 
            case 29: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

