/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public abstract class BasicAttributeValueReference
implements PsiReference {
    protected final PsiElement myElement;
    protected final TextRange myRange;

    public BasicAttributeValueReference(PsiElement element) {
        this(element, ElementManipulators.getValueTextRange((PsiElement)element));
    }

    public BasicAttributeValueReference(PsiElement element, int offset) {
        this(element, BasicAttributeValueReference.createTextRange(element, offset));
    }

    @NotNull
    private static TextRange createTextRange(PsiElement element, int offset) {
        int valueEndOffset = element.getTextLength() - offset;
        TextRange textRange = new TextRange(offset, Math.max(offset, valueEndOffset));
        if (textRange == null) {
            BasicAttributeValueReference.$$$reportNull$$$0(0);
        }
        return textRange;
    }

    public BasicAttributeValueReference(PsiElement element, TextRange range2) {
        this.myElement = element;
        this.myRange = range2;
    }

    @NotNull
    public PsiElement getElement() {
        PsiElement psiElement = this.myElement;
        if (psiElement == null) {
            BasicAttributeValueReference.$$$reportNull$$$0(1);
        }
        return psiElement;
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = this.myRange;
        if (textRange == null) {
            BasicAttributeValueReference.$$$reportNull$$$0(2);
        }
        return textRange;
    }

    @NotNull
    public String getCanonicalText() {
        String s = this.myElement.getText();
        if (this.myRange.getStartOffset() < s.length() && this.myRange.getEndOffset() <= s.length()) {
            String string = this.myRange.substring(s);
            if (string == null) {
                BasicAttributeValueReference.$$$reportNull$$$0(3);
            }
            return string;
        }
        if ("" == null) {
            BasicAttributeValueReference.$$$reportNull$$$0(4);
        }
        return "";
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            BasicAttributeValueReference.$$$reportNull$$$0(5);
        }
        return ElementManipulators.getManipulator((PsiElement)this.myElement).handleContentChange(this.myElement, this.getRangeInElement(), newElementName);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            BasicAttributeValueReference.$$$reportNull$$$0(6);
        }
        return null;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            BasicAttributeValueReference.$$$reportNull$$$0(7);
        }
        return this.myElement.getManager().areElementsEquivalent(element, this.resolve());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/BasicAttributeValueReference";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createTextRange";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/BasicAttributeValueReference";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

