/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui.header;

import com.intellij.application.options.schemes.AbstractDescriptionAwareSchemesPanel;
import com.intellij.application.options.schemes.AbstractSchemeActions;
import com.intellij.application.options.schemes.DescriptionAwareSchemeActions;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModel;
import com.intellij.codeInspection.ex.InspectionToolRegistrar;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.BaseInspectionProfileManager;
import com.intellij.profile.codeInspection.ui.SingleInspectionProfilePanel;
import com.intellij.profile.codeInspection.ui.header.InspectionProfileSchemesModel;
import com.intellij.profile.codeInspection.ui.header.InspectionToolsConfigurable;
import com.intellij.util.Consumer;
import com.intellij.util.JdomKt;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectionProfileSchemesPanel
extends AbstractDescriptionAwareSchemesPanel<InspectionProfileModifiableModel> {
    private static final Logger LOG = Logger.getInstance(InspectionProfileSchemesPanel.class);
    private final Project myProject;
    private final BaseInspectionProfileManager myAppProfileManager;
    private final BaseInspectionProfileManager myProjectProfileManager;
    private final InspectionToolsConfigurable myConfigurable;
    private final InspectionProfileSchemesModel myModel;

    InspectionProfileSchemesPanel(@NotNull Project project, @NotNull BaseInspectionProfileManager appProfileManager, @NotNull BaseInspectionProfileManager projectProfileManager, @NotNull InspectionToolsConfigurable configurable) {
        if (project == null) {
            InspectionProfileSchemesPanel.$$$reportNull$$$0(0);
        }
        if (appProfileManager == null) {
            InspectionProfileSchemesPanel.$$$reportNull$$$0(1);
        }
        if (projectProfileManager == null) {
            InspectionProfileSchemesPanel.$$$reportNull$$$0(2);
        }
        if (configurable == null) {
            InspectionProfileSchemesPanel.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.myAppProfileManager = appProfileManager;
        this.myProjectProfileManager = projectProfileManager;
        this.myConfigurable = configurable;
        this.myModel = new InspectionProfileSchemesModel(appProfileManager, projectProfileManager){

            @Override
            protected void onProfileRemoved(@NotNull SingleInspectionProfilePanel profilePanel) {
                if (profilePanel == null) {
                    1.$$$reportNull$$$0(0);
                }
                InspectionProfileSchemesPanel.this.myConfigurable.removeProfilePanel(profilePanel);
                List currentProfiles = InspectionProfileSchemesPanel.this.getModel().getProfilePanels().stream().map(SingleInspectionProfilePanel::getProfile).collect(Collectors.toList());
                InspectionProfileSchemesPanel.this.resetSchemes(currentProfiles);
                InspectionProfileSchemesPanel.this.selectScheme((Scheme)ContainerUtil.getFirstItem(currentProfiles));
            }

            @Override
            protected SingleInspectionProfilePanel createPanel(InspectionProfileModifiableModel model) {
                return InspectionProfileSchemesPanel.this.myConfigurable.createPanel(model);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profilePanel", "com/intellij/profile/codeInspection/ui/header/InspectionProfileSchemesPanel$1", "onProfileRemoved"));
            }
        };
    }

    @NotNull
    public InspectionProfileSchemesModel getModel() {
        InspectionProfileSchemesModel inspectionProfileSchemesModel = this.myModel;
        if (inspectionProfileSchemesModel == null) {
            InspectionProfileSchemesPanel.$$$reportNull$$$0(4);
        }
        return inspectionProfileSchemesModel;
    }

    @Override
    protected boolean supportsProjectSchemes() {
        return true;
    }

    @Override
    protected boolean highlightNonDefaultSchemes() {
        return false;
    }

    @Override
    public boolean useBoldForNonRemovableSchemes() {
        return false;
    }

    @Override
    protected boolean hideDeleteActionIfUnavailable() {
        return false;
    }

    @Override
    protected AbstractSchemeActions<InspectionProfileModifiableModel> createSchemeActions() {
        return new DescriptionAwareSchemeActions<InspectionProfileModifiableModel>((AbstractDescriptionAwareSchemesPanel)this){

            @Override
            @Nullable
            public String getDescription(@NotNull InspectionProfileModifiableModel scheme2) {
                if (scheme2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                SingleInspectionProfilePanel inspectionProfile = ((InspectionProfileSchemesModel)this.getModel()).getProfilePanel(scheme2);
                return inspectionProfile.getProfile().getDescription();
            }

            @Override
            protected void setDescription(@NotNull InspectionProfileModifiableModel scheme2, @NotNull String newDescription) {
                InspectionProfileModifiableModel inspectionProfile;
                if (scheme2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (newDescription == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (!Comparing.strEqual((String)newDescription, (String)(inspectionProfile = InspectionProfileSchemesPanel.this.getModel().getProfilePanel(scheme2).getProfile()).getDescription())) {
                    inspectionProfile.setDescription(newDescription);
                    inspectionProfile.setModified(true);
                }
            }

            @Override
            protected void importScheme(@NotNull String importerName) {
                if (importerName == null) {
                    2.$$$reportNull$$$0(3);
                }
                FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, false, false, false, false){

                    public boolean isFileSelectable(VirtualFile file2) {
                        return file2.getFileType().equals(StdFileTypes.XML);
                    }
                };
                descriptor.setDescription("Choose profile file");
                FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)InspectionProfileSchemesPanel.this.myProject, null, file2 -> {
                    if (file2 != null) {
                        try {
                            InspectionProfileImpl profile2 = InspectionProfileSchemesPanel.importInspectionProfile(JdomKt.loadElement((InputStream)file2.getInputStream()), InspectionProfileSchemesPanel.this.myAppProfileManager, InspectionProfileSchemesPanel.this.myProject);
                            if (profile2 == null) {
                                Messages.showErrorDialog((Project)InspectionProfileSchemesPanel.this.myProject, (String)("File '" + file2.getName() + "' has invalid format."), (String)"Inspection Settings");
                                return;
                            }
                            SingleInspectionProfilePanel existed = InspectionProfileSchemesPanel.this.getModel().getProfilePanel(profile2);
                            if (existed != null) {
                                if (Messages.showOkCancelDialog((Project)InspectionProfileSchemesPanel.this.myProject, (String)("Profile with name '" + profile2.getName() + "' already exists. Do you want to overwrite it?"), (String)"Overwrite Warning", (String)"Overwrite", (String)"Cancel", (Icon)Messages.getInformationIcon()) != 0) {
                                    return;
                                }
                                this.getModel().removeScheme(existed.getProfile());
                            }
                            InspectionProfileModifiableModel model = new InspectionProfileModifiableModel(profile2);
                            model.setModified(true);
                            InspectionProfileSchemesPanel.this.addProfile(model);
                            InspectionProfileSchemesPanel.this.selectScheme(model);
                        }
                        catch (InvalidDataException | IOException | JDOMException e) {
                            LOG.error(e);
                        }
                    }
                });
            }

            @Override
            protected void resetScheme(@NotNull InspectionProfileModifiableModel scheme2) {
                if (scheme2 == null) {
                    2.$$$reportNull$$$0(4);
                }
                SingleInspectionProfilePanel panel2 = InspectionProfileSchemesPanel.this.getModel().getProfilePanel(scheme2);
                panel2.performProfileReset();
            }

            @Override
            protected void duplicateScheme(@NotNull InspectionProfileModifiableModel scheme2, @NotNull String newName) {
                if (scheme2 == null) {
                    2.$$$reportNull$$$0(5);
                }
                if (newName == null) {
                    2.$$$reportNull$$$0(6);
                }
                InspectionProfileModifiableModel newProfile = InspectionProfileSchemesPanel.this.copyToNewProfile(scheme2, InspectionProfileSchemesPanel.this.myProject, newName, false);
                InspectionProfileSchemesPanel.this.addProfile(newProfile);
                InspectionProfileSchemesPanel.this.myConfigurable.selectProfile(newProfile);
                InspectionProfileSchemesPanel.this.selectScheme(newProfile);
            }

            @Override
            protected void onSchemeChanged(@Nullable InspectionProfileModifiableModel scheme2) {
                super.onSchemeChanged(scheme2);
                if (scheme2 != null) {
                    InspectionProfileSchemesPanel.this.myConfigurable.selectProfile(scheme2);
                }
            }

            @Override
            protected void renameScheme(@NotNull InspectionProfileModifiableModel scheme2, @NotNull String newName) {
                if (scheme2 == null) {
                    2.$$$reportNull$$$0(7);
                }
                if (newName == null) {
                    2.$$$reportNull$$$0(8);
                }
                scheme2.setName(newName);
            }

            @Override
            protected void copyToProject(@NotNull InspectionProfileModifiableModel scheme2) {
                if (scheme2 == null) {
                    2.$$$reportNull$$$0(9);
                }
                this.copyToAnotherLevel(scheme2, true);
            }

            @Override
            protected void copyToIDE(@NotNull InspectionProfileModifiableModel scheme2) {
                if (scheme2 == null) {
                    2.$$$reportNull$$$0(10);
                }
                this.copyToAnotherLevel(scheme2, false);
            }

            @Override
            protected Class<InspectionProfileModifiableModel> getSchemeType() {
                return InspectionProfileModifiableModel.class;
            }

            private void copyToAnotherLevel(InspectionProfileModifiableModel profile2, boolean copyToProject) {
                this.getSchemesPanel().editNewSchemeName(profile2.getName(), copyToProject, newName -> {
                    InspectionProfileModifiableModel newProfile = InspectionProfileSchemesPanel.this.copyToNewProfile(profile2, InspectionProfileSchemesPanel.this.myProject, newName, true);
                    InspectionProfileSchemesPanel.this.addProfile(newProfile);
                    InspectionProfileSchemesPanel.this.selectScheme(newProfile);
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "scheme";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "newDescription";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "importerName";
                        break;
                    }
                    case 6: 
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "newName";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/profile/codeInspection/ui/header/InspectionProfileSchemesPanel$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getDescription";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setDescription";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "importScheme";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "resetScheme";
                        break;
                    }
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "duplicateScheme";
                        break;
                    }
                    case 7: 
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[2] = "renameScheme";
                        break;
                    }
                    case 9: {
                        objectArray = objectArray2;
                        objectArray2[2] = "copyToProject";
                        break;
                    }
                    case 10: {
                        objectArray = objectArray2;
                        objectArray2[2] = "copyToIDE";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Override
    protected String getSchemeTypeName() {
        return "Profile";
    }

    void apply() {
        this.getModel().apply((InspectionProfileModifiableModel)this.getSelectedScheme(), (Consumer<? super InspectionProfileImpl>)((Consumer)p -> {
            if (this.myConfigurable.setActiveProfileAsDefaultOnApply()) {
                this.myConfigurable.applyRootProfile(p.getName(), p.isProjectLevel());
            }
        }));
    }

    void reset() {
        this.getModel().reset();
        this.getModel().updatePanel(this);
    }

    @NotNull
    private InspectionProfileModifiableModel copyToNewProfile(@NotNull InspectionProfileImpl selectedProfile, @NotNull Project project, @NotNull String newName, boolean modifyLevel) {
        boolean isProjectLevel;
        if (selectedProfile == null) {
            InspectionProfileSchemesPanel.$$$reportNull$$$0(5);
        }
        if (project == null) {
            InspectionProfileSchemesPanel.$$$reportNull$$$0(6);
        }
        if (newName == null) {
            InspectionProfileSchemesPanel.$$$reportNull$$$0(7);
        }
        BaseInspectionProfileManager profileManager = (isProjectLevel = selectedProfile.isProjectLevel() ^ modifyLevel) ? this.myProjectProfileManager : this.myAppProfileManager;
        InspectionProfileImpl inspectionProfile = new InspectionProfileImpl(newName, (Supplier<List<InspectionToolWrapper>>)InspectionToolRegistrar.getInstance(), profileManager);
        inspectionProfile.copyFrom(selectedProfile);
        inspectionProfile.setName(newName);
        inspectionProfile.initInspectionTools(project);
        inspectionProfile.setProjectLevel(isProjectLevel);
        InspectionProfileModifiableModel modifiableModel = new InspectionProfileModifiableModel(inspectionProfile);
        modifiableModel.setModified(true);
        InspectionProfileModifiableModel inspectionProfileModifiableModel = modifiableModel;
        if (inspectionProfileModifiableModel == null) {
            InspectionProfileSchemesPanel.$$$reportNull$$$0(8);
        }
        return inspectionProfileModifiableModel;
    }

    private void addProfile(InspectionProfileModifiableModel profile2) {
        InspectionProfileModifiableModel selected = (InspectionProfileModifiableModel)this.getSelectedScheme();
        this.getModel().addProfile(profile2);
        this.getModel().updatePanel(this);
        this.selectScheme(selected);
    }

    @Override
    @NotNull
    protected JComponent getConfigurableFocusComponent() {
        JComponent jComponent = this.myConfigurable.getPreferredFocusedComponent();
        if (jComponent == null) {
            InspectionProfileSchemesPanel.$$$reportNull$$$0(9);
        }
        return jComponent;
    }

    @Nullable(value="returns null if xml has invalid format")
    public static InspectionProfileImpl importInspectionProfile(@NotNull Element rootElement, @NotNull BaseInspectionProfileManager profileManager, @NotNull Project project) {
        String profileName;
        if (rootElement == null) {
            InspectionProfileSchemesPanel.$$$reportNull$$$0(10);
        }
        if (profileManager == null) {
            InspectionProfileSchemesPanel.$$$reportNull$$$0(11);
        }
        if (project == null) {
            InspectionProfileSchemesPanel.$$$reportNull$$$0(12);
        }
        if (Comparing.strEqual((String)rootElement.getName(), (String)"component")) {
            rootElement = (Element)rootElement.getChildren().get(0);
        }
        if ((profileName = InspectionProfileSchemesPanel.getProfileName(rootElement)) == null) {
            return null;
        }
        InspectionProfileImpl profile2 = new InspectionProfileImpl(profileName, (Supplier<List<InspectionToolWrapper>>)InspectionToolRegistrar.getInstance(), profileManager);
        HashSet levels = new HashSet();
        for (Element inspectElement : rootElement.getChildren("inspection_tool")) {
            ContainerUtil.addAllNotNull(levels, (Object[])new String[]{inspectElement.getAttributeValue("level")});
            for (Element s : inspectElement.getChildren("scope")) {
                ContainerUtil.addAllNotNull(levels, (Object[])new String[]{s.getAttributeValue("level")});
            }
        }
        Iterator iterator = levels.iterator();
        while (iterator.hasNext()) {
            String level = (String)iterator.next();
            if (profileManager.getSeverityRegistrar().getSeverity(level) == null) continue;
            iterator.remove();
        }
        if (!levels.isEmpty()) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                if (Messages.showYesNoDialog((Project)project, (String)("Undefined severities detected: " + StringUtil.join(levels, (String)", ") + ". Do you want to create them?"), (String)"Warning", (Icon)Messages.getWarningIcon()) == 0) {
                    for (String level : levels) {
                        TextAttributes textAttributes = CodeInsightColors.WARNINGS_ATTRIBUTES.getDefaultAttributes();
                        HighlightInfoType.HighlightInfoTypeImpl info = new HighlightInfoType.HighlightInfoTypeImpl(new HighlightSeverity(level, 50), TextAttributesKey.createTextAttributesKey((String)level));
                        profileManager.getSeverityRegistrar().registerSeverity(new SeverityRegistrar.SeverityBasedTextAttributes(textAttributes.clone(), info), textAttributes.getErrorStripeColor());
                    }
                }
            } else {
                throw new AssertionError((Object)("All of levels must exist in unit-test mode, but actual not exist levels = " + levels));
            }
        }
        profile2.readExternal(rootElement);
        profile2.setProjectLevel(false);
        profile2.initInspectionTools(project);
        return profile2;
    }

    private static String getProfileName(Element rootElement) {
        for (Element option : rootElement.getChildren("option")) {
            String optionName = option.getAttributeValue("name");
            if (!optionName.equals("myName")) continue;
            return option.getAttributeValue("value");
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appProfileManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectProfileManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
            case 4: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/profile/codeInspection/ui/header/InspectionProfileSchemesPanel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedProfile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profileManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/profile/codeInspection/ui/header/InspectionProfileSchemesPanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "copyToNewProfile";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurableFocusComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 8: 
            case 9: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "copyToNewProfile";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "importInspectionProfile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

