/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserModuleNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicy;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicyFactory;
import com.intellij.openapi.vcs.changes.ui.ChangesModuleGroupingPolicy;
import com.intellij.openapi.vcs.changes.ui.DirectoryChangesGroupingPolicy;
import com.intellij.openapi.vcs.changes.ui.StaticFilePath;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.NotNullFunction;
import java.util.Map;
import javax.swing.tree.DefaultTreeModel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00172\u00020\u0001:\u0002\u0017\u0018B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J*\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0002J\"\u0010\u0014\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/ChangesModuleGroupingPolicy;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesGroupingPolicy;", "myProject", "Lcom/intellij/openapi/project/Project;", "myModel", "Ljavax/swing/tree/DefaultTreeModel;", "(Lcom/intellij/openapi/project/Project;Ljavax/swing/tree/DefaultTreeModel;)V", "myIndex", "Lcom/intellij/openapi/roots/ProjectFileIndex;", "getMyModel", "()Ljavax/swing/tree/DefaultTreeModel;", "getMyProject", "()Lcom/intellij/openapi/project/Project;", "getNodeForModule", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "module", "Lcom/intellij/openapi/module/Module;", "nodePath", "Lcom/intellij/openapi/vcs/changes/ui/StaticFilePath;", "subtreeRoot", "getParentNodeFor", "isTopLevel", "", "Companion", "Factory", "intellij.platform.vcs.impl"})
public class ChangesModuleGroupingPolicy
implements ChangesGroupingPolicy {
    private final ProjectFileIndex myIndex;
    @NotNull
    private final Project myProject;
    @NotNull
    private final DefaultTreeModel myModel;
    @NotNull
    private static final NotNullLazyKey<Map<Module, ChangesBrowserNode<?>>, ChangesBrowserNode<?>> MODULE_CACHE;
    private static final boolean HIDE_EXCLUDED_FILES;
    public static final Companion Companion;

    @Nullable
    public ChangesBrowserNode<?> getParentNodeFor(@NotNull StaticFilePath nodePath, @NotNull ChangesBrowserNode<?> subtreeRoot) {
        Intrinsics.checkParameterIsNotNull((Object)nodePath, (String)"nodePath");
        Intrinsics.checkParameterIsNotNull(subtreeRoot, (String)"subtreeRoot");
        if (this.myProject.isDefault()) {
            return null;
        }
        VirtualFile vFile = nodePath.resolve();
        if (vFile != null && Comparing.equal((Object)vFile, (Object)this.myIndex.getContentRootForFile(vFile, HIDE_EXCLUDED_FILES))) {
            Module module = this.myIndex.getModuleForFile(vFile, HIDE_EXCLUDED_FILES);
            return this.getNodeForModule(module, nodePath, subtreeRoot);
        }
        return null;
    }

    private final ChangesBrowserNode<?> getNodeForModule(Module module, StaticFilePath nodePath, ChangesBrowserNode<?> subtreeRoot) {
        ChangesBrowserNode changesBrowserNode;
        ChangesBrowserNode parent;
        ChangesBrowserNode<?> cachingRoot = DirectoryChangesGroupingPolicy.Companion.getCachingRoot$intellij_platform_vcs_impl(subtreeRoot);
        ChangesBrowserNode changesBrowserNode2 = (ChangesBrowserNode)((Map)MODULE_CACHE.getValue((UserDataHolder)cachingRoot)).get(module);
        if (changesBrowserNode2 != null) {
            ChangesBrowserNode changesBrowserNode3;
            ChangesBrowserNode it = changesBrowserNode3 = changesBrowserNode2;
            return it;
        }
        DirectoryChangesGroupingPolicy policy = (DirectoryChangesGroupingPolicy)DirectoryChangesGroupingPolicy.DIRECTORY_POLICY.get((UserDataHolder)subtreeRoot);
        ChangesBrowserNode changesBrowserNode4 = (ChangesBrowserNode)DirectoryChangesGroupingPolicy.Companion.getGRAND_PARENT_CANDIDATE$intellij_platform_vcs_impl().get((UserDataHolder)subtreeRoot);
        if (changesBrowserNode4 == null) {
            if (policy != null && !this.isTopLevel(nodePath)) {
                changesBrowserNode4 = policy.getParentNodeInternal(nodePath, subtreeRoot);
            } else {
                Object object = DirectoryChangesGroupingPolicy.Companion.getHIERARCHY_UPPER_BOUND$intellij_platform_vcs_impl().getRequired((UserDataHolder)subtreeRoot);
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"HIERARCHY_UPPER_BOUND.getRequired(subtreeRoot)");
                changesBrowserNode4 = parent = (ChangesBrowserNode)object;
            }
        }
        if (module == null) {
            ChangesBrowserNode changesBrowserNode5 = ChangesBrowserNode.create(this.myProject, "<Project Root>");
            changesBrowserNode = changesBrowserNode5;
            Intrinsics.checkExpressionValueIsNotNull((Object)changesBrowserNode5, (String)"ChangesBrowserNode.creat\u2026roject, PROJECT_ROOT_TAG)");
        } else {
            changesBrowserNode = new ChangesBrowserModuleNode(module);
        }
        ChangesBrowserNode node = changesBrowserNode;
        this.myModel.insertNodeInto(node, parent, parent.getChildCount());
        Object object = MODULE_CACHE.getValue((UserDataHolder)cachingRoot);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"MODULE_CACHE.getValue(cachingRoot)");
        Map map = (Map)object;
        Object object2 = node;
        map.put(module, object2);
        Object object3 = TreeModelBuilder.DIRECTORY_CACHE.getValue((UserDataHolder)cachingRoot);
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"DIRECTORY_CACHE.getValue(cachingRoot)");
        map = (Map)object3;
        object2 = nodePath.getKey();
        ChangesBrowserNode changesBrowserNode6 = node;
        map.put(object2, changesBrowserNode6);
        return node;
    }

    private final boolean isTopLevel(StaticFilePath nodePath) {
        StaticFilePath staticFilePath = nodePath.getParent();
        VirtualFile parentFile = staticFilePath != null ? staticFilePath.resolve() : null;
        return parentFile == null || this.myIndex.getContentRootForFile(parentFile, HIDE_EXCLUDED_FILES) == null;
    }

    @NotNull
    public final Project getMyProject() {
        return this.myProject;
    }

    @NotNull
    public final DefaultTreeModel getMyModel() {
        return this.myModel;
    }

    public ChangesModuleGroupingPolicy(@NotNull Project myProject, @NotNull DefaultTreeModel myModel) {
        Intrinsics.checkParameterIsNotNull((Object)myProject, (String)"myProject");
        Intrinsics.checkParameterIsNotNull((Object)myModel, (String)"myModel");
        this.myProject = myProject;
        this.myModel = myModel;
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)this.myProject);
        Intrinsics.checkExpressionValueIsNotNull((Object)projectFileIndex, (String)"ProjectFileIndex.getInstance(myProject)");
        this.myIndex = projectFileIndex;
    }

    static {
        Companion = new Companion(null);
        NotNullLazyKey notNullLazyKey = NotNullLazyKey.create((String)"ChangesTree.ModuleCache", (NotNullFunction)Companion.MODULE_CACHE.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)notNullLazyKey, (String)"NotNullLazyKey.create<Mu\u2026) { _ -> mutableMapOf() }");
        MODULE_CACHE = notNullLazyKey;
        HIDE_EXCLUDED_FILES = Registry.is((String)"ide.hide.excluded.files");
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/ChangesModuleGroupingPolicy$Factory;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesGroupingPolicyFactory;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "createGroupingPolicy", "Lcom/intellij/openapi/vcs/changes/ui/ChangesGroupingPolicy;", "model", "Ljavax/swing/tree/DefaultTreeModel;", "intellij.platform.vcs.impl"})
    public static final class Factory
    extends ChangesGroupingPolicyFactory {
        @NotNull
        private final Project project;

        @Override
        @NotNull
        public ChangesGroupingPolicy createGroupingPolicy(@NotNull DefaultTreeModel model) {
            Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
            return new ChangesModuleGroupingPolicy(this.project, model);
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        public Factory(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            this.project = project;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R3\u0010\u0007\u001a$\u0012\u0016\u0012\u0014\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\t\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/ChangesModuleGroupingPolicy$Companion;", "", "()V", "HIDE_EXCLUDED_FILES", "", "getHIDE_EXCLUDED_FILES", "()Z", "MODULE_CACHE", "Lcom/intellij/openapi/util/NotNullLazyKey;", "", "Lcom/intellij/openapi/module/Module;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "getMODULE_CACHE", "()Lcom/intellij/openapi/util/NotNullLazyKey;", "intellij.platform.vcs.impl"})
    public static final class Companion {
        @NotNull
        public final NotNullLazyKey<Map<Module, ChangesBrowserNode<?>>, ChangesBrowserNode<?>> getMODULE_CACHE() {
            return MODULE_CACHE;
        }

        public final boolean getHIDE_EXCLUDED_FILES() {
            return HIDE_EXCLUDED_FILES;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

