/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ChangesBrowserSpecificFilesNode
extends ChangesBrowserNode<Object> {
    protected final boolean myIsMany;
    @NotNull
    protected final Runnable myDialogShower;
    private final int myManyFileCount;
    private final int myManyDirectoryCount;

    protected ChangesBrowserSpecificFilesNode(Object userObject, @NotNull List<VirtualFile> files2, @NotNull Runnable shower) {
        if (files2 == null) {
            ChangesBrowserSpecificFilesNode.$$$reportNull$$$0(0);
        }
        if (shower == null) {
            ChangesBrowserSpecificFilesNode.$$$reportNull$$$0(1);
        }
        super(userObject);
        this.myManyDirectoryCount = ContainerUtil.count(files2, it -> it.isDirectory());
        this.myManyFileCount = files2.size() - this.myManyDirectoryCount;
        this.myIsMany = files2.size() > Registry.intValue((String)"vcs.unversioned.files.max.intree", (int)1000);
        this.myDialogShower = shower;
    }

    @Override
    public void render(@NotNull ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
        if (renderer == null) {
            ChangesBrowserSpecificFilesNode.$$$reportNull$$$0(2);
        }
        super.render(renderer, selected, expanded, hasFocus);
        if (this.isManyFiles()) {
            renderer.append(" ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
            renderer.append("browse", SimpleTextAttributes.LINK_ATTRIBUTES, this.myDialogShower);
        }
    }

    @Override
    public int getFileCount() {
        return this.myIsMany ? this.myManyFileCount : super.getFileCount();
    }

    @Override
    public int getDirectoryCount() {
        return this.myIsMany ? this.myManyDirectoryCount : super.getDirectoryCount();
    }

    public boolean isManyFiles() {
        return this.myIsMany;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shower";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/ChangesBrowserSpecificFilesNode";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "render";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

