/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CachingCommittedChangesProvider;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesAdapter;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesCache;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.util.Consumer;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IncomingChangesIndicator {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.committed.IncomingChangesIndicator");
    private final Project myProject;
    private final CommittedChangesCache myCache;
    private IndicatorComponent myIndicatorComponent;

    public IncomingChangesIndicator(Project project, CommittedChangesCache cache, MessageBus bus) {
        this.myProject = project;
        this.myCache = cache;
        MessageBusConnection connection = bus.connect();
        connection.subscribe(CommittedChangesCache.COMMITTED_TOPIC, (Object)new CommittedChangesAdapter(){

            @Override
            public void incomingChangesUpdated(@Nullable List<CommittedChangeList> receivedChanges) {
                ApplicationManager.getApplication().invokeLater(() -> IncomingChangesIndicator.this.refreshIndicator());
            }
        });
        VcsListener listener2 = new VcsListener(){

            public void directoryMappingChanged() {
                if (IncomingChangesIndicator.this.myProject.isDisposed()) {
                    return;
                }
                UIUtil.invokeLaterIfNeeded(() -> IncomingChangesIndicator.this.updateIndicatorVisibility());
            }
        };
        connection.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, (Object)listener2);
        connection.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED_IN_PLUGIN, (Object)listener2);
    }

    private void updateIndicatorVisibility() {
        StatusBar statusBar = WindowManager.getInstance().getStatusBar(this.myProject);
        if (this.needIndicator()) {
            if (this.myIndicatorComponent == null) {
                this.myIndicatorComponent = new IndicatorComponent();
                statusBar.addWidget((StatusBarWidget)this.myIndicatorComponent, (Disposable)this.myProject);
                this.refreshIndicator();
            }
        } else if (this.myIndicatorComponent != null) {
            statusBar.removeWidget(this.myIndicatorComponent.ID());
            this.myIndicatorComponent = null;
        }
    }

    private boolean needIndicator() {
        AbstractVcs[] vcss;
        for (AbstractVcs vcs : vcss = ProjectLevelVcsManager.getInstance((Project)this.myProject).getAllActiveVcss()) {
            CachingCommittedChangesProvider provider = vcs.getCachingCommittedChangesProvider();
            if (provider == null || !provider.supportsIncomingChanges()) continue;
            return true;
        }
        return false;
    }

    private void refreshIndicator() {
        if (this.myIndicatorComponent == null) {
            return;
        }
        List<CommittedChangeList> list2 = this.myCache.getCachedIncomingChanges();
        if (list2 == null || list2.isEmpty()) {
            IncomingChangesIndicator.debug("Refreshing indicator: no changes");
            this.myIndicatorComponent.clear();
        } else {
            IncomingChangesIndicator.debug("Refreshing indicator: " + list2.size() + " changes");
            this.myIndicatorComponent.setChangesAvailable(VcsBundle.message((String)"incoming.changes.indicator.tooltip", (Object[])new Object[]{list2.size()}));
        }
    }

    private static void debug(@NonNls String message) {
        LOG.debug(message);
    }

    private static class IndicatorComponent
    implements StatusBarWidget,
    StatusBarWidget.IconPresentation {
        private StatusBar myStatusBar;
        private Icon myCurrentIcon = AllIcons.Ide.IncomingChangesOff;
        private String myToolTipText;

        private IndicatorComponent() {
        }

        void clear() {
            this.update(AllIcons.Ide.IncomingChangesOff, "No incoming changelists available");
        }

        void setChangesAvailable(@NotNull String toolTipText) {
            if (toolTipText == null) {
                IndicatorComponent.$$$reportNull$$$0(0);
            }
            this.update(AllIcons.Ide.IncomingChangesOn, toolTipText);
        }

        private void update(@NotNull Icon icon, @Nullable String toolTipText) {
            if (icon == null) {
                IndicatorComponent.$$$reportNull$$$0(1);
            }
            this.myCurrentIcon = icon;
            this.myToolTipText = toolTipText;
            if (this.myStatusBar != null) {
                this.myStatusBar.updateWidget(this.ID());
            }
        }

        @NotNull
        public Icon getIcon() {
            Icon icon = this.myCurrentIcon;
            if (icon == null) {
                IndicatorComponent.$$$reportNull$$$0(2);
            }
            return icon;
        }

        public String getTooltipText() {
            return this.myToolTipText;
        }

        public Consumer<MouseEvent> getClickConsumer() {
            return mouseEvent -> {
                DataContext dataContext;
                Project project;
                if (this.myStatusBar != null && (project = (Project)CommonDataKeys.PROJECT.getData(dataContext = DataManager.getInstance().getDataContext((Component)this.myStatusBar))) != null) {
                    ToolWindow changesView = ToolWindowManager.getInstance((Project)project).getToolWindow(ChangesViewContentManager.TOOLWINDOW_ID);
                    changesView.show(() -> ChangesViewContentManager.getInstance(project).selectContent("Incoming"));
                }
            };
        }

        @NotNull
        public String ID() {
            if ("IncomingChanges" == null) {
                IndicatorComponent.$$$reportNull$$$0(3);
            }
            return "IncomingChanges";
        }

        public StatusBarWidget.WidgetPresentation getPresentation(@NotNull StatusBarWidget.PlatformType type) {
            if (type == null) {
                IndicatorComponent.$$$reportNull$$$0(4);
            }
            return this;
        }

        public void install(@NotNull StatusBar statusBar) {
            if (statusBar == null) {
                IndicatorComponent.$$$reportNull$$$0(5);
            }
            this.myStatusBar = statusBar;
        }

        public void dispose() {
            this.myStatusBar = null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toolTipText";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "icon";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/committed/IncomingChangesIndicator$IndicatorComponent";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statusBar";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/committed/IncomingChangesIndicator$IndicatorComponent";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "ID";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "setChangesAvailable";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentation";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "install";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

