/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.customize;

import com.intellij.ide.customize.PluginGroups;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nullable;

class IdSet {
    private static final List<String> BLACK_LIST = Arrays.asList("Support", "support", "Integration", "integration");
    String myTitle;
    String[] myIds;

    IdSet(PluginGroups pluginGroups, String description) {
        int i = description.indexOf(":");
        if (i > 0) {
            this.myTitle = description.substring(0, i);
            description = description.substring(i + 1);
        }
        this.myIds = description.split(",");
        this.myIds = ContainerUtil.filter((Object[])this.myIds, id -> pluginGroups.findPlugin((String)id) != null).toArray(new String[0]);
        if (this.myIds.length > 1 && this.myTitle == null) {
            throw new IllegalArgumentException("There is no common title for " + this.myIds.length + " ids: " + description);
        }
        if (this.myTitle == null && this.myIds.length > 0) {
            this.myTitle = pluginGroups.findPlugin(this.myIds[0]).getName();
        }
        if (this.myIds.length == 0 && this.myTitle != null) {
            this.myTitle = null;
        }
        if (this.myTitle != null) {
            for (String skipWord : BLACK_LIST) {
                this.myTitle = this.myTitle.replaceAll(skipWord, "");
            }
            this.myTitle = this.myTitle.replaceAll("  ", " ").trim();
        }
    }

    public String toString() {
        return this.myTitle + ": " + (this.myIds != null ? this.myIds.length : 0);
    }

    @Nullable
    public String getTitle() {
        return this.myTitle;
    }

    public String[] getIds() {
        return this.myIds;
    }
}

