/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.ShowFilePathAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.settingsSummary.ProblemType;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.ZipUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.ZipOutputStream;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CollectZippedLogsAction
extends AnAction
implements DumbAware {
    private static final String CONFIRMATION_DIALOG = "zipped.logs.action.show.confirmation.dialog";

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            CollectZippedLogsAction.$$$reportNull$$$0(0);
        }
        Project project = e.getProject();
        boolean doNotShowDialog = PropertiesComponent.getInstance().getBoolean(CONFIRMATION_DIALOG);
        try {
            File zippedLogsFile = CollectZippedLogsAction.createZip(project);
            if (!doNotShowDialog) {
                Messages.showIdeaMessageDialog((Project)project, (String)"Included logs and settings may contain sensitive data.", (String)"Sensitive Data", (String[])new String[]{"Show in " + ShowFilePathAction.getFileManagerName()}, (int)1, (Icon)Messages.getWarningIcon(), (DialogWrapper.DoNotAskOption)new DialogWrapper.DoNotAskOption.Adapter(){

                    public void rememberChoice(boolean selected, int exitCode) {
                        PropertiesComponent.getInstance().setValue(CollectZippedLogsAction.CONFIRMATION_DIALOG, selected);
                    }
                });
            }
            if (ShowFilePathAction.isSupported()) {
                ShowFilePathAction.openFile(zippedLogsFile);
            } else {
                Messages.showInfoMessage((String)zippedLogsFile.getAbsolutePath(), (String)"Log File");
            }
        }
        catch (IOException exception) {
            Messages.showErrorDialog((String)("Can't create zip file with logs: " + exception.getLocalizedMessage()), (String)"Can't Create File");
        }
    }

    @NotNull
    private static File createZip(@Nullable Project project) throws IOException {
        File settingsTempFile = null;
        File zippedLogsFile = FileUtil.createTempFile((String)("logs-" + CollectZippedLogsAction.getDate()), (String)".zip");
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zippedLogsFile)));){
            ZipUtil.addFileOrDirRecursively((ZipOutputStream)zipOutputStream, null, (File)new File(PathManager.getLogPath()), (String)"", null, null);
            if (project != null) {
                settingsTempFile = CollectZippedLogsAction.dumpSettingsToFile(project);
                ZipUtil.addFileToZip((ZipOutputStream)zipOutputStream, (File)settingsTempFile, (String)"settings.txt", null, null);
            }
            for (File javaErrorLog : CollectZippedLogsAction.getJavaErrorLogs()) {
                ZipUtil.addFileToZip((ZipOutputStream)zipOutputStream, (File)javaErrorLog, (String)javaErrorLog.getName(), null, null);
            }
        }
        catch (IOException exception) {
            zippedLogsFile.delete();
            throw exception;
        }
        finally {
            if (settingsTempFile != null) {
                settingsTempFile.delete();
            }
        }
        File file2 = zippedLogsFile;
        if (file2 == null) {
            CollectZippedLogsAction.$$$reportNull$$$0(1);
        }
        return file2;
    }

    private static File[] getJavaErrorLogs() {
        return new File(SystemProperties.getUserHome()).listFiles(file2 -> file2.isFile() && file2.getName().startsWith("java_error_in") && !file2.getName().endsWith("hprof"));
    }

    @NotNull
    private static File dumpSettingsToFile(@NotNull Project project) throws IOException {
        if (project == null) {
            CollectZippedLogsAction.$$$reportNull$$$0(2);
        }
        File settingsTempFile = FileUtil.createTempFile((String)("settings" + CollectZippedLogsAction.getDate()), (String)".txt");
        for (ProblemType problemType : (ProblemType[])ProblemType.EP_SETTINGS.getExtensions()) {
            String settingString = problemType.collectInfo(project);
            FileUtil.appendToFile((File)settingsTempFile, (String)(settingString + '\n'));
        }
        File file2 = settingsTempFile;
        if (file2 == null) {
            CollectZippedLogsAction.$$$reportNull$$$0(3);
        }
        return file2;
    }

    @NotNull
    private static String getDate() {
        String string = new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date());
        if (string == null) {
            CollectZippedLogsAction.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            CollectZippedLogsAction.$$$reportNull$$$0(5);
        }
        Presentation presentation = e.getPresentation();
        presentation.setText(CollectZippedLogsAction.getActionName());
    }

    @NotNull
    private static String getActionName() {
        String string = "Compress Logs and Show in " + ShowFilePathAction.getFileManagerName();
        if (string == null) {
            CollectZippedLogsAction.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/CollectZippedLogsAction";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/CollectZippedLogsAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createZip";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpSettingsToFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDate";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "dumpSettingsToFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

