/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.engine;

import com.intellij.formatting.engine.State;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;

public class StateProcessor {
    private final List<State> myStates = ContainerUtil.newArrayList();
    private State myCurrentState;

    public StateProcessor(State initial) {
        this.myCurrentState = initial;
    }

    public void setNextState(State state) {
        this.myStates.add(state);
    }

    public boolean isDone() {
        return this.myStates.isEmpty() && this.myCurrentState.isDone();
    }

    public void iteration() {
        if (!this.myCurrentState.isDone()) {
            this.myCurrentState.iteration();
        }
        this.shiftStateIfNecessary();
    }

    private void shiftStateIfNecessary() {
        if (this.myCurrentState.isDone() && !this.myStates.isEmpty()) {
            this.myCurrentState = this.myStates.get(0);
            this.myStates.remove(0);
            this.myCurrentState.prepare();
        }
    }

    public void stop() {
        this.myCurrentState.stop();
    }
}

