/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.ex.http.HttpFileSystem;
import com.intellij.util.SmartList;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlatformDocumentationUtil {
    @NonNls
    private static final Pattern ourLtFixupPattern = Pattern.compile("<(?=[^/!\\p{Alpha}])");
    @NonNls
    private static final String LT_ENTITY = "&lt;";

    @Nullable
    public static List<String> getHttpRoots(@NotNull String[] roots, String relPath) {
        if (roots == null) {
            PlatformDocumentationUtil.$$$reportNull$$$0(0);
        }
        SmartList result2 = new SmartList();
        for (String root : roots) {
            String url;
            VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(root);
            if (virtualFile == null || (url = PlatformDocumentationUtil.getDocUrl(virtualFile, relPath)) == null) continue;
            result2.add(url);
        }
        return result2.isEmpty() ? null : result2;
    }

    @Nullable
    public static String getDocUrl(@NotNull VirtualFile root, String relPath) {
        if (root == null) {
            PlatformDocumentationUtil.$$$reportNull$$$0(1);
        }
        if (root.getFileSystem() instanceof HttpFileSystem) {
            String url = StringUtil.trimEnd((String)root.getUrl(), (String)"/index.html", (boolean)true);
            if (!url.endsWith("/")) {
                url = url + "/";
            }
            return url + relPath;
        }
        VirtualFile file2 = root.findFileByRelativePath(relPath);
        return file2 == null ? null : file2.getUrl();
    }

    public static String fixupText(@NotNull CharSequence docText) {
        if (docText == null) {
            PlatformDocumentationUtil.$$$reportNull$$$0(2);
        }
        return ourLtFixupPattern.matcher(docText).replaceAll(LT_ENTITY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docText";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/documentation/PlatformDocumentationUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getHttpRoots";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getDocUrl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "fixupText";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

