/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoveAttributeIntentionFix
implements LocalQuickFix,
IntentionAction {
    private final String myLocalName;

    @Deprecated
    public RemoveAttributeIntentionFix(String localName, XmlAttribute attribute) {
        this(localName);
    }

    public RemoveAttributeIntentionFix(String localName) {
        this.myLocalName = localName;
    }

    public RemoveAttributeIntentionFix() {
        this(null);
    }

    @NotNull
    public String getName() {
        String string = XmlErrorMessages.message("remove.attribute.quickfix.text", this.myLocalName);
        if (string == null) {
            RemoveAttributeIntentionFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        String string = this.myLocalName != null ? this.getName() : this.getFamilyName();
        if (string == null) {
            RemoveAttributeIntentionFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = XmlErrorMessages.message("remove.attribute.quickfix.family", new Object[0]);
        if (string == null) {
            RemoveAttributeIntentionFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            RemoveAttributeIntentionFix.$$$reportNull$$$0(3);
        }
        return RemoveAttributeIntentionFix.getAttribute(editor, file2) != null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project == null) {
            RemoveAttributeIntentionFix.$$$reportNull$$$0(4);
        }
        this.removeAttribute((PsiElement)RemoveAttributeIntentionFix.getAttribute(editor, file2), editor);
    }

    public boolean startInWriteAction() {
        return true;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            RemoveAttributeIntentionFix.$$$reportNull$$$0(5);
        }
        if (descriptor == null) {
            RemoveAttributeIntentionFix.$$$reportNull$$$0(6);
        }
        PsiElement e = descriptor.getPsiElement();
        this.removeAttribute(e, null);
    }

    protected void removeAttribute(PsiElement e, Editor editor) {
        XmlAttribute myAttribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)e, XmlAttribute.class, (boolean)false);
        if (myAttribute == null) {
            return;
        }
        PsiElement next = RemoveAttributeIntentionFix.findNextAttribute(myAttribute);
        myAttribute.delete();
        if (next != null && editor != null) {
            editor.getCaretModel().moveToOffset(next.getTextRange().getStartOffset());
        }
    }

    @Nullable
    private static PsiElement findNextAttribute(XmlAttribute attribute) {
        for (PsiElement nextSibling = attribute.getNextSibling(); nextSibling != null; nextSibling = nextSibling.getNextSibling()) {
            if (!(nextSibling instanceof XmlAttribute)) continue;
            return nextSibling;
        }
        return null;
    }

    private static XmlAttribute getAttribute(Editor editor, PsiFile file2) {
        int offset = editor.getCaretModel().getOffset();
        XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)file2.findElementAt(offset), XmlAttribute.class);
        if (attribute == null) {
            attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)file2.findElementAt(offset - 1), XmlAttribute.class);
        }
        return attribute;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/RemoveAttributeIntentionFix";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/RemoveAttributeIntentionFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

