/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.extensions;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.authentication.accounts.AccountTokenChangedListener;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccountManager;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0005J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0005R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/github/extensions/GithubAccountGitAuthenticationFailureManager;", "", "()V", "storeMap", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "", "", "ignoreAccount", "", "url", "account", "isAccountIgnored", "", "intellij.vcs.github"})
public final class GithubAccountGitAuthenticationFailureManager {
    private final ConcurrentHashMap<GithubAccount, Set<String>> storeMap = new ConcurrentHashMap();

    public final void ignoreAccount(@NotNull String url, @NotNull GithubAccount account) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)account, (String)"account");
        this.storeMap.compute(account, (BiFunction<GithubAccount, Set<String>, Set<String>>)new BiFunction<GithubAccount, Set<? extends String>, Set<? extends String>>(url){
            final /* synthetic */ String $url;

            @NotNull
            public final Set<String> apply(@NotNull GithubAccount $noName_0, @Nullable Set<String> current) {
                Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                Set set = current;
                if (set == null || (set = SetsKt.plus(set, (Object)this.$url)) == null) {
                    set = SetsKt.setOf((Object)this.$url);
                }
                return set;
            }
            {
                this.$url = string;
            }
        });
    }

    public final boolean isAccountIgnored(@NotNull String url, @NotNull GithubAccount account) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)account, (String)"account");
        Set<String> set = this.storeMap.get(account);
        return set != null ? set.contains(url) : false;
    }

    public GithubAccountGitAuthenticationFailureManager() {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        application.getMessageBus().connect().subscribe(GithubAccountManager.Companion.getACCOUNT_TOKEN_CHANGED_TOPIC(), (Object)new AccountTokenChangedListener(){

            @Override
            public void tokenChanged(@NotNull GithubAccount account) {
                Intrinsics.checkParameterIsNotNull((Object)account, (String)"account");
                storeMap.remove(account);
            }
        });
    }
}

