/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class PropertiesFilesManager
implements ProjectComponent {
    private final Project myProject;

    public static PropertiesFilesManager getInstance(Project project) {
        return (PropertiesFilesManager)project.getComponent(PropertiesFilesManager.class);
    }

    public PropertiesFilesManager(Project project) {
        this.myProject = project;
    }

    public void projectOpened() {
        PropertyChangeListener myListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("native2ascii".equals(propertyName) || "propertiesFilesEncoding".equals(propertyName)) {
                    DumbService.getInstance((Project)PropertiesFilesManager.this.myProject).smartInvokeLater(() -> ApplicationManager.getApplication().runWriteAction(() -> {
                        Collection filesToRefresh = FileTypeIndex.getFiles((FileType)PropertiesFileType.INSTANCE, (GlobalSearchScope)GlobalSearchScope.allScope((Project)PropertiesFilesManager.this.myProject));
                        VirtualFile[] virtualFiles = VfsUtilCore.toVirtualFileArray((Collection)filesToRefresh);
                        FileDocumentManager.getInstance().saveAllDocuments();
                        for (VirtualFile virtualFile : virtualFiles) {
                            virtualFile.setCharset(null);
                        }
                        FileDocumentManager.getInstance().reloadFiles(virtualFiles);
                    }));
                }
            }
        };
        EncodingManager.getInstance().addPropertyChangeListener(myListener, (Disposable)this.myProject);
    }

    @NotNull
    public String getComponentName() {
        if ("PropertiesFileManager" == null) {
            PropertiesFilesManager.$$$reportNull$$$0(0);
        }
        return "PropertiesFileManager";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/PropertiesFilesManager", "getComponentName"));
    }
}

