/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.math.BigInteger;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.flavours.MarkdownFlavourDescriptor;
import org.intellij.markdown.html.HtmlGenerator;
import org.intellij.markdown.parser.LinkMap;
import org.intellij.markdown.parser.MarkdownParser;
import org.intellij.plugins.markdown.lang.parser.MarkdownParserManager;
import org.intellij.plugins.markdown.ui.preview.IntelliJImageGeneratingProvider;
import org.intellij.plugins.markdown.ui.preview.MarkdownCodeFencePluginCache;
import org.intellij.plugins.markdown.ui.preview.MarkdownCodeFencePluginCacheCollector;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkdownUtil {
    private static final Logger LOG = Logger.getInstance(MarkdownUtil.class);

    public static String md5(String buffer, @NonNls String key) {
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("Cannot find 'md5' algorithm; ", (Throwable)e);
        }
        Objects.requireNonNull(md5).update(buffer.getBytes(StandardCharsets.UTF_8));
        byte[] code = md5.digest(key.getBytes(StandardCharsets.UTF_8));
        BigInteger bi = new BigInteger(code).abs();
        return bi.abs().toString(16);
    }

    @NotNull
    public static String generateMarkdownHtml(@NotNull VirtualFile file, @NotNull String text, @Nullable Project project) {
        VirtualFile parent;
        if (file == null) {
            MarkdownUtil.$$$reportNull$$$0(0);
        }
        if (text == null) {
            MarkdownUtil.$$$reportNull$$$0(1);
        }
        URI baseUri = (parent = file.getParent()) != null ? new File(parent.getPath()).toURI() : null;
        ASTNode parsedTree = new MarkdownParser((MarkdownFlavourDescriptor)MarkdownParserManager.FLAVOUR).buildMarkdownTreeFromString(text);
        MarkdownCodeFencePluginCacheCollector cacheCollector = new MarkdownCodeFencePluginCacheCollector(file);
        LinkMap linkMap = LinkMap.Builder.buildLinkMap(parsedTree, (CharSequence)text);
        HashMap map = ContainerUtil.newHashMap(MarkdownParserManager.FLAVOUR.createHtmlGeneratingProviders(linkMap, baseUri));
        map.putAll(MarkdownParserManager.CODE_FENCE_PLUGIN_FLAVOUR.createHtmlGeneratingProviders(cacheCollector));
        if (project != null) {
            map.put(MarkdownElementTypes.IMAGE, new IntelliJImageGeneratingProvider(linkMap, baseUri, project));
        }
        String html = new HtmlGenerator(text, parsedTree, (Map)map, true).generateHtml();
        MarkdownCodeFencePluginCache.getInstance().registerCacheProvider(cacheCollector);
        String string = html;
        if (string == null) {
            MarkdownUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/markdown/ui/preview/MarkdownUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/markdown/ui/preview/MarkdownUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "generateMarkdownHtml";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generateMarkdownHtml";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

