/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.actions;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.actions.cvsContext.CvsContext;
import com.intellij.cvsSupport2.actions.cvsContext.CvsContextWrapper;
import com.intellij.cvsSupport2.application.CvsEntriesManager;
import com.intellij.cvsSupport2.connections.CvsConnectionSettings;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class ToggleOfflineAction
extends ToggleAction
implements DumbAware {
    public boolean isSelected(@NotNull AnActionEvent e) {
        VirtualFile firstDirInChain;
        CvsContext cvsContext;
        if (e == null) {
            ToggleOfflineAction.$$$reportNull$$$0(0);
        }
        if (!(cvsContext = CvsContextWrapper.createInstance(e)).cvsIsActive()) {
            return false;
        }
        VirtualFile root = cvsContext.getSelectedFile();
        if (root == null) {
            return false;
        }
        VirtualFile virtualFile = firstDirInChain = root.isDirectory() ? root : root.getParent();
        if (firstDirInChain == null) {
            return false;
        }
        CvsConnectionSettings settings = CvsEntriesManager.getInstance().getCvsConnectionSettingsFor(firstDirInChain);
        if (settings == null) {
            return false;
        }
        return settings.isOffline();
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        VirtualFile firstDirInChain;
        if (e == null) {
            ToggleOfflineAction.$$$reportNull$$$0(1);
        }
        CvsContext cvsContext = CvsContextWrapper.createInstance(e);
        CvsEntriesManager entriesManager = CvsEntriesManager.getInstance();
        VirtualFile file = cvsContext.getSelectedFile();
        if (file == null) {
            return;
        }
        VirtualFile virtualFile = firstDirInChain = file.isDirectory() ? file : file.getParent();
        if (firstDirInChain == null) {
            return;
        }
        CvsConnectionSettings settings = entriesManager.getCvsConnectionSettingsFor(firstDirInChain);
        if (!settings.isValid()) {
            entriesManager.clearCachedEntriesFor(firstDirInChain);
            settings = entriesManager.getCvsConnectionSettingsFor(firstDirInChain);
        }
        if (settings != null && settings.isValid() && state != settings.isOffline()) {
            VcsBalloonProblemNotifier.showOverChangesView((Project)cvsContext.getProject(), (String)(state ? CvsBundle.message((String)"set.offline.notification.text", (Object[])new Object[0]) : CvsBundle.message((String)"set.online.notification.text", (Object[])new Object[0])), (MessageType)(state ? MessageType.WARNING : MessageType.INFO), (NamedRunnable[])new NamedRunnable[0]);
            settings.setOffline(state);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ToggleOfflineAction.$$$reportNull$$$0(2);
        }
        super.update(e);
        CvsContext cvsContext = CvsContextWrapper.createInstance(e);
        VirtualFile[] files = cvsContext.getSelectedFiles();
        e.getPresentation().setVisible(files != null && files.length > 0 && cvsContext.cvsIsActive());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/cvsSupport2/actions/ToggleOfflineAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isSelected";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setSelected";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

