/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ipnb.editor.panels;

import com.google.common.collect.Lists;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.CutProvider;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.PasteProvider;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.ui.JBColor;
import com.intellij.ui.KeyStrokeAdapter;
import com.intellij.util.Alarm;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.Scrollable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ipnb.editor.IpnbEditorUtil;
import org.jetbrains.plugins.ipnb.editor.IpnbFileEditor;
import org.jetbrains.plugins.ipnb.editor.actions.IpnbToggleLineNumbersAction;
import org.jetbrains.plugins.ipnb.editor.panels.IpnbEditablePanel;
import org.jetbrains.plugins.ipnb.editor.panels.IpnbHeadingPanel;
import org.jetbrains.plugins.ipnb.editor.panels.IpnbMarkdownPanel;
import org.jetbrains.plugins.ipnb.editor.panels.code.IpnbCodePanel;
import org.jetbrains.plugins.ipnb.format.IpnbFile;
import org.jetbrains.plugins.ipnb.format.IpnbParser;
import org.jetbrains.plugins.ipnb.format.cells.IpnbCell;
import org.jetbrains.plugins.ipnb.format.cells.IpnbCodeCell;
import org.jetbrains.plugins.ipnb.format.cells.IpnbEditableCell;
import org.jetbrains.plugins.ipnb.format.cells.IpnbHeadingCell;
import org.jetbrains.plugins.ipnb.format.cells.IpnbMarkdownCell;
import org.jetbrains.plugins.ipnb.format.cells.IpnbRawCell;
import org.jetbrains.plugins.ipnb.psi.IpnbPyLanguageDialect;

public class IpnbFilePanel
extends JPanel
implements Scrollable,
DataProvider,
Disposable {
    private static final Logger LOG = Logger.getInstance(IpnbFilePanel.class);
    public static final Topic<EditingModeChangeListener> TOPIC = Topic.create((String)"IPNB.EditingMode", EditingModeChangeListener.class);
    private final DocumentListener myDocumentListener;
    private final Document myDocument;
    private final MessageBusConnection myBusConnection;
    private final EditActionsProvider myEditable;
    private IpnbFile myIpnbFile;
    private final Project myProject;
    @NotNull
    private final IpnbFileEditor myParent;
    @NotNull
    private final VirtualFile myVirtualFile;
    @NotNull
    private final IpnbFileEditor.CellSelectionListener myListener;
    private final List<IpnbEditablePanel> myIpnbPanels;
    @Nullable
    private IpnbEditablePanel mySelectedCellPanel;
    private int mySelectedIndex;
    private IpnbEditablePanel myBufferPanel;
    private int myInitialSelection;
    private boolean mySynchronize;
    private static final String ourHelpID = "IPython_Notebook_Support";

    public IpnbFilePanel(@NotNull Project project, @NotNull IpnbFileEditor parent, @NotNull VirtualFile vFile, @NotNull IpnbFileEditor.CellSelectionListener listener) {
        if (project == null) {
            IpnbFilePanel.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            IpnbFilePanel.$$$reportNull$$$0(1);
        }
        if (vFile == null) {
            IpnbFilePanel.$$$reportNull$$$0(2);
        }
        if (listener == null) {
            IpnbFilePanel.$$$reportNull$$$0(3);
        }
        super((LayoutManager)new VerticalFlowLayout(0, 100, 5, true, false));
        this.myIpnbPanels = Lists.newArrayList();
        this.myInitialSelection = 0;
        this.myProject = project;
        this.myParent = parent;
        this.myVirtualFile = vFile;
        this.myListener = listener;
        this.myEditable = new EditActionsProvider();
        this.setBackground(IpnbEditorUtil.getBackground());
        this.addKeyListener((KeyListener)new KeyStrokeAdapter(){

            public void keyPressed(KeyEvent event) {
                super.keyPressed(event);
            }
        });
        final Alarm alarm = new Alarm();
        this.myDocumentListener = new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (IpnbFilePanel.this.mySynchronize) {
                    alarm.cancelAllRequests();
                    alarm.addRequest((Runnable)new MySynchronizeRequest(), 10, ModalityState.stateForComponent((Component)IpnbFilePanel.this));
                }
                IpnbFilePanel.this.mySynchronize = true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/ipnb/editor/panels/IpnbFilePanel$2", "documentChanged"));
            }
        };
        this.myDocument = this.myParent.getDocument();
        this.myDocument.addDocumentListener(this.myDocumentListener);
        alarm.addRequest(() -> {
            this.readFromFile(true);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    IpnbFilePanel.this.updateCellSelection(e);
                }
            });
            this.setFocusable(true);
        }, 10, ModalityState.stateForComponent((Component)this));
        this.myParent.loaded();
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this, true));
        this.myBusConnection = ApplicationManager.getApplication().getMessageBus().connect();
        this.myBusConnection.subscribe(ProjectEx.ProjectSaved.TOPIC, (Object)new ProjectEx.ProjectSaved(){

            public void saved(@NotNull Project project) {
                if (project == null) {
                    4.$$$reportNull$$$0(0);
                }
                IpnbFilePanel.this.executeSaveFileCommand();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/ipnb/editor/panels/IpnbFilePanel$4", "saved"));
            }
        });
        this.myBusConnection.subscribe(TOPIC, (wasInEditing, isEditing) -> {
            if (wasInEditing && !isEditing) {
                this.executeSaveFileCommand();
            }
        });
    }

    public void executeSaveFileCommand() {
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> ApplicationManager.getApplication().runWriteAction(() -> this.saveToFile(false)), "Save File", new Object(), UndoConfirmationPolicy.DEFAULT, false);
    }

    public void dispose() {
        this.myDocument.removeDocumentListener(this.myDocumentListener);
        Disposer.dispose((Disposable)this.myBusConnection);
        for (IpnbEditablePanel panel : this.myIpnbPanels) {
            panel.dispose();
        }
        this.myIpnbPanels.clear();
        this.myIpnbFile = null;
        this.mySelectedCellPanel = null;
        this.myBufferPanel = null;
        this.removeAll();
    }

    private void readFromFile(boolean showError) {
        try {
            this.removeAll();
            this.myIpnbFile = IpnbParser.parseIpnbFile(this.myDocument, this.myVirtualFile);
            this.myIpnbPanels.clear();
            this.mySelectedCellPanel = null;
            this.mySelectedIndex = -1;
            if (this.myIpnbFile.getCells().isEmpty()) {
                CommandProcessor.getInstance().runUndoTransparentAction(() -> ApplicationManager.getApplication().runWriteAction(() -> {
                    this.createAndAddCell(true, IpnbCodeCell.createEmptyCodeCell());
                    this.saveToFile(true);
                    this.setInitialPosition(0);
                }));
            }
        }
        catch (IOException e) {
            if (showError) {
                Messages.showErrorDialog((Project)this.getProject(), (String)e.getMessage(), (String)("Can't open " + this.myVirtualFile.getPath()));
            }
            LOG.error(e.getMessage(), new String[]{"Can't open " + this.myVirtualFile.getPath()});
        }
        this.layoutFile();
    }

    public List<IpnbEditablePanel> getIpnbPanels() {
        return this.myIpnbPanels;
    }

    private void layoutFile() {
        List<IpnbCell> cells = this.myIpnbFile.getCells();
        for (IpnbCell cell : cells) {
            this.addCellToPanel(cell);
        }
        if (this.myInitialSelection >= 0 && this.myIpnbPanels.size() > this.myInitialSelection) {
            IpnbEditablePanel toSelect = this.myIpnbPanels.get(this.myInitialSelection);
            this.setSelectedCellPanel(toSelect);
        }
        this.add(IpnbFilePanel.createEmptyPanel());
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.mySelectedCellPanel != null) {
                this.myParent.updateScrollPosition(this.mySelectedCellPanel);
            }
        });
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this, true));
    }

    private void addCellToPanel(IpnbCell cell) {
        if (cell instanceof IpnbCodeCell) {
            IpnbCodePanel panel = new IpnbCodePanel(this.myProject, this.myParent, (IpnbCodeCell)cell);
            this.addComponent(panel);
        } else if (cell instanceof IpnbMarkdownCell) {
            IpnbMarkdownPanel panel = new IpnbMarkdownPanel((IpnbMarkdownCell)cell, this);
            this.addComponent(panel);
        } else if (cell instanceof IpnbHeadingCell) {
            IpnbHeadingPanel panel = new IpnbHeadingPanel((IpnbHeadingCell)cell);
            this.addComponent(panel);
        } else if (!(cell instanceof IpnbRawCell)) {
            throw new UnsupportedOperationException(cell.getClass().toString());
        }
    }

    public void createAndAddCell(boolean below, IpnbCodeCell cell) {
        IpnbCodePanel codePanel = new IpnbCodePanel(this.myProject, this.myParent, cell);
        this.addCell(codePanel, below);
    }

    private void addCell(@NotNull IpnbEditablePanel panel, boolean below) {
        if (panel == null) {
            IpnbFilePanel.$$$reportNull$$$0(4);
        }
        IpnbEditablePanel selectedCellPanel = this.getSelectedCellPanel();
        int index = this.myIpnbPanels.indexOf(selectedCellPanel);
        if (below) {
            ++index;
        }
        IpnbCell cell = panel.getCell();
        this.myIpnbFile.addCell(cell, index);
        this.myIpnbPanels.add(index, panel);
        this.add((Component)panel, index);
        this.setSelectedCellPanel(panel);
    }

    public void cutCell() {
        this.myBufferPanel = this.getSelectedCellPanel();
        if (this.myBufferPanel == null) {
            return;
        }
        this.deleteSelectedCell();
    }

    public void moveCell(boolean down) {
        int siblingIndex;
        IpnbEditablePanel selectedCellPanel = this.getSelectedCellPanel();
        if (selectedCellPanel == null) {
            return;
        }
        int index = this.getSelectedIndex();
        int n = siblingIndex = down ? index + 1 : index - 1;
        if (this.myIpnbPanels.size() <= siblingIndex && down) {
            return;
        }
        if (siblingIndex < 0 && !down) {
            return;
        }
        if (down) {
            IpnbCell cell = selectedCellPanel.getCell();
            this.deleteSelectedCell();
            this.myIpnbFile.addCell(cell, index + 1);
            this.myIpnbPanels.add(index + 1, selectedCellPanel);
            this.add((Component)selectedCellPanel, index + 1);
            this.selectPrev(selectedCellPanel);
            this.setSelectedCellPanel(selectedCellPanel);
        } else {
            IpnbEditablePanel siblingPanel = this.myIpnbPanels.get(siblingIndex);
            this.deleteCell(siblingPanel);
            this.addCell(siblingPanel, true);
            this.setSelectedCellPanel(selectedCellPanel);
        }
        this.saveToFile(false);
    }

    public void mergeCell(boolean below) {
        IpnbEditablePanel currentCellPanel = this.getSelectedCellPanel();
        if (currentCellPanel == null) {
            return;
        }
        if (below) {
            this.selectNext(currentCellPanel, false);
        } else {
            this.selectPrev(currentCellPanel);
        }
        IpnbEditablePanel cellToMergePanel = this.getSelectedCellPanel();
        IpnbCell cellToMerge = cellToMergePanel.getCell();
        List<String> currentCellSource = IpnbFilePanel.getCellSource(currentCellPanel);
        List<String> cellToMergeSource = ((IpnbEditableCell)cellToMerge).getSource();
        ArrayList<String> source = IpnbFilePanel.mergeCellsSource(currentCellSource, cellToMergeSource, below);
        ((IpnbEditableCell)cellToMerge).setSource(source);
        cellToMergePanel.updateCellView();
        IpnbFilePanel.actualizeCellData(cellToMerge);
        currentCellPanel.repaint();
        this.deleteCell(currentCellPanel);
        this.saveToFile(false);
    }

    private static ArrayList<String> mergeCellsSource(@NotNull List<String> currentCellSource, @NotNull List<String> cellToMergeSource, boolean below) {
        if (currentCellSource == null) {
            IpnbFilePanel.$$$reportNull$$$0(5);
        }
        if (cellToMergeSource == null) {
            IpnbFilePanel.$$$reportNull$$$0(6);
        }
        ArrayList<String> source = new ArrayList<String>();
        if (below) {
            source.addAll(currentCellSource);
            source.add("\n");
            source.addAll(cellToMergeSource);
        } else {
            source.addAll(cellToMergeSource);
            source.add("\n");
            source.addAll(currentCellSource);
        }
        return source;
    }

    private static void actualizeCellData(@NotNull IpnbCell cell) {
        if (cell == null) {
            IpnbFilePanel.$$$reportNull$$$0(7);
        }
        if (cell instanceof IpnbCodeCell) {
            ((IpnbCodeCell)cell).removeCellOutputs();
            ((IpnbCodeCell)cell).setPromptNumber(null);
        }
    }

    public void splitCell() {
        IpnbEditablePanel selectedCellPanel = this.getSelectedCellPanel();
        if (selectedCellPanel == null) {
            return;
        }
        IpnbCell cell = selectedCellPanel.getCell();
        int position = selectedCellPanel.getCaretPosition();
        if (position == -1) {
            return;
        }
        String oldCellText = selectedCellPanel.getText(0, position);
        String newCellText = selectedCellPanel.getText(position);
        if (oldCellText != null) {
            JTextArea editablePanel = selectedCellPanel.getEditableTextArea();
            if (editablePanel != null) {
                editablePanel.setText(oldCellText);
            }
            ((IpnbEditableCell)selectedCellPanel.getCell()).setSource(IpnbFilePanel.createCellSourceFromText(oldCellText));
            IpnbFilePanel.actualizeCellData(cell);
            selectedCellPanel.updateCellView();
        }
        ArrayList<String> newCellSource = IpnbFilePanel.createCellSourceFromText(newCellText);
        IpnbEditablePanel panel = this.createPanel((IpnbEditableCell)cell, newCellSource);
        this.addCell(panel, true);
        this.saveToFile(false);
    }

    @NotNull
    private IpnbEditablePanel createPanel(@NotNull IpnbEditableCell cell, @NotNull ArrayList<String> newCellSource) {
        if (cell == null) {
            IpnbFilePanel.$$$reportNull$$$0(8);
        }
        if (newCellSource == null) {
            IpnbFilePanel.$$$reportNull$$$0(9);
        }
        if (cell instanceof IpnbCodeCell) {
            IpnbCodeCell codeCell = (IpnbCodeCell)cell;
            IpnbCodeCell ipnbCodeCell = new IpnbCodeCell(codeCell.getLanguage(), newCellSource, codeCell.getPromptNumber(), codeCell.getCellOutputs(), codeCell.getMetadata());
            IpnbCodePanel ipnbCodePanel = new IpnbCodePanel(this.myProject, this.myParent, ipnbCodeCell);
            if (ipnbCodePanel == null) {
                IpnbFilePanel.$$$reportNull$$$0(10);
            }
            return ipnbCodePanel;
        }
        if (cell instanceof IpnbMarkdownCell) {
            IpnbMarkdownCell markdownCell = new IpnbMarkdownCell(newCellSource, cell.getMetadata());
            IpnbMarkdownPanel ipnbMarkdownPanel = new IpnbMarkdownPanel(markdownCell, this);
            if (ipnbMarkdownPanel == null) {
                IpnbFilePanel.$$$reportNull$$$0(11);
            }
            return ipnbMarkdownPanel;
        }
        IpnbHeadingCell headingCell = new IpnbHeadingCell(newCellSource, ((IpnbHeadingCell)cell).getLevel(), cell.getMetadata());
        IpnbHeadingPanel ipnbHeadingPanel = new IpnbHeadingPanel(headingCell);
        if (ipnbHeadingPanel == null) {
            IpnbFilePanel.$$$reportNull$$$0(12);
        }
        return ipnbHeadingPanel;
    }

    private static ArrayList<String> createCellSourceFromText(@NotNull String oldCellText) {
        if (oldCellText == null) {
            IpnbFilePanel.$$$reportNull$$$0(13);
        }
        return Arrays.stream(oldCellText.split("\n")).map(s -> s + "\n").collect(Collectors.toCollection(ArrayList::new));
    }

    @NotNull
    private static List<String> getCellSource(@NotNull IpnbEditablePanel cellPanel) {
        if (cellPanel == null) {
            IpnbFilePanel.$$$reportNull$$$0(14);
        }
        IpnbCell cell = cellPanel.getCell();
        List<String> list = ((IpnbEditableCell)cell).getSource();
        if (list == null) {
            IpnbFilePanel.$$$reportNull$$$0(15);
        }
        return list;
    }

    public void deleteSelectedCell() {
        IpnbEditablePanel selectedCellPanel = this.getSelectedCellPanel();
        if (selectedCellPanel != null) {
            this.deleteCell(selectedCellPanel);
        }
    }

    public void deleteCell(@NotNull IpnbEditablePanel cell) {
        int index;
        if (cell == null) {
            IpnbFilePanel.$$$reportNull$$$0(16);
        }
        if ((index = this.myIpnbPanels.indexOf(cell)) < 0) {
            return;
        }
        this.myIpnbPanels.remove(index);
        this.myIpnbFile.removeCell(index);
        this.remove(index);
        if (this.myIpnbPanels.isEmpty()) {
            this.createAndAddCell(true, IpnbCodeCell.createEmptyCodeCell());
            this.setSelectedCell(this.myIpnbPanels.get(0), false);
        } else {
            int indexToSelect = index < this.myIpnbPanels.size() ? index : index - 1;
            IpnbEditablePanel panel = this.myIpnbPanels.get(indexToSelect);
            this.setSelectedCell(panel, false);
        }
    }

    public void saveToFile(boolean synchronize) {
        this.mySynchronize = synchronize;
        String oldText = this.myDocument.getText();
        String newText = IpnbParser.newDocumentText(this);
        if (newText == null) {
            return;
        }
        if (oldText.equals(newText) && this.mySynchronize) {
            new Alarm().addRequest((Runnable)new MySynchronizeRequest(), 10, ModalityState.stateForComponent((Component)this));
            this.mySynchronize = false;
            return;
        }
        try {
            ReplaceInfo replaceInfo = IpnbFilePanel.findFragmentToChange(oldText, newText);
            if (replaceInfo.getStartOffset() != -1) {
                this.myDocument.replaceString(replaceInfo.getStartOffset(), replaceInfo.getEndOffset(), (CharSequence)replaceInfo.getReplacement());
            }
        }
        catch (Exception e) {
            this.myDocument.replaceString(0, oldText.length(), (CharSequence)newText);
        }
    }

    public static ReplaceInfo findFragmentToChange(@NotNull String oldText, @NotNull String newText) {
        char c2;
        char c1;
        int idxInNew;
        int endOffset;
        int startOffset;
        if (oldText == null) {
            IpnbFilePanel.$$$reportNull$$$0(17);
        }
        if (newText == null) {
            IpnbFilePanel.$$$reportNull$$$0(18);
        }
        if (oldText.equals(newText)) {
            return new ReplaceInfo(-1, -1, null);
        }
        int oldLength = oldText.length();
        int newLength = newText.length();
        for (startOffset = 0; startOffset < oldLength && startOffset < newLength && oldText.charAt(startOffset) == newText.charAt(startOffset); ++startOffset) {
        }
        for (endOffset = oldLength; endOffset > startOffset && (idxInNew = newLength - (oldLength - endOffset) - 1) >= startOffset && (c1 = oldText.charAt(endOffset - 1)) == (c2 = newText.charAt(idxInNew)); --endOffset) {
        }
        return new ReplaceInfo(startOffset, endOffset, newText.substring(startOffset, newLength - (oldLength - endOffset)));
    }

    public void copyCell() {
        this.myBufferPanel = this.getSelectedCellPanel();
    }

    public void pasteCell() {
        if (this.myBufferPanel == null) {
            return;
        }
        IpnbEditablePanel editablePanel = (IpnbEditablePanel)this.myBufferPanel.clone();
        this.addCell(editablePanel, true);
    }

    public void replaceComponent(@NotNull IpnbEditablePanel from, @NotNull IpnbCell cell) {
        if (from == null) {
            IpnbFilePanel.$$$reportNull$$$0(19);
        }
        if (cell == null) {
            IpnbFilePanel.$$$reportNull$$$0(20);
        }
        CommandProcessor.getInstance().executeCommand(this.getProject(), () -> {
            if (from == null) {
                IpnbFilePanel.$$$reportNull$$$0(35);
            }
            if (cell == null) {
                IpnbFilePanel.$$$reportNull$$$0(36);
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                IpnbEditablePanel panel;
                if (from == null) {
                    IpnbFilePanel.$$$reportNull$$$0(37);
                }
                if (cell == null) {
                    IpnbFilePanel.$$$reportNull$$$0(38);
                }
                int index = this.myIpnbPanels.indexOf(from);
                if (cell instanceof IpnbCodeCell) {
                    panel = new IpnbCodePanel(this.myProject, this.myParent, (IpnbCodeCell)cell);
                } else if (cell instanceof IpnbMarkdownCell) {
                    panel = new IpnbMarkdownPanel((IpnbMarkdownCell)cell, this.myParent.getIpnbFilePanel());
                } else if (cell instanceof IpnbHeadingCell) {
                    panel = new IpnbHeadingPanel((IpnbHeadingCell)cell);
                } else {
                    throw new UnsupportedOperationException(cell.getClass().toString());
                }
                if (index >= 0) {
                    this.myIpnbFile.removeCell(index);
                    this.myIpnbPanels.remove(index);
                    this.remove(index);
                    this.myIpnbFile.addCell(cell, index);
                    this.myIpnbPanels.add(index, panel);
                    this.add((Component)panel, index);
                }
                if (from instanceof IpnbCodePanel) {
                    panel.switchToEditing();
                }
                this.setSelectedCellPanel(panel);
                this.saveToFile(false);
            });
        }, "Ipnb.changeCellType", new Object());
    }

    private void addComponent(@NotNull IpnbEditablePanel comp) {
        if (comp == null) {
            IpnbFilePanel.$$$reportNull$$$0(21);
        }
        this.add(comp);
        this.myIpnbPanels.add(comp);
    }

    private static JPanel createEmptyPanel() {
        JPanel panel = new JPanel();
        panel.setBackground(IpnbEditorUtil.getBackground());
        return panel;
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        this.processKeyPressed(e);
    }

    public void processKeyPressed(KeyEvent e) {
        if (this.mySelectedCellPanel != null && e.getID() == 401) {
            if (e.getKeyCode() == 10) {
                this.mySelectedCellPanel.switchToEditing();
            }
            if (e.getKeyCode() == 38) {
                this.selectPrev(this.mySelectedCellPanel);
            } else if (e.getKeyCode() == 40) {
                this.selectNext(this.mySelectedCellPanel, false);
            } else if (e.getKeyCode() == 76) {
                if (this.mySelectedCellPanel instanceof IpnbCodePanel && !this.mySelectedCellPanel.isEditing()) {
                    IpnbToggleLineNumbersAction.toggleLineNumbers((IpnbCodePanel)this.mySelectedCellPanel);
                }
            } else {
                this.getParent().dispatchEvent(e);
            }
        }
    }

    public boolean hasNextCell(@NotNull IpnbEditablePanel cell) {
        int index;
        if (cell == null) {
            IpnbFilePanel.$$$reportNull$$$0(22);
        }
        return (index = this.myIpnbPanels.indexOf(cell)) < this.myIpnbPanels.size() - 1;
    }

    public boolean hasPrevCell(@NotNull IpnbEditablePanel cell) {
        int index;
        if (cell == null) {
            IpnbFilePanel.$$$reportNull$$$0(23);
        }
        return (index = this.myIpnbPanels.indexOf(cell)) > 0;
    }

    public void selectPrev(@NotNull IpnbEditablePanel cell) {
        int index;
        if (cell == null) {
            IpnbFilePanel.$$$reportNull$$$0(24);
        }
        if ((index = this.myIpnbPanels.indexOf(cell)) > 0) {
            this.setSelectedCellPanel(this.myIpnbPanels.get(index - 1));
        }
    }

    public void selectNext(@NotNull IpnbEditablePanel cell, boolean addNew) {
        int index;
        if (cell == null) {
            IpnbFilePanel.$$$reportNull$$$0(25);
        }
        if ((index = this.myIpnbPanels.indexOf(cell)) < this.myIpnbPanels.size() - 1) {
            this.setSelectedCellPanel(this.myIpnbPanels.get(index + 1));
        } else if (addNew) {
            this.createAndAddCell(true, IpnbCodeCell.createEmptyCodeCell());
            CommandProcessor.getInstance().executeCommand(this.getProject(), () -> ApplicationManager.getApplication().runWriteAction(() -> this.saveToFile(false)), "Ipnb.runCell", new Object());
        }
    }

    public void selectNextOrPrev(@NotNull IpnbEditablePanel cell) {
        int index;
        if (cell == null) {
            IpnbFilePanel.$$$reportNull$$$0(26);
        }
        if ((index = this.myIpnbPanels.indexOf(cell)) < this.myIpnbPanels.size() - 1) {
            this.setSelectedCellPanel(this.myIpnbPanels.get(index + 1));
        } else if (index > 0) {
            this.setSelectedCellPanel(this.myIpnbPanels.get(index - 1));
        } else {
            this.mySelectedCellPanel = null;
            this.mySelectedIndex = -1;
        }
    }

    private void updateCellSelection(MouseEvent e) {
        IpnbEditablePanel ipnbPanel;
        if ((e.getClickCount() == 1 || e.getClickCount() == 2) && (ipnbPanel = this.getIpnbPanelByClick(e.getPoint())) != null) {
            ipnbPanel.setEditing(false);
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this, true));
            this.setSelectedCell(ipnbPanel, true);
        }
    }

    public void setInitialPosition(int index) {
        this.myInitialSelection = index;
    }

    public void setSelectedCellPanel(@NotNull IpnbEditablePanel ipnbPanel) {
        if (ipnbPanel == null) {
            IpnbFilePanel.$$$reportNull$$$0(27);
        }
        this.setSelectedCell(ipnbPanel, false);
    }

    public void setSelectedCell(@NotNull IpnbEditablePanel ipnbPanel, boolean mouse) {
        if (ipnbPanel == null) {
            IpnbFilePanel.$$$reportNull$$$0(28);
        }
        if (ipnbPanel.equals(this.mySelectedCellPanel)) {
            return;
        }
        if (this.mySelectedCellPanel != null) {
            this.mySelectedCellPanel.setEditing(false);
            this.mySelectedCellPanel.setBorder(BorderFactory.createLineBorder(IpnbEditorUtil.getBackground()));
        }
        ipnbPanel.setBorder(BorderFactory.createLineBorder((Color)(ipnbPanel.isEditing() ? JBColor.GREEN : JBColor.GRAY)));
        this.mySelectedCellPanel = ipnbPanel;
        this.mySelectedIndex = this.myIpnbPanels.indexOf(ipnbPanel);
        if (ipnbPanel.getBounds().getHeight() != 0.0) {
            this.myListener.selectionChanged(ipnbPanel, mouse);
        }
    }

    @Nullable
    public IpnbEditablePanel getSelectedCellPanel() {
        return this.mySelectedCellPanel;
    }

    public int getSelectedIndex() {
        return this.mySelectedIndex == -1 ? this.myInitialSelection : this.mySelectedIndex;
    }

    @Nullable
    private IpnbEditablePanel getIpnbPanelByClick(@NotNull Point point) {
        if (point == null) {
            IpnbFilePanel.$$$reportNull$$$0(29);
        }
        for (IpnbEditablePanel c : this.myIpnbPanels) {
            if (!c.contains(point.y)) continue;
            return c;
        }
        return null;
    }

    public IpnbFile getIpnbFile() {
        return this.myIpnbFile;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return null;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 10;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 100;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            IpnbFilePanel.$$$reportNull$$$0(30);
        }
        IpnbEditablePanel selectedCellPanel = this.getSelectedCellPanel();
        if (OpenFileDescriptor.NAVIGATE_IN_EDITOR.is(dataId) && selectedCellPanel instanceof IpnbCodePanel) {
            return ((IpnbCodePanel)selectedCellPanel).getEditor();
        }
        if (IpnbFileEditor.DATA_KEY.is(dataId)) {
            return this.myParent;
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return ourHelpID;
        }
        if (LangDataKeys.CONTEXT_LANGUAGES.is(dataId)) {
            return new Language[]{IpnbPyLanguageDialect.getInstance()};
        }
        if ((CommonDataKeys.PSI_ELEMENT.is(dataId) || CommonDataKeys.PSI_FILE.is(dataId)) && selectedCellPanel instanceof IpnbCodePanel) {
            Editor e = ((IpnbCodePanel)selectedCellPanel).getEditor();
            Object o = FileEditorManager.getInstance((Project)this.myProject).getData(dataId, e, e.getCaretModel().getCurrentCaret());
            if (o != null) {
                return o;
            }
        }
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId) || PlatformDataKeys.PASTE_PROVIDER.is(dataId) || PlatformDataKeys.CUT_PROVIDER.is(dataId) || PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            return this.myEditable;
        }
        return null;
    }

    public void executeUndoableCommand(@NotNull Runnable action, @NotNull String name) {
        if (action == null) {
            IpnbFilePanel.$$$reportNull$$$0(31);
        }
        if (name == null) {
            IpnbFilePanel.$$$reportNull$$$0(32);
        }
        this.executeSaveFileCommand();
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
            if (action == null) {
                IpnbFilePanel.$$$reportNull$$$0(34);
            }
            ApplicationManager.getApplication().runWriteAction(action);
        }, name, new Object());
    }

    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.myVirtualFile;
        if (virtualFile == null) {
            IpnbFilePanel.$$$reportNull$$$0(33);
        }
        return virtualFile;
    }

    public Document getDocument() {
        return this.myDocument;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentCellSource";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cellToMergeSource";
                break;
            }
            case 7: 
            case 8: 
            case 16: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cell";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newCellSource";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ipnb/editor/panels/IpnbFilePanel";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldCellText";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cellPanel";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldText";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newText";
                break;
            }
            case 19: 
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comp";
                break;
            }
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ipnbPanel";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ipnb/editor/panels/IpnbFilePanel";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createPanel";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getCellSource";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addCell";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "mergeCellsSource";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "actualizeCellData";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createPanel";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 33: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createCellSourceFromText";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getCellSource";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "deleteCell";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findFragmentToChange";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "replaceComponent";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addComponent";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "hasNextCell";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "hasPrevCell";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "selectPrev";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "selectNext";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "selectNextOrPrev";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedCellPanel";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedCell";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getIpnbPanelByClick";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "executeUndoableCommand";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "lambda$executeUndoableCommand$15";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "lambda$replaceComponent$11";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$10";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    public static interface EditingModeChangeListener {
        public void modeChanged(boolean var1, boolean var2);
    }

    private class EditActionsProvider
    implements CutProvider,
    CopyProvider,
    PasteProvider,
    DeleteProvider,
    DumbAware {
        private EditActionsProvider() {
        }

        public void performCopy(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                EditActionsProvider.$$$reportNull$$$0(0);
            }
            IpnbFilePanel.this.executeSaveFileCommand();
            IpnbFilePanel.this.copyCell();
        }

        public boolean isCopyEnabled(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                EditActionsProvider.$$$reportNull$$$0(1);
            }
            return IpnbFilePanel.this.mySelectedCellPanel != null;
        }

        public boolean isCopyVisible(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                EditActionsProvider.$$$reportNull$$$0(2);
            }
            return IpnbFilePanel.this.mySelectedCellPanel != null;
        }

        public void deleteElement(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                EditActionsProvider.$$$reportNull$$$0(3);
            }
            IpnbFilePanel.this.executeUndoableCommand(() -> {
                IpnbFilePanel.this.deleteSelectedCell();
                IpnbFilePanel.this.saveToFile(false);
            }, "Delete Cell");
        }

        public boolean canDeleteElement(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                EditActionsProvider.$$$reportNull$$$0(4);
            }
            return IpnbFilePanel.this.mySelectedCellPanel != null && !IpnbFilePanel.this.mySelectedCellPanel.isEditing();
        }

        public void performPaste(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                EditActionsProvider.$$$reportNull$$$0(5);
            }
            IpnbFilePanel.this.executeUndoableCommand(() -> {
                IpnbFilePanel.this.pasteCell();
                IpnbFilePanel.this.saveToFile(false);
            }, "Paste Cell");
        }

        public boolean isPastePossible(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                EditActionsProvider.$$$reportNull$$$0(6);
            }
            return IpnbFilePanel.this.myBufferPanel != null;
        }

        public boolean isPasteEnabled(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                EditActionsProvider.$$$reportNull$$$0(7);
            }
            return IpnbFilePanel.this.myBufferPanel != null;
        }

        public void performCut(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                EditActionsProvider.$$$reportNull$$$0(8);
            }
            IpnbFilePanel.this.executeUndoableCommand(() -> {
                IpnbFilePanel.this.cutCell();
                IpnbFilePanel.this.saveToFile(false);
            }, "Cut Cell");
        }

        public boolean isCutEnabled(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                EditActionsProvider.$$$reportNull$$$0(9);
            }
            return IpnbFilePanel.this.mySelectedCellPanel != null;
        }

        public boolean isCutVisible(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                EditActionsProvider.$$$reportNull$$$0(10);
            }
            return IpnbFilePanel.this.mySelectedCellPanel != null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "dataContext";
            objectArray2[1] = "org/jetbrains/plugins/ipnb/editor/panels/IpnbFilePanel$EditActionsProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "performCopy";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isCopyEnabled";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isCopyVisible";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "deleteElement";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canDeleteElement";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "performPaste";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isPastePossible";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isPasteEnabled";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "performCut";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isCutEnabled";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isCutVisible";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MySynchronizeRequest
    implements Runnable {
        private MySynchronizeRequest() {
        }

        @Override
        public void run() {
            Project project = IpnbFilePanel.this.getProject();
            if (project.isDisposed()) {
                return;
            }
            if (Disposer.isDisposed((Disposable)IpnbFilePanel.this.myParent)) {
                return;
            }
            PsiDocumentManager.getInstance((Project)project).commitDocument(IpnbFilePanel.this.myDocument);
            IpnbEditablePanel selectedCellPanel = IpnbFilePanel.this.getSelectedCellPanel();
            int index = IpnbFilePanel.this.myIpnbPanels.indexOf(selectedCellPanel);
            IpnbFilePanel.this.myInitialSelection = index >= 0 && index < IpnbFilePanel.this.myIpnbPanels.size() ? index : IpnbFilePanel.this.myIpnbPanels.size() - 1;
            IpnbFilePanel.this.readFromFile(false);
        }
    }

    public static final class ReplaceInfo {
        private final int myStartOffset;
        private final int myEndOffset;
        private final String myReplacement;

        public ReplaceInfo(int startOffset, int endOffset, String replacement) {
            this.myStartOffset = startOffset;
            this.myEndOffset = endOffset;
            this.myReplacement = replacement;
        }

        public int getStartOffset() {
            return this.myStartOffset;
        }

        public int getEndOffset() {
            return this.myEndOffset;
        }

        public String getReplacement() {
            return this.myReplacement;
        }
    }
}

