/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.net;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.CountingGZIPInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NetUtils {
    private static final Logger LOG = Logger.getInstance(NetUtils.class);

    private NetUtils() {
    }

    public static boolean canConnectToSocket(String host, int port) {
        if (NetUtils.isLocalhost(host)) {
            return !NetUtils.canBindToLocalSocket(host, port);
        }
        return NetUtils.canConnectToRemoteSocket(host, port);
    }

    @Deprecated
    public static InetAddress getLoopbackAddress() {
        return InetAddress.getLoopbackAddress();
    }

    public static boolean isLocalhost(@NotNull String host) {
        if (host == null) {
            NetUtils.$$$reportNull$$$0(0);
        }
        return host.equalsIgnoreCase("localhost") || host.equals("127.0.0.1") || host.equals("::1");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean canBindToLocalSocket(String host, int port) {
        try (ServerSocket socket = new ServerSocket();){
            socket.bind(new InetSocketAddress(host, port));
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
            return false;
        }
    }

    public static boolean canConnectToRemoteSocket(String host, int port) {
        try {
            Socket socket = new Socket(host, port);
            socket.close();
            return true;
        }
        catch (IOException ignored) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int findAvailableSocketPort() throws IOException {
        try (ServerSocket serverSocket = new ServerSocket(0);){
            int port = serverSocket.getLocalPort();
            ServerSocket serverSocket2 = serverSocket;
            synchronized (serverSocket2) {
                try {
                    serverSocket.wait(1L);
                }
                catch (InterruptedException e) {
                    LOG.error((Throwable)e);
                }
            }
            int n = port;
            return n;
        }
    }

    public static int tryToFindAvailableSocketPort(int defaultPort) {
        try {
            return NetUtils.findAvailableSocketPort();
        }
        catch (IOException ignored) {
            return defaultPort;
        }
    }

    public static int tryToFindAvailableSocketPort() {
        return NetUtils.tryToFindAvailableSocketPort(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] findAvailableSocketPorts(int capacity) throws IOException {
        int[] ports = new int[capacity];
        ServerSocket[] sockets = new ServerSocket[capacity];
        for (int i = 0; i < capacity; ++i) {
            ServerSocket serverSocket;
            sockets[i] = serverSocket = new ServerSocket(0);
            ports[i] = serverSocket.getLocalPort();
        }
        ServerSocket[] serverSocketArray = sockets;
        synchronized (sockets) {
            try {
                sockets.wait(1L);
            }
            catch (InterruptedException e) {
                LOG.error((Throwable)e);
            }
            for (ServerSocket socket : sockets) {
                socket.close();
            }
            return ports;
        }
    }

    public static String getLocalHostString() {
        String localHostString = "localhost";
        try {
            InetAddress localHost = InetAddress.getByName(localHostString);
            if (localHost.getAddress().length != 4 && SystemInfo.isWindows || localHost.getAddress().length == 4 && SystemInfo.isMac) {
                localHostString = "127.0.0.1";
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return localHostString;
    }

    public static int copyStreamContent(@Nullable ProgressIndicator indicator, @NotNull InputStream inputStream, @NotNull OutputStream outputStream, int expectedContentLength) throws IOException, ProcessCanceledException {
        int count;
        if (inputStream == null) {
            NetUtils.$$$reportNull$$$0(1);
        }
        if (outputStream == null) {
            NetUtils.$$$reportNull$$$0(2);
        }
        if (indicator != null) {
            indicator.checkCanceled();
            indicator.setIndeterminate(expectedContentLength <= 0);
        }
        CountingGZIPInputStream gzipStream = (CountingGZIPInputStream)ObjectUtils.tryCast((Object)inputStream, CountingGZIPInputStream.class);
        byte[] buffer = new byte[8192];
        int bytesWritten = 0;
        long bytesRead = 0L;
        while ((count = inputStream.read(buffer)) > 0) {
            outputStream.write(buffer, 0, count);
            long l = bytesRead = gzipStream != null ? gzipStream.getCompressedBytesRead() : (long)(bytesWritten += count);
            if (indicator == null) continue;
            indicator.checkCanceled();
            if (expectedContentLength <= 0) continue;
            indicator.setFraction((double)bytesRead / (double)expectedContentLength);
        }
        if (gzipStream != null) {
            bytesRead = gzipStream.getCompressedBytesRead();
            if (indicator != null && expectedContentLength > 0) {
                indicator.setFraction((double)bytesRead / (double)expectedContentLength);
            }
        }
        if (indicator != null) {
            indicator.checkCanceled();
        }
        if (bytesRead < (long)expectedContentLength) {
            throw new IOException(String.format("Connection closed at byte %d. Expected %d bytes.", bytesRead, expectedContentLength));
        }
        return bytesWritten;
    }

    public static boolean isSniEnabled() {
        return SystemProperties.getBooleanProperty((String)"jsse.enableSNIExtension", (boolean)true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/net/NetUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isLocalhost";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "copyStreamContent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

