/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.application.options.CodeStyleBean;
import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.lang.IdeLanguageCustomization;
import com.intellij.lang.Language;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleConfigurable;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.DisplayPriority;
import com.intellij.psi.codeStyle.DocCommentSettings;
import com.intellij.psi.codeStyle.PredefinedCodeStyle;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LanguageCodeStyleSettingsProvider
extends CodeStyleSettingsProvider {
    public static final ExtensionPointName<LanguageCodeStyleSettingsProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.langCodeStyleSettingsProvider");

    @Nullable
    public abstract String getCodeSample(@NotNull SettingsType var1);

    public int getRightMargin(@NotNull SettingsType settingsType) {
        if (settingsType == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(0);
        }
        return settingsType == SettingsType.WRAPPING_AND_BRACES_SETTINGS ? 30 : -1;
    }

    public void customizeSettings(@NotNull CodeStyleSettingsCustomizable consumer, @NotNull SettingsType settingsType) {
        if (consumer == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(1);
        }
        if (settingsType == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(2);
        }
    }

    @Nullable
    public String getFileExt() {
        return null;
    }

    @Nullable
    public String getLanguageName() {
        return null;
    }

    @Nullable
    public PsiFile createFileFromText(Project project, String text) {
        return null;
    }

    @Deprecated
    @NotNull
    public CommonCodeStyleSettings getDefaultCommonSettings() {
        CommonCodeStyleSettings defaultSettings = new CommonCodeStyleSettings(this.getLanguage());
        defaultSettings.initIndentOptions();
        this.customizeDefaults(defaultSettings, defaultSettings.getIndentOptions());
        CommonCodeStyleSettings commonCodeStyleSettings = defaultSettings;
        if (commonCodeStyleSettings == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(3);
        }
        return commonCodeStyleSettings;
    }

    protected void customizeDefaults(@NotNull CommonCodeStyleSettings commonSettings, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        if (commonSettings == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(4);
        }
        if (indentOptions == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(5);
        }
    }

    @Deprecated
    @NotNull
    public PredefinedCodeStyle[] getPredefinedCodeStyles() {
        if (PredefinedCodeStyle.EMPTY_ARRAY == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(6);
        }
        return PredefinedCodeStyle.EMPTY_ARRAY;
    }

    public DisplayPriority getDisplayPriority() {
        List<Language> primaryIdeLanguages = IdeLanguageCustomization.getInstance().getPrimaryIdeLanguages();
        return primaryIdeLanguages.contains((Object)this.getLanguage()) ? DisplayPriority.KEY_LANGUAGE_SETTINGS : DisplayPriority.LANGUAGE_SETTINGS;
    }

    @NotNull
    public static Language[] getLanguagesWithCodeStyleSettings() {
        ArrayList<Language> languages = new ArrayList<Language>();
        for (LanguageCodeStyleSettingsProvider provider : EP_NAME.getExtensionList()) {
            languages.add(provider.getLanguage());
        }
        Language[] languageArray = languages.toArray(new Language[0]);
        if (languageArray == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(7);
        }
        return languageArray;
    }

    @Nullable
    public static String getCodeSample(Language lang, @NotNull SettingsType settingsType) {
        LanguageCodeStyleSettingsProvider provider;
        if (settingsType == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(8);
        }
        return (provider = LanguageCodeStyleSettingsProvider.forLanguage(lang)) != null ? provider.getCodeSample(settingsType) : null;
    }

    public static int getRightMargin(Language lang, @NotNull SettingsType settingsType) {
        LanguageCodeStyleSettingsProvider provider;
        if (settingsType == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(9);
        }
        return (provider = LanguageCodeStyleSettingsProvider.forLanguage(lang)) != null ? provider.getRightMargin(settingsType) : -1;
    }

    @Override
    @NotNull
    public abstract Language getLanguage();

    @Nullable
    public static Language getLanguage(String langName) {
        for (LanguageCodeStyleSettingsProvider provider : EP_NAME.getExtensionList()) {
            String name = provider.getLanguageName();
            if (name == null) {
                name = provider.getLanguage().getDisplayName();
            }
            if (!langName.equals(name)) continue;
            return provider.getLanguage();
        }
        return null;
    }

    @Nullable
    public static CommonCodeStyleSettings getDefaultCommonSettings(Language lang) {
        LanguageCodeStyleSettingsProvider provider = LanguageCodeStyleSettingsProvider.forLanguage(lang);
        return provider != null ? provider.getDefaultCommonSettings() : null;
    }

    @Nullable
    public static String getFileExt(Language lang) {
        LanguageCodeStyleSettingsProvider provider = LanguageCodeStyleSettingsProvider.forLanguage(lang);
        return provider != null ? provider.getFileExt() : null;
    }

    @NotNull
    public static String getLanguageName(Language lang) {
        LanguageCodeStyleSettingsProvider provider = LanguageCodeStyleSettingsProvider.forLanguage(lang);
        String providerLangName = provider != null ? provider.getLanguageName() : null;
        String string = providerLangName != null ? providerLangName : lang.getDisplayName();
        if (string == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Nullable
    public static PsiFile createFileFromText(Language language, Project project, String text) {
        LanguageCodeStyleSettingsProvider provider = LanguageCodeStyleSettingsProvider.forLanguage(language);
        return provider != null ? provider.createFileFromText(project, text) : null;
    }

    @Nullable
    public static LanguageCodeStyleSettingsProvider forLanguage(Language language) {
        for (LanguageCodeStyleSettingsProvider provider : EP_NAME.getExtensionList()) {
            if (!((Object)((Object)provider.getLanguage())).equals((Object)language)) continue;
            return provider;
        }
        return null;
    }

    @Nullable
    public static LanguageCodeStyleSettingsProvider findUsingBaseLanguage(@NotNull Language language) {
        if (language == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(11);
        }
        for (Language currLang = language; currLang != null; currLang = currLang.getBaseLanguage()) {
            LanguageCodeStyleSettingsProvider curr = LanguageCodeStyleSettingsProvider.forLanguage(currLang);
            if (curr == null) continue;
            return curr;
        }
        return null;
    }

    public static DisplayPriority getDisplayPriority(Language language) {
        LanguageCodeStyleSettingsProvider langProvider = LanguageCodeStyleSettingsProvider.forLanguage(language);
        if (langProvider == null) {
            return DisplayPriority.LANGUAGE_SETTINGS;
        }
        return langProvider.getDisplayPriority();
    }

    @Nullable
    public IndentOptionsEditor getIndentOptionsEditor() {
        return null;
    }

    public Set<String> getSupportedFields() {
        return new SupportedFieldCollector().collectFields();
    }

    public Set<String> getSupportedFields(SettingsType type) {
        return new SupportedFieldCollector().collectFields(type);
    }

    @NotNull
    public DocCommentSettings getDocCommentSettings(@NotNull CodeStyleSettings rootSettings) {
        if (rootSettings == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(12);
        }
        DocCommentSettings docCommentSettings = DocCommentSettings.DEFAULTS;
        if (docCommentSettings == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(13);
        }
        return docCommentSettings;
    }

    @Nullable
    @ApiStatus.Experimental
    public CodeStyleBean createBean() {
        return null;
    }

    @Override
    @NotNull
    public CodeStyleConfigurable createConfigurable(@NotNull CodeStyleSettings baseSettings, @NotNull CodeStyleSettings modelSettings) {
        if (baseSettings == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(14);
        }
        if (modelSettings == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(15);
        }
        throw new RuntimeException(this.getClass().getCanonicalName() + " for language #" + this.getLanguage().getID() + " doesn't implement createConfigurable()");
    }

    public static List<LanguageCodeStyleSettingsProvider> getSettingsPagesProviders() {
        ArrayList settingsPagesProviders = ContainerUtil.newArrayList();
        for (LanguageCodeStyleSettingsProvider provider : EP_NAME.getExtensionList()) {
            try {
                provider.getClass().getDeclaredMethod("createConfigurable", CodeStyleSettings.class, CodeStyleSettings.class);
                settingsPagesProviders.add(provider);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        return settingsPagesProviders;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/LanguageCodeStyleSettingsProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonSettings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indentOptions";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootSettings";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseSettings";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/LanguageCodeStyleSettingsProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultCommonSettings";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredefinedCodeStyles";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguagesWithCodeStyleSettings";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocCommentSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRightMargin";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "customizeSettings";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 13: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "customizeDefaults";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCodeSample";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findUsingBaseLanguage";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDocCommentSettings";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class SupportedFieldCollector
    implements CodeStyleSettingsCustomizable {
        private final Set<String> myCollectedFields = new THashSet();
        private SettingsType myCurrSettingsType;

        private SupportedFieldCollector() {
        }

        public Set<String> collectFields() {
            SettingsType[] settingsTypeArray = SettingsType.values();
            int n = settingsTypeArray.length;
            for (int i = 0; i < n; ++i) {
                SettingsType settingsType;
                this.myCurrSettingsType = settingsType = settingsTypeArray[i];
                LanguageCodeStyleSettingsProvider.this.customizeSettings(this, settingsType);
            }
            return this.myCollectedFields;
        }

        public Set<String> collectFields(SettingsType type) {
            this.myCurrSettingsType = type;
            LanguageCodeStyleSettingsProvider.this.customizeSettings(this, type);
            return this.myCollectedFields;
        }

        @Override
        public void showAllStandardOptions() {
            switch (this.myCurrSettingsType) {
                case BLANK_LINES_SETTINGS: {
                    for (CodeStyleSettingsCustomizable.BlankLinesOption blankLinesOption : CodeStyleSettingsCustomizable.BlankLinesOption.values()) {
                        this.myCollectedFields.add(blankLinesOption.name());
                    }
                    break;
                }
                case SPACING_SETTINGS: {
                    for (CodeStyleSettingsCustomizable.SpacingOption spacingOption : CodeStyleSettingsCustomizable.SpacingOption.values()) {
                        this.myCollectedFields.add(spacingOption.name());
                    }
                    break;
                }
                case WRAPPING_AND_BRACES_SETTINGS: {
                    for (CodeStyleSettingsCustomizable.WrappingOrBraceOption wrappingOrBraceOption : CodeStyleSettingsCustomizable.WrappingOrBraceOption.values()) {
                        this.myCollectedFields.add(wrappingOrBraceOption.name());
                    }
                    break;
                }
                case COMMENTER_SETTINGS: {
                    for (CodeStyleSettingsCustomizable.CommenterOption commenterOption : CodeStyleSettingsCustomizable.CommenterOption.values()) {
                        this.myCollectedFields.add(commenterOption.name());
                    }
                    break;
                }
            }
        }

        @Override
        public void showStandardOptions(String ... optionNames) {
            ContainerUtil.addAll(this.myCollectedFields, (Object[])optionNames);
        }

        @Override
        public void showCustomOption(Class<? extends CustomCodeStyleSettings> settingsClass, String fieldName, String title, @Nullable String groupName, Object ... options) {
            this.myCollectedFields.add(fieldName);
        }

        @Override
        public void showCustomOption(Class<? extends CustomCodeStyleSettings> settingsClass, String fieldName, String title, @Nullable String groupName, @Nullable CodeStyleSettingsCustomizable.OptionAnchor anchor, @Nullable String anchorFieldName, Object ... options) {
            this.myCollectedFields.add(fieldName);
        }
    }

    public static enum SettingsType {
        BLANK_LINES_SETTINGS,
        SPACING_SETTINGS,
        WRAPPING_AND_BRACES_SETTINGS,
        INDENT_SETTINGS,
        COMMENTER_SETTINGS,
        LANGUAGE_SPECIFIC;

    }
}

