/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class ComboBoxWithWidePopup<E>
extends JComboBox<E> {
    private int myMinLength;

    public ComboBoxWithWidePopup() {
        this.myMinLength = 20;
        this.init();
    }

    public ComboBoxWithWidePopup(@NotNull ComboBoxModel<E> model) {
        if (model == null) {
            ComboBoxWithWidePopup.$$$reportNull$$$0(0);
        }
        super(model);
        this.myMinLength = 20;
        this.init();
    }

    public ComboBoxWithWidePopup(@NotNull E[] items) {
        if (items == null) {
            ComboBoxWithWidePopup.$$$reportNull$$$0(1);
        }
        super(items);
        this.myMinLength = 20;
        this.init();
    }

    private void init() {
        if (SystemInfo.isMac && UIUtil.isUnderAquaLookAndFeel()) {
            this.setMaximumRowCount(25);
        }
    }

    @Override
    public void setRenderer(ListCellRenderer<? super E> renderer) {
        if (renderer instanceof SimpleColoredComponent) {
            SimpleColoredComponent scc = (SimpleColoredComponent)((Object)renderer);
            scc.getIpad().bottom = 0;
            scc.getIpad().top = 0;
        }
        super.setRenderer(new AdjustingListCellRenderer(renderer));
    }

    public void setMinLength(int minLength) {
        this.myMinLength = minLength;
    }

    protected int getMinLength() {
        return this.myMinLength;
    }

    public int getMinimumPopupWidth() {
        return super.getPreferredSize().width;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "model";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "items";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/ui/ComboBoxWithWidePopup";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class AdjustingListCellRenderer
    implements ListCellRenderer<E> {
        private final ListCellRenderer<? super E> delegate;

        AdjustingListCellRenderer(ListCellRenderer<? super E> delegate) {
            this.delegate = delegate;
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends E> list, E value, int index2, boolean isSelected, boolean cellHasFocus) {
            if (index2 == -1 && value instanceof String && !ComboBoxWithWidePopup.this.isValid()) {
                int minLength = ComboBoxWithWidePopup.this.getMinLength();
                String stringValue = (String)value;
                if (ComboBoxWithWidePopup.this.getSize().width == 0 && stringValue.length() > minLength) {
                    String e = stringValue.substring(0, minLength);
                    value = e;
                }
            }
            return this.delegate.getListCellRendererComponent(list, (Object)value, index2, isSelected, cellHasFocus);
        }
    }
}

