/*
 * Decompiled with CFR 0.152.
 */
package liquibase.logging;

import liquibase.Liquibase;
import liquibase.logging.LogLevel;
import liquibase.logging.LogService;
import liquibase.logging.LogType;
import liquibase.logging.Logger;

public class LogFactory {
    private static LogFactory instance;

    public static synchronized void reset() {
        instance = new LogFactory();
    }

    public static synchronized LogFactory getInstance() {
        if (instance == null) {
            instance = new LogFactory();
        }
        return instance;
    }

    public static void setInstance(LogFactory instance) {
        LogFactory.instance = instance;
    }

    public static Logger getLogger(String name) {
        return LogFactory.getInstance().getLog(name);
    }

    public Logger getLog(String name) {
        Class<Object> clazz;
        try {
            clazz = Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            clazz = Liquibase.class;
        }
        return LogService.getLog(clazz);
    }

    public static Logger getLogger() {
        return LogFactory.getInstance().getLog();
    }

    public Logger getLog() {
        return LogService.getLog(Liquibase.class);
    }

    public void setDefaultLoggingLevel(String defaultLoggingLevel) {
        LogService.getLog(this.getClass()).warning(LogType.LOG, "LogFactory.setDefaultLoggingLevel() is now a no-op.");
    }

    public void setDefaultLoggingLevel(LogLevel defaultLoggingLevel) {
        LogService.getLog(this.getClass()).warning(LogType.LOG, "LogFactory.setDefaultLoggingLevel() is now a no-op.");
    }

    public static void setLoggingLevel(String defaultLoggingLevel) {
        LogService.getLog(LogFactory.class).warning(LogType.LOG, "LogFactory.setLoggingLevel() is now a no-op.");
    }
}

