/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Block;
import org.netbeans.modules.php.editor.parser.astnodes.DoStatement;
import org.netbeans.modules.php.editor.parser.astnodes.ForEachStatement;
import org.netbeans.modules.php.editor.parser.astnodes.ForStatement;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.IfStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Statement;
import org.netbeans.modules.php.editor.parser.astnodes.WhileStatement;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultTreePathVisitor;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.CustomisableRule;
import org.netbeans.modules.php.editor.verification.HintRule;
import org.netbeans.modules.php.editor.verification.NestedHintsCustomizer;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.openide.filesystems.FileObject;

public class NestedBlocksHint
extends HintRule
implements CustomisableRule {
    private static final Logger LOGGER = Logger.getLogger(NestedBlocksHint.class.getName());
    private static final String HINT_ID = "Nested.Blocks.Hint";
    private static final String NUMBER_OF_ALLOWED_NESTED_BLOCKS = "php.verification.number.of.allowed.nested.blocks";
    private static final int DEFAULT_NUMBER_OF_ALLOWED_NESTED_BLOCKS = 2;
    private static final String ALLOW_CONDITION_BLOCK = "php.verification.allow.condition.block";
    private static final boolean DEFAULT_ALLOW_CONDITION_BLOCK = true;
    private Preferences preferences;

    @Override
    public void invoke(PHPRuleContext context, List<Hint> hints) {
        FileObject fileObject;
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() != null && (fileObject = phpParseResult.getSnapshot().getSource().getFileObject()) != null) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            CheckVisitor checkVisitor = new CheckVisitor(fileObject, context.doc);
            phpParseResult.getProgram().accept(checkVisitor);
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            hints.addAll(checkVisitor.getHints());
        }
    }

    public String getId() {
        return HINT_ID;
    }

    public String getDescription() {
        return Bundle.NestedBlocksHintDesc();
    }

    public String getDisplayName() {
        return Bundle.NestedBlocksHintDisp();
    }

    @Override
    public void setPreferences(Preferences preferences) {
        this.preferences = preferences;
    }

    @Override
    public JComponent getCustomizer(Preferences preferences) {
        NestedHintsCustomizer customizer = new NestedHintsCustomizer(preferences, this);
        this.setNumberOfAllowedNestedBlocks(preferences, this.getNumberOfAllowedNestedBlocks(preferences));
        this.setAllowConditionBlock(preferences, this.allowConditionBlock(preferences));
        return customizer;
    }

    public void setNumberOfAllowedNestedBlocks(Preferences preferences, Integer value) {
        assert (preferences != null);
        assert (value != null);
        preferences.putInt(NUMBER_OF_ALLOWED_NESTED_BLOCKS, value);
    }

    public int getNumberOfAllowedNestedBlocks(Preferences preferences) {
        assert (preferences != null);
        return preferences.getInt(NUMBER_OF_ALLOWED_NESTED_BLOCKS, 2);
    }

    public void setAllowConditionBlock(Preferences preferences, boolean isEnabled) {
        assert (preferences != null);
        preferences.putBoolean(ALLOW_CONDITION_BLOCK, isEnabled);
    }

    public boolean allowConditionBlock(Preferences preferences) {
        assert (preferences != null);
        return preferences.getBoolean(ALLOW_CONDITION_BLOCK, true);
    }

    private static enum Rank {
        FIRST(1),
        SECOND(2);

        private final int distance;

        private Rank(int distance) {
            this.distance = distance;
        }

        public int getDistance() {
            return this.distance;
        }
    }

    private final class CheckVisitor
    extends DefaultTreePathVisitor {
        private final FileObject fileObject;
        private final BaseDocument baseDocument;
        private final List<ASTNode> unallowedNestedBlocks;
        private final List<Hint> hints;
        private boolean isInFunctionDeclaration;
        private int countOfNestedBlocks;

        private CheckVisitor(FileObject fileObject, BaseDocument baseDocument) {
            this.fileObject = fileObject;
            this.baseDocument = baseDocument;
            this.unallowedNestedBlocks = new ArrayList<ASTNode>();
            this.hints = new ArrayList<Hint>();
        }

        private Collection<? extends Hint> getHints() {
            for (ASTNode block : this.unallowedNestedBlocks) {
                this.createHint(block);
            }
            return this.hints;
        }

        private void createHint(ASTNode block) {
            int lineEnd = block.getEndOffset();
            try {
                lineEnd = LineDocumentUtils.getLineEnd((LineDocument)this.baseDocument, (int)block.getStartOffset());
            }
            catch (BadLocationException ex) {
                LOGGER.log(Level.FINE, null, ex);
            }
            OffsetRange offsetRange = new OffsetRange(block.getStartOffset(), lineEnd);
            if (NestedBlocksHint.this.showHint(offsetRange, this.baseDocument)) {
                this.hints.add(new Hint((Rule)NestedBlocksHint.this, Bundle.NestedBlocksHintText(), this.fileObject, offsetRange, null, 500));
            }
        }

        @Override
        public void visit(FunctionDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.scan(node.getFunctionName());
            this.scan(node.getFormalParameters());
            Block body = node.getBody();
            if (body != null) {
                this.isInFunctionDeclaration = true;
                this.scan(body.getStatements());
                this.isInFunctionDeclaration = false;
            }
        }

        @Override
        public void visit(ForStatement node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            Statement body = node.getBody();
            if (body instanceof Block) {
                super.visit(node);
            } else if (this.isInFunctionDeclaration) {
                ++this.countOfNestedBlocks;
                this.evaluatePossiblyUnallowedNestedBlock();
                super.visit(node);
                --this.countOfNestedBlocks;
            } else {
                super.visit(node);
            }
        }

        @Override
        public void visit(ForEachStatement node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            Statement body = node.getStatement();
            if (body instanceof Block) {
                super.visit(node);
            } else if (this.isInFunctionDeclaration) {
                ++this.countOfNestedBlocks;
                this.evaluatePossiblyUnallowedNestedBlock();
                super.visit(node);
                --this.countOfNestedBlocks;
            } else {
                super.visit(node);
            }
        }

        @Override
        public void visit(DoStatement node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            Statement body = node.getBody();
            if (body instanceof Block) {
                super.visit(node);
            } else if (this.isInFunctionDeclaration) {
                ++this.countOfNestedBlocks;
                this.evaluatePossiblyUnallowedNestedBlock();
                super.visit(node);
                --this.countOfNestedBlocks;
            } else {
                super.visit(node);
            }
        }

        @Override
        public void visit(WhileStatement node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            Statement body = node.getBody();
            if (body instanceof Block) {
                super.visit(node);
            } else if (this.isInFunctionDeclaration) {
                ++this.countOfNestedBlocks;
                this.evaluatePossiblyUnallowedNestedBlock();
                super.visit(node);
                --this.countOfNestedBlocks;
            } else {
                super.visit(node);
            }
        }

        @Override
        public void visit(IfStatement node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.addToPath(node);
            Statement trueStatement = node.getTrueStatement();
            if (trueStatement instanceof Block) {
                this.scan((Block)trueStatement);
            } else if (trueStatement != null) {
                if (this.isInFunctionDeclaration) {
                    ++this.countOfNestedBlocks;
                    this.evaluatePossiblyUnallowedNestedBlock();
                    this.scan(trueStatement);
                    --this.countOfNestedBlocks;
                } else {
                    this.scan(trueStatement);
                }
            }
            Statement falseStatement = node.getFalseStatement();
            if (falseStatement instanceof Block) {
                this.scan((Block)falseStatement);
            } else if (falseStatement instanceof IfStatement) {
                this.scan((IfStatement)falseStatement);
            } else if (falseStatement != null) {
                if (this.isInFunctionDeclaration) {
                    ++this.countOfNestedBlocks;
                    this.evaluatePossiblyUnallowedNestedBlock();
                    this.scan(falseStatement);
                    --this.countOfNestedBlocks;
                } else {
                    this.scan(falseStatement);
                }
            }
        }

        @Override
        public void visit(Block node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (this.isInFunctionDeclaration) {
                ++this.countOfNestedBlocks;
                this.evaluatePossiblyUnallowedNestedBlock();
                super.visit(node);
                --this.countOfNestedBlocks;
            } else {
                super.visit(node);
            }
        }

        private void evaluatePossiblyUnallowedNestedBlock() {
            if (this.isUnallowedNestedBlock(Rank.FIRST) && !this.isAllowedConditionInLoop() || this.isUnallowedNestedBlock(Rank.SECOND) && NestedBlocksHint.this.allowConditionBlock(NestedBlocksHint.this.preferences)) {
                this.unallowedNestedBlocks.add(this.getParentNode());
            }
        }

        private boolean isAllowedConditionInLoop() {
            return NestedBlocksHint.this.allowConditionBlock(NestedBlocksHint.this.preferences) && this.getParentNode() instanceof IfStatement && this.isInLoopNode();
        }

        private boolean isInLoopNode() {
            boolean isLoopNode = false;
            List<ASTNode> path = this.getPath();
            int pathSize = path.size();
            if (pathSize > 1) {
                isLoopNode = this.isLoopNode(path.get(1));
            }
            if (!isLoopNode && pathSize > 2) {
                isLoopNode = path.get(1) instanceof Block && this.isLoopNode(path.get(2));
            }
            return isLoopNode;
        }

        private boolean isLoopNode(ASTNode node) {
            return node instanceof WhileStatement || node instanceof DoStatement || node instanceof ForEachStatement || node instanceof ForStatement;
        }

        private ASTNode getParentNode() {
            return this.getPath().get(0);
        }

        private boolean isUnallowedNestedBlock(Rank rank) {
            int numberOfAllowedNestedBlocks = NestedBlocksHint.this.getNumberOfAllowedNestedBlocks(NestedBlocksHint.this.preferences);
            return this.countOfNestedBlocks > numberOfAllowedNestedBlocks && this.countOfNestedBlocks - numberOfAllowedNestedBlocks == rank.getDistance();
        }
    }
}

