/*
 * Decompiled with CFR 0.152.
 */
package org.jvyamlb.debug;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Iterator;
import org.jruby.util.ByteList;
import org.jvyamlb.ScannerImpl;
import org.jvyamlb.tokens.BlockEndToken;
import org.jvyamlb.tokens.BlockMappingStartToken;
import org.jvyamlb.tokens.BlockSequenceStartToken;
import org.jvyamlb.tokens.DocumentStartToken;
import org.jvyamlb.tokens.StreamEndToken;
import org.jvyamlb.tokens.StreamStartToken;

public class ScannerOutput {
    public static byte[] realloc(byte[] input, int size) {
        byte[] newArray = new byte[size];
        System.arraycopy(input, 0, newArray, 0, input.length);
        return newArray;
    }

    public static void main(String[] args) throws Exception {
        String filename = args[0];
        int len = 8000;
        int read = 0;
        int currRead = 0;
        byte[] buffer = new byte[1024];
        byte[] input = new byte[len];
        FileInputStream is = new FileInputStream(filename);
        while ((currRead = ((InputStream)is).read(buffer, 0, 1024)) != -1) {
            if (read + currRead >= len) {
                input = ScannerOutput.realloc(input, len *= 2);
            }
            System.arraycopy(buffer, 0, input, read, currRead);
            read += currRead;
        }
        ScannerImpl sce2 = new ScannerImpl(new ByteList(input, 0, read));
        int indent = 0;
        Iterator iter = sce2.eachToken();
        while (iter.hasNext()) {
            int i;
            Object o = iter.next();
            if (o instanceof StreamStartToken || o instanceof DocumentStartToken || o instanceof BlockSequenceStartToken || o instanceof BlockMappingStartToken) {
                for (i = 0; i < indent; ++i) {
                    System.err.print(" ");
                }
                ++indent;
            } else if (o instanceof StreamEndToken || o instanceof BlockEndToken) {
                --indent;
                for (i = 0; i < indent; ++i) {
                    System.err.print(" ");
                }
            } else {
                for (i = 0; i < indent; ++i) {
                    System.err.print(" ");
                }
            }
            System.err.println(o);
        }
    }
}

