/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.image.action;

import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.List;
import java.util.logging.Logger;
import org.openide.awt.HtmlBrowser;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class ExternalEditAction
implements ActionListener {
    private final List<FileObject> list;
    private final RequestProcessor RP = new RequestProcessor(ExternalEditAction.class.getName());

    public ExternalEditAction(List<FileObject> list) {
        this.list = list;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.RP.post(new Runnable(){

            @Override
            public void run() {
                boolean showInBrowser = true;
                for (FileObject imageFO : ExternalEditAction.this.list) {
                    Desktop desktop;
                    File imageFile = FileUtil.toFile((FileObject)imageFO);
                    if (imageFile == null) continue;
                    if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.EDIT)) {
                        showInBrowser = false;
                        try {
                            desktop.edit(imageFile);
                        }
                        catch (IOException ex) {
                            Logger.getLogger(ExternalEditAction.class.getName()).info(NbBundle.getMessage(ExternalEditAction.class, (String)"ERR_ExternalEditFile"));
                            showInBrowser = true;
                        }
                    }
                    if (!showInBrowser) continue;
                    try {
                        HtmlBrowser.URLDisplayer.getDefault().showURL(imageFile.toURI().toURL());
                    }
                    catch (MalformedURLException ex) {
                        Logger.getLogger(ExternalEditAction.class.getName()).info(NbBundle.getMessage(ExternalEditAction.class, (String)"ERR_ExternalEditFile"));
                    }
                }
            }
        });
    }
}

