/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.service;

import java.net.Socket;
import org.apache.tomcat.service.PoolTcpEndpoint;
import org.apache.tomcat.service.TcpConnection;
import org.apache.tomcat.util.SimplePool;
import org.apache.tomcat.util.ThreadPoolRunnable;

class TcpWorkerThread
implements ThreadPoolRunnable {
    PoolTcpEndpoint endpoint;
    SimplePool connectionCache;
    static final boolean usePool = true;

    public TcpWorkerThread(PoolTcpEndpoint endpoint) {
        this.endpoint = endpoint;
        this.connectionCache = new SimplePool(endpoint.getMaxThreads());
        int i = 0;
        while (i < endpoint.getMaxThreads() / 2) {
            this.connectionCache.put(new TcpConnection());
            ++i;
        }
    }

    public Object[] getInitData() {
        return this.endpoint.getConnectionHandler().init();
    }

    public void runIt(Object[] perThrData) {
        TcpConnection con = null;
        while (this.endpoint.running) {
            Socket s = this.endpoint.acceptSocket();
            if (null == s) continue;
            this.endpoint.tp.runIt(this);
            try {
                con = (TcpConnection)this.connectionCache.get();
                if (con == null) {
                    con = new TcpConnection();
                }
                con.setEndpoint(this.endpoint);
                con.setSocket(s);
                this.endpoint.getConnectionHandler().processConnection(con, perThrData);
                Object var5_4 = null;
                con.recycle();
                if (con == null) break;
                this.connectionCache.put(con);
                break;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                con.recycle();
                if (con != null) {
                    this.connectionCache.put(con);
                }
                throw throwable;
            }
        }
    }
}

