/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URISyntaxException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Repository;
import org.apache.maven.project.MavenProject;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;

final class TransientRepositories {
    private static final Logger LOGGER = Logger.getLogger(TransientRepositories.class.getName());
    private final NbMavenProject p;
    private final PropertyChangeListener l = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("MavenProject".equals(evt.getPropertyName())) {
                TransientRepositories.this.doUnregister();
                TransientRepositories.this.doRegister();
            }
        }
    };

    TransientRepositories(NbMavenProject p) {
        this.p = p;
    }

    private void doRegister() {
        MavenProject mp = this.p.getMavenProject();
        for (ArtifactRepository repo : mp.getRemoteArtifactRepositories()) {
            this.register(repo, mp.getRepositories());
        }
        for (ArtifactRepository repo : mp.getPluginArtifactRepositories()) {
            this.register(repo, mp.getPluginRepositories());
        }
    }

    void register() {
        this.doRegister();
        this.p.addPropertyChangeListener(this.l);
    }

    private void register(ArtifactRepository repo, List<Repository> definitions) {
        List mirrored;
        String id;
        String displayName = id = repo.getId();
        for (Repository r : definitions) {
            String n;
            if (!id.equals(r.getId()) || (n = r.getName()) == null) continue;
            displayName = n;
            break;
        }
        if ((mirrored = repo.getMirroredRepositories()).isEmpty()) {
            try {
                RepositoryPreferences.getInstance().addTransientRepository((Object)this, repo.getId(), displayName, repo.getUrl(), RepositoryInfo.MirrorStrategy.ALL);
            }
            catch (URISyntaxException x) {
                LOGGER.log(Level.WARNING, "Ignoring repo with malformed URL: {0}", x.getMessage());
            }
        } else {
            for (ArtifactRepository mirr : mirrored) {
                try {
                    RepositoryPreferences.getInstance().addTransientRepository((Object)this, mirr.getId(), mirr.getId(), mirr.getUrl(), RepositoryInfo.MirrorStrategy.ALL);
                }
                catch (URISyntaxException x) {
                    LOGGER.log(Level.WARNING, "Ignoring repo with malformed URL: {0}", x.getMessage());
                }
            }
        }
    }

    void unregister() {
        this.p.removePropertyChangeListener(this.l);
        this.doUnregister();
    }

    private void doUnregister() {
        RepositoryPreferences.getInstance().removeTransientRepositories((Object)this);
    }
}

