/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.editor.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.csl.api.Documentation;
import org.netbeans.modules.docker.editor.parser.Command;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class DocDownloader {
    private static final RequestProcessor RP = new RequestProcessor(DocDownloader.class.getName(), 4);
    private static final Pattern HEADER_PATTERN = Pattern.compile("\\s*<h2\\s+id\\s*=\\s*\"([\\w\\d]+)\"\\s*>.*</h2>\\s*");
    private static final Logger LOG = Logger.getLogger(DocDownloader.class.getName());

    @NonNull
    public static Future<String> download(@NonNull URL url, @NonNull Callable<Boolean> cancel) {
        return RP.submit(() -> {
            if (((Boolean)cancel.call()).booleanValue()) {
                return "";
            }
            ProgressHandle handle = ProgressHandle.createHandle((String)NbBundle.getMessage(DocDownloader.class, (String)"LBL_DownloadingDoc"));
            handle.start();
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                try (BufferedInputStream in = new BufferedInputStream(url.openStream());){
                    FileUtil.copy((InputStream)in, (OutputStream)out);
                }
                String string = (Boolean)cancel.call() != false ? "" : new String(out.toByteArray(), "UTF-8");
                return string;
            }
            finally {
                handle.finish();
            }
        });
    }

    @NonNull
    public static Map<Command, Documentation> parseCommands(@NonNull String html, @NonNull String baseURL) throws MalformedURLException {
        HashMap<Command, Documentation> res = new HashMap<Command, Documentation>();
        int start = -1;
        do {
            Command cmd;
            Matcher m;
            String section;
            int nlIndex;
            int prevStart = start;
            start = html.indexOf("<h2", start + 1);
            if (prevStart <= 0 || (nlIndex = (section = html.substring(prevStart, start > 0 ? start : html.length())).indexOf(10)) <= 0 || !(m = HEADER_PATTERN.matcher(section.substring(0, nlIndex))).matches()) continue;
            String cmdName = m.group(1);
            Command command = cmd = cmdName == null ? null : Command.forName(cmdName);
            if (cmd == null) continue;
            res.put(cmd, Documentation.create((String)section, (URL)new URL(String.format("%s#%s", baseURL, cmdName))));
        } while (start >= 0);
        return Collections.unmodifiableMap(res);
    }

    @CheckForNull
    public static Documentation parseSection(@NonNull String html, @NonNull URL url) {
        Pattern p;
        Matcher m;
        String ref = url.getRef();
        if (ref != null && !ref.isEmpty() && (m = (p = Pattern.compile("<h(\\d)\\s+id\\s*=\\s*[\"']" + Pattern.quote(ref) + "[\"']")).matcher(html)).find()) {
            try {
                int start = m.start();
                int headerType = Integer.parseInt(m.group(1));
                int end = m.end();
                while ((end = html.indexOf("<h", end + 1)) >= 0 && html.charAt(end + 2) - 48 > headerType) {
                }
                return Documentation.create((String)html.substring(start, end < 0 ? html.length() : end), (URL)url);
            }
            catch (NumberFormatException e) {
                LOG.log(Level.WARNING, "Wrong documentation header: {0}", m.group(0));
            }
        }
        return Documentation.create((String)html, (URL)url);
    }
}

