/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.project.ui;

import java.awt.Color;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.CharConversionException;
import java.net.URL;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ui.ProjectProblems;
import org.netbeans.modules.java.api.common.project.ui.LogicalViewProvider2;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.ui.ProjectProblemsProvider;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.netbeans.spi.project.ui.support.NodeFactorySupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.xml.XMLUtil;

public final class LogicalViewProviders {
    private LogicalViewProviders() {
        throw new IllegalStateException("No instance allowed");
    }

    @NonNull
    public static LogicalViewProviderBuilder createBuilder(@NonNull Project project, @NonNull PropertyEvaluator eval, @NonNull String extensionFolder) {
        return new LogicalViewProviderBuilder(project, eval, extensionFolder);
    }

    private static final class SimpleInfo
    implements ProjectInformation {
        private final Project project;

        SimpleInfo(@NonNull Project project) {
            Parameters.notNull((CharSequence)"project", (Object)project);
            this.project = project;
        }

        public String getName() {
            return this.project.getProjectDirectory().getName();
        }

        public String getDisplayName() {
            return this.getName();
        }

        public Icon getIcon() {
            return null;
        }

        public Project getProject() {
            return this.project;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
        }
    }

    private static class LogicalViewProviderImpl
    implements LogicalViewProvider2 {
        private static final RequestProcessor RP = new RequestProcessor(LogicalViewProviders.class);
        private static final String COMPILE_ON_SAVE_DISABLED_BADGE_PATH = "org/netbeans/modules/java/api/common/project/ui/resources/compileOnSaveDisabledBadge.gif";
        private static final Image compileOnSaveDisabledBadge;
        private final Project project;
        private final PropertyEvaluator evaluator;
        private final String projectType;
        private final HelpCtx helpContext;
        private final CompileOnSaveBadge badgeStatus;
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
        private final PropertyChangeListener pcl;
        private final RequestProcessor.Task task = RP.create(new Runnable(){

            @Override
            public void run() {
                this.setBroken(ProjectProblems.isBroken((Project)project));
                this.setCompileOnSaveDisabled(this.isCompileOnSaveDisabled());
            }
        });
        private volatile boolean listenersInited;
        private volatile boolean broken;
        private volatile boolean compileOnSaveDisabled;

        public LogicalViewProviderImpl(@NonNull Project project, @NonNull PropertyEvaluator evaluator, @NonNull String projectType, @NullAllowed HelpCtx helpContext, final @NullAllowed CompileOnSaveBadge badgeStatus) {
            Parameters.notNull((CharSequence)"project", (Object)project);
            Parameters.notNull((CharSequence)"evaluator", (Object)evaluator);
            Parameters.notNull((CharSequence)"projectType", (Object)projectType);
            this.project = project;
            this.evaluator = evaluator;
            this.projectType = projectType;
            this.helpContext = helpContext;
            this.badgeStatus = badgeStatus;
            this.pcl = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    String propName = evt.getPropertyName();
                    if ("problems".equals(evt.getPropertyName()) || badgeStatus != null && (propName == null || badgeStatus.isImportant(propName))) {
                        this.testBroken();
                    }
                }
            };
        }

        private void initListeners() {
            if (this.listenersInited) {
                return;
            }
            ProjectManager.mutex().readAccess(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Class<LogicalViewProviderImpl> clazz = LogicalViewProviderImpl.class;
                    synchronized (LogicalViewProviderImpl.class) {
                        if (!listenersInited) {
                            evaluator.addPropertyChangeListener(pcl);
                            ProjectProblemsProvider ppp = (ProjectProblemsProvider)project.getLookup().lookup(ProjectProblemsProvider.class);
                            if (ppp != null) {
                                ppp.addPropertyChangeListener(pcl);
                            }
                            listenersInited = true;
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
        }

        public Node createLogicalView() {
            this.initListeners();
            InstanceContent ic = new InstanceContent();
            ic.add((Object)this.project);
            ic.add((Object)this.project, (InstanceContent.Convertor)new InstanceContent.Convertor<Project, FileObject>(){

                public FileObject convert(Project obj) {
                    return obj.getProjectDirectory();
                }

                public Class<? extends FileObject> type(Project obj) {
                    return FileObject.class;
                }

                public String id(Project obj) {
                    FileObject fo = obj.getProjectDirectory();
                    return fo == null ? "" : fo.getPath();
                }

                public String displayName(Project obj) {
                    return obj.toString();
                }
            });
            ic.add((Object)this.project, (InstanceContent.Convertor)new InstanceContent.Convertor<Project, DataObject>(){

                public DataObject convert(Project obj) {
                    try {
                        FileObject fo = obj.getProjectDirectory();
                        return fo == null ? null : DataObject.find((FileObject)fo);
                    }
                    catch (DataObjectNotFoundException ex) {
                        return null;
                    }
                }

                public Class<? extends DataObject> type(Project obj) {
                    return DataObject.class;
                }

                public String id(Project obj) {
                    FileObject fo = obj.getProjectDirectory();
                    return fo == null ? "" : fo.getPath();
                }

                public String displayName(Project obj) {
                    return obj.toString();
                }
            });
            return new LogicalViewRootNode((Lookup)new AbstractLookup((AbstractLookup.Content)ic));
        }

        public Node findPath(Node root, Object target) {
            Project prj = (Project)root.getLookup().lookup(Project.class);
            if (prj == null) {
                return null;
            }
            if (target instanceof FileObject) {
                FileObject fo = (FileObject)target;
                if (LogicalViewProviderImpl.isOtherProjectSource(fo, prj)) {
                    return null;
                }
                for (Node n : root.getChildren().getNodes(true)) {
                    Node result = PackageView.findPath((Node)n, (Object)target);
                    if (result == null) continue;
                    return result;
                }
            }
            return null;
        }

        private static boolean isOtherProjectSource(@NonNull FileObject fo, @NonNull Project me) {
            Project owner = FileOwnerQuery.getOwner((FileObject)fo);
            if (owner == null) {
                return false;
            }
            if (me.equals(owner)) {
                return false;
            }
            for (SourceGroup sg : ProjectUtils.getSources((Project)owner).getSourceGroups("java")) {
                if (!FileUtil.isParentOf((FileObject)sg.getRootFolder(), (FileObject)fo)) continue;
                return true;
            }
            return false;
        }

        public void addChangeListener(ChangeListener l) {
            this.changeSupport.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.changeSupport.removeChangeListener(l);
        }

        @Override
        public void testBroken() {
            this.task.schedule(500);
        }

        private boolean isCompileOnSaveDisabled() {
            return this.badgeStatus != null && this.badgeStatus.isBadgeVisible();
        }

        private void setBroken(boolean broken) {
            if (this.broken != broken) {
                this.broken = broken;
                this.changeSupport.fireChange();
            }
        }

        private void setCompileOnSaveDisabled(boolean value) {
            if (this.compileOnSaveDisabled != value) {
                this.compileOnSaveDisabled = value;
                this.changeSupport.fireChange();
            }
        }

        @NonNull
        private static Color getErrorForeground() {
            Color result = UIManager.getDefaults().getColor("nb.errorForeground");
            if (result == null) {
                result = Color.RED;
            }
            return result;
        }

        static {
            URL errorBadgeIconURL = LogicalViewProviders.class.getClassLoader().getResource(COMPILE_ON_SAVE_DISABLED_BADGE_PATH);
            String compileOnSaveDisabledTP = "<img src=\"" + errorBadgeIconURL + "\">&nbsp;" + NbBundle.getMessage(LogicalViewProviders.class, (String)"TP_CompileOnSaveDisabled");
            compileOnSaveDisabledBadge = ImageUtilities.assignToolTipToImage((Image)ImageUtilities.loadImage((String)COMPILE_ON_SAVE_DISABLED_BADGE_PATH), (String)compileOnSaveDisabledTP);
        }

        private final class LogicalViewRootNode
        extends AbstractNode
        implements ChangeListener,
        PropertyChangeListener {
            private final ProjectInformation info;

            LogicalViewRootNode(Lookup lkp) {
                super(NodeFactorySupport.createCompositeChildren((Project)LogicalViewProviderImpl.this.project, (String)String.format("Projects/%s/Nodes", LogicalViewProviderImpl.this.projectType)), lkp);
                LogicalViewProviderImpl.this.broken = ProjectProblems.isBroken((Project)LogicalViewProviderImpl.this.project);
                LogicalViewProviderImpl.this.compileOnSaveDisabled = LogicalViewProviderImpl.this.isCompileOnSaveDisabled();
                LogicalViewProviderImpl.this.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)LogicalViewProviderImpl.this));
                ProjectInformation pi = (ProjectInformation)LogicalViewProviderImpl.this.project.getLookup().lookup(ProjectInformation.class);
                this.info = pi != null ? pi : new SimpleInfo(LogicalViewProviderImpl.this.project);
                this.info.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.info));
            }

            public String getShortDescription() {
                String prjDirDispName = FileUtil.getFileDisplayName((FileObject)LogicalViewProviderImpl.this.project.getProjectDirectory());
                return NbBundle.getMessage(LogicalViewProviderImpl.class, (String)"HINT_project_root_node", (Object)prjDirDispName);
            }

            public String getHtmlDisplayName() {
                String dispName = super.getDisplayName();
                try {
                    dispName = XMLUtil.toElementContent((String)dispName);
                }
                catch (CharConversionException ex) {
                    return dispName;
                }
                return LogicalViewProviderImpl.this.broken ? "<font color=\"#" + Integer.toHexString(LogicalViewProviderImpl.getErrorForeground().getRGB() & 0xFFFFFF) + "\">" + dispName + "</font>" : null;
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                this.fireIconChange();
                this.fireOpenedIconChange();
                this.fireDisplayNameChange(null, null);
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        LogicalViewRootNode.this.fireNameChange(null, null);
                        LogicalViewRootNode.this.fireDisplayNameChange(null, null);
                    }
                });
            }

            public Action[] getActions(boolean context) {
                return CommonProjectActions.forType((String)LogicalViewProviderImpl.this.projectType);
            }

            public boolean canRename() {
                return true;
            }

            public String getName() {
                return this.info.getDisplayName();
            }

            public void setName(String s) {
                DefaultProjectOperations.performDefaultRenameOperation((Project)LogicalViewProviderImpl.this.project, (String)s);
            }

            public Image getIcon(int type) {
                Icon icon = this.info.getIcon();
                Image img = icon == null ? super.getIcon(type) : ImageUtilities.icon2Image((Icon)icon);
                return !LogicalViewProviderImpl.this.broken && LogicalViewProviderImpl.this.compileOnSaveDisabled ? ImageUtilities.mergeImages((Image)img, (Image)compileOnSaveDisabledBadge, (int)8, (int)0) : img;
            }

            public Image getOpenedIcon(int type) {
                return this.getIcon(type);
            }

            public HelpCtx getHelpCtx() {
                return LogicalViewProviderImpl.this.helpContext == null ? super.getHelpCtx() : LogicalViewProviderImpl.this.helpContext;
            }
        }
    }

    public static interface CompileOnSaveBadge {
        public boolean isBadgeVisible();

        public boolean isImportant(@NonNull String var1);
    }

    public static class LogicalViewProviderBuilder {
        private final Project project;
        private final PropertyEvaluator eval;
        private final String projectType;
        private HelpCtx helpContext;
        private CompileOnSaveBadge badgeStatus;

        private LogicalViewProviderBuilder(@NonNull Project project, @NonNull PropertyEvaluator eval, @NonNull String projectType) {
            Parameters.notNull((CharSequence)"project", (Object)project);
            Parameters.notNull((CharSequence)"eval", (Object)eval);
            Parameters.notNull((CharSequence)"projectType", (Object)projectType);
            this.project = project;
            this.eval = eval;
            this.projectType = projectType;
        }

        @NonNull
        public LogicalViewProviderBuilder setHelpCtx(@NonNull HelpCtx helpContext) {
            Parameters.notNull((CharSequence)"helpContext", (Object)helpContext);
            this.helpContext = helpContext;
            return this;
        }

        @NonNull
        public LogicalViewProviderBuilder setCompileOnSaveBadge(@NonNull CompileOnSaveBadge badgeStatus) {
            Parameters.notNull((CharSequence)"badgeStatus", (Object)badgeStatus);
            this.badgeStatus = badgeStatus;
            return this;
        }

        @NonNull
        public LogicalViewProvider2 build() {
            return new LogicalViewProviderImpl(this.project, this.eval, this.projectType, this.helpContext, this.badgeStatus);
        }
    }
}

