/*
 * Decompiled with CFR 0.152.
 */
package lucee.runtime.script;

import java.io.PrintStream;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import lucee.runtime.script.LuceeScriptEngineFactory;

public class Main {
    private static final String USAGE = "Usage: script [-options]\n\nWhere options include:\n-l  language\n-e  code\n";

    public static void main(String[] args) throws Exception {
        String lang = "CFML";
        String code = null;
        Object pw = null;
        Object key = null;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if ("-l".equals(arg)) {
                if (args.length <= i + 1) continue;
                lang = args[++i].trim();
                continue;
            }
            if (!"-e".equals(arg) || args.length <= i + 1) continue;
            code = args[++i].trim();
        }
        boolean dialect = true;
        if (code == null) {
            Main.printUsage("-e is missing", System.err);
        }
        LuceeScriptEngineFactory factory = new LuceeScriptEngineFactory();
        System.out.println(factory.getScriptEngine().eval(code));
        ScriptEngine engine = new ScriptEngineManager().getEngineByName(lang);
        if (engine == null) {
            System.out.println("could not load a engine with the name:" + lang);
        } else {
            System.out.println(engine.eval(code));
        }
    }

    private static void printUsage(String msg, PrintStream ps) {
        ps.println();
        ps.println("Failed to execute!");
        ps.println("Reason: " + msg);
        ps.println();
        ps.print(USAGE);
        ps.flush();
        System.exit(0);
    }
}

